/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.DeliveryResponsibility;
import org.wso2.andes.kernel.PreDeliveryExpiryMessageDeletionTask;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.tools.utils.MessageTracer;

public class ExpiredMessageHandler
extends DeliveryResponsibility {
    private static Log log = LogFactory.getLog(ExpiredMessageHandler.class);
    private static Log expiryLog = LogFactory.getLog((String)"MessageExpirationTask");
    private PreDeliveryExpiryMessageDeletionTask preDeliveryExpiryMessageDeletionTask;

    void setExpiryMessageDeletionTask(PreDeliveryExpiryMessageDeletionTask task) {
        this.preDeliveryExpiryMessageDeletionTask = task;
    }

    @Override
    protected boolean performResponsibility(AndesSubscription subscription, DeliverableAndesMetadata message) throws AndesException {
        boolean isOkayToProceed = true;
        if (message.isExpired()) {
            if (expiryLog.isWarnEnabled()) {
                expiryLog.warn((Object)("Message is expired. Therefore, it will not be sent. : id= " + message.getMessageID()));
            }
            message.getSlot().decrementPendingMessageCount();
            this.preDeliveryExpiryMessageDeletionTask.addMessageIdToExpiredQueue(message);
            MessageTracer.trace(message, "expired message detected in the flusher and queued for batch delete");
            isOkayToProceed = false;
        }
        return isOkayToProceed;
    }
}

