/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.nio.ByteBuffer;
import java.util.Map;
import org.wso2.andes.kernel.AndesContent;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessagePart;

public class DisruptorCachedContent
implements AndesContent {
    private final Map<Integer, AndesMessagePart> contentList;
    private final int contentLength;
    private final int maxChunkSize;

    public DisruptorCachedContent(Map<Integer, AndesMessagePart> contentList, int contentLength, int maxChunkSize) {
        this.contentList = contentList;
        this.contentLength = contentLength;
        this.maxChunkSize = maxChunkSize;
    }

    @Override
    public int putContent(int offset, ByteBuffer destinationBuffer) throws AndesException {
        int written = 0;
        int remainingBufferSpace = destinationBuffer.remaining();
        int remainingContent = this.contentLength - offset;
        int maxRemaining = Math.min(remainingBufferSpace, remainingContent);
        int currentBytePosition = offset;
        while (maxRemaining > written) {
            int chunkNumber = currentBytePosition / this.maxChunkSize;
            int chunkStartByteIndex = chunkNumber * this.maxChunkSize;
            int positionToReadFromChunk = currentBytePosition - chunkStartByteIndex;
            int remaining = maxRemaining - written;
            AndesMessagePart messagePart = this.getMessagePart(chunkStartByteIndex);
            int messagePartSize = messagePart.getDataLength();
            int numOfBytesAvailableToRead = messagePartSize - positionToReadFromChunk;
            int numOfBytesToRead = remaining > numOfBytesAvailableToRead ? numOfBytesAvailableToRead : remaining;
            destinationBuffer.put(messagePart.getData(), positionToReadFromChunk, numOfBytesToRead);
            written += numOfBytesToRead;
            currentBytePosition += numOfBytesToRead;
        }
        return written;
    }

    @Override
    public int getContentLength() {
        return this.contentLength;
    }

    private AndesMessagePart getMessagePart(int indexToQuery) throws AndesException {
        AndesMessagePart messagePart = this.contentList.get(indexToQuery);
        if (null == messagePart) {
            throw new AndesException("Content not cached for chunk index " + indexToQuery);
        }
        return messagePart;
    }

    public Map<Integer, AndesMessagePart> getContentList() {
        return this.contentList;
    }
}

