/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.DeliveryResponsibility;
import org.wso2.andes.kernel.MessageFlusher;
import org.wso2.andes.kernel.ProtocolMessage;
import org.wso2.andes.kernel.subscription.AndesSubscription;

public class DeliveryMessageHandler
extends DeliveryResponsibility {
    private static Log log = LogFactory.getLog(DeliveryMessageHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean performResponsibility(AndesSubscription subscription, DeliverableAndesMetadata message) {
        String string = subscription.getSubscriberConnection().getProtocolChannelID().toString().intern();
        synchronized (string) {
            if (!subscription.isAttached() && !message.isStale()) {
                subscription.getStorageQueue().bufferMessageForDelivery(message);
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scheduled message id= " + message.getMessageID() + " to be sent to subscription= " + subscription));
            }
            UUID subscriptionChannelID = subscription.getSubscriberConnection().getProtocolChannelID();
            message.markAsDispatchedToDeliver(subscriptionChannelID);
            ProtocolMessage protocolMessage = message.generateProtocolDeliverableMessage(subscriptionChannelID);
            subscription.getSubscriberConnection().addMessageToSendingTracker(protocolMessage);
            MessageFlusher.getInstance().getFlusherExecutor().submit(subscription, protocolMessage);
            return true;
        }
    }
}

