/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import com.gs.collections.impl.map.mutable.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.ChannelMessageStatus;
import org.wso2.andes.kernel.MessageStatus;
import org.wso2.andes.kernel.ProtocolMessage;
import org.wso2.andes.kernel.slot.Slot;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.tools.utils.MessageTracer;

public class DeliverableAndesMetadata
extends AndesMessageMetadata {
    private Map<UUID, ChannelInformation> channelDeliveryInfo;
    private List<MessageStatus> messageStatus;
    private Slot slot;
    private long timeMessageIsRead;
    private boolean isBeyondLastRollbackedMessage;
    private boolean stale;
    private static Log log = LogFactory.getLog(DeliverableAndesMetadata.class);

    public DeliverableAndesMetadata(Slot slot, long messageID, byte[] metadata, boolean parse) {
        super(messageID, metadata, parse);
        this.slot = slot;
        this.timeMessageIsRead = System.currentTimeMillis();
        this.channelDeliveryInfo = new ConcurrentHashMap<UUID, ChannelInformation>();
        this.messageStatus = Collections.synchronizedList(new ArrayList());
        this.messageStatus.add(MessageStatus.READ);
    }

    public ProtocolMessage generateProtocolDeliverableMessage(UUID channelID) {
        return new ProtocolMessage(this, channelID);
    }

    public void changeSlot(Slot slot) {
        this.slot = slot;
    }

    @Override
    public boolean isExpired() {
        if (this.expirationTime != 0L) {
            long now = System.currentTimeMillis();
            if (now > this.expirationTime) {
                this.addMessageStatus(MessageStatus.EXPIRED);
                return true;
            }
            return false;
        }
        return false;
    }

    public Slot getSlot() {
        return this.slot;
    }

    public String getStatusHistoryAsString() {
        String history = "";
        for (MessageStatus status : this.messageStatus) {
            history = history + (Object)((Object)status) + ">>";
        }
        return history;
    }

    public String getMessageStatusWithAllChannelStatus() {
        String messageStatusHistory = this.getStatusHistoryAsString();
        String deliveries = "";
        for (UUID channelID : this.getAllDeliveredChannels()) {
            deliveries = deliveries + channelID + " : " + this.channelDeliveryInfo.get(channelID).getMessageStatusHistoryForChannelAsString() + " | ";
        }
        String completeInfo = "[" + messageStatusHistory + "]" + deliveries;
        return completeInfo;
    }

    public List<MessageStatus> getStatusHistory() {
        return this.messageStatus;
    }

    public MessageStatus getLatestState() {
        MessageStatus latest = null;
        if (this.messageStatus.size() > 0) {
            latest = this.messageStatus.get(this.messageStatus.size() - 1);
        }
        return latest;
    }

    public boolean isRedelivered(UUID channelID) {
        Integer numOfDeliveries = this.channelDeliveryInfo.get(channelID).getDeliveryCount();
        return numOfDeliveries > 0;
    }

    public void rollbackDelivery(UUID channelID) {
        this.channelDeliveryInfo.get(channelID).decrementDeliveryCount();
    }

    public void markAsBuffered() {
        this.addMessageStatus(MessageStatus.BUFFERED);
    }

    public void markAsScheduledToDeliver(Collection<AndesSubscription> localSubscriptions) {
        for (AndesSubscription subscription : localSubscriptions) {
            UUID subscriptionChannelID = subscription.getSubscriberConnection().getProtocolChannelID();
            ChannelInformation channelInformation = this.channelDeliveryInfo.get(subscriptionChannelID);
            if (null != channelInformation) continue;
            channelInformation = new ChannelInformation();
            this.channelDeliveryInfo.put(subscriptionChannelID, channelInformation);
        }
        this.addMessageStatus(MessageStatus.SCHEDULED_TO_SEND);
    }

    public void markAsScheduledToDeliver(AndesSubscription subscription) {
        UUID subscriptionChannelID = subscription.getSubscriberConnection().getProtocolChannelID();
        ChannelInformation channelInformation = this.channelDeliveryInfo.get(subscriptionChannelID);
        if (null == channelInformation) {
            channelInformation = new ChannelInformation();
            this.channelDeliveryInfo.put(subscriptionChannelID, channelInformation);
        }
        this.addMessageStatus(MessageStatus.SCHEDULED_TO_SEND);
    }

    public void markAsDispatchedToDeliver(UUID channelID) {
        ChannelInformation channelInformation = this.channelDeliveryInfo.get(channelID);
        channelInformation.addChannelStatus(ChannelMessageStatus.DISPATCHED);
        if (!this.isBeyondLastRollbackedMessage) {
            int i = channelInformation.incrementDeliveryCount();
            MessageTracer.trace(this.getMessageID(), this.getDestination(), "Message within rollback id. Current count " + i);
        } else {
            MessageTracer.trace(this.getMessageID(), this.getDestination(), "Message is beyond the last rollback point. Therefore deliveryCount is not increased.");
            MessageTracer.trace(this.getMessageID(), this.getDestination(), "Message is beyond the last rollback point. Therefore deliveryCount is not increased. current count = " + channelInformation.getDeliveryCount());
        }
    }

    public boolean markAsAcknowledgedByChannel(UUID channelID) {
        boolean isAcknowledgedByAll = false;
        ChannelInformation channelInformation = this.channelDeliveryInfo.get(channelID);
        channelInformation.addChannelStatus(ChannelMessageStatus.ACKED);
        this.channelDeliveryInfo.put(channelID, channelInformation);
        if (this.isMarkAsAcked()) {
            this.addMessageStatus(MessageStatus.ACKED_BY_ALL);
            isAcknowledgedByAll = true;
        }
        return isAcknowledgedByAll;
    }

    public void markAsNackedByClient(UUID channelID) {
        ChannelInformation channelInformation = this.channelDeliveryInfo.get(channelID);
        channelInformation.addChannelStatus(ChannelMessageStatus.NACKED);
    }

    public void markAsRecoveredByClient(UUID channelID) {
        ChannelInformation channelInformation = this.channelDeliveryInfo.get(channelID);
        channelInformation.addChannelStatus(ChannelMessageStatus.RECOVERED);
    }

    public void markAsRejectedByClient(UUID channelID) {
        ChannelInformation channelInformation = this.channelDeliveryInfo.get(channelID);
        channelInformation.addChannelStatus(ChannelMessageStatus.CLIENT_REJECTED);
    }

    public void markAsDLCMessage() {
        this.addMessageStatus(MessageStatus.DLC_MESSAGE);
    }

    public boolean isDLCMessage() {
        return this.getLatestState().equals((Object)MessageStatus.DLC_MESSAGE);
    }

    public boolean isAknowledgedByAll() {
        return this.getLatestState().equals((Object)MessageStatus.ACKED_BY_ALL);
    }

    public boolean isPurgedOrDeletedOrExpired() {
        MessageStatus currentStatus = this.getLatestState();
        return currentStatus.equals((Object)MessageStatus.PURGED) || currentStatus.equals((Object)MessageStatus.EXPIRED) || currentStatus.equals((Object)MessageStatus.DELETED);
    }

    public boolean isOKToDispose() {
        return MessageStatus.isOKToRemove(this.messageStatus);
    }

    public void markAsPurgedMessage() {
        this.addMessageStatus(MessageStatus.PURGED);
    }

    public void markAsPreparedToDelete() {
        this.addMessageStatus(MessageStatus.PREPARED_TO_DELETE);
    }

    public void markAsDeletedMessage() {
        this.addMessageStatus(MessageStatus.DELETED);
    }

    public boolean isStale() {
        return this.stale;
    }

    public void markAsStale() {
        this.stale = true;
    }

    public void markAsSlotRemoved() {
        this.addMessageStatus(MessageStatus.SLOT_REMOVED);
    }

    public void markAsSlotReturned() {
        this.addMessageStatus(MessageStatus.SLOT_RETURNED);
    }

    public int markDeliveryFailureOfASentMessage(UUID channelID) {
        this.channelDeliveryInfo.get(channelID).addChannelStatus(ChannelMessageStatus.SEND_FAILED);
        return this.channelDeliveryInfo.get(channelID).decrementDeliveryCount();
    }

    public void markDeliveryFailureByProtocol(UUID channelID) {
        this.channelDeliveryInfo.get(channelID).addChannelStatus(ChannelMessageStatus.SEND_FAILED);
    }

    public void evaluateMessageAcknowledgement() {
        if (this.isMarkAsAcked()) {
            this.addMessageStatus(MessageStatus.ACKED_BY_ALL);
        }
    }

    public void markDeliveredChannelAsClosed(UUID channelID) {
        this.channelDeliveryInfo.get(channelID).addChannelStatus(ChannelMessageStatus.CLOSED);
    }

    public Set<UUID> getAllDeliveredChannels() {
        return this.channelDeliveryInfo.keySet();
    }

    private boolean isMarkAsAcked() {
        boolean isAcked = true;
        for (Map.Entry<UUID, ChannelInformation> channelInfoEntry : this.channelDeliveryInfo.entrySet()) {
            ChannelMessageStatus messageStatus = channelInfoEntry.getValue().getLatestMessageStatus();
            if (null == messageStatus) {
                isAcked = false;
                break;
            }
            if (messageStatus.equals((Object)ChannelMessageStatus.CLOSED) || messageStatus.equals((Object)ChannelMessageStatus.CLIENT_REJECTED) || messageStatus.equals((Object)ChannelMessageStatus.RECOVERED) || messageStatus.equals((Object)ChannelMessageStatus.ACKED)) continue;
            isAcked = false;
            break;
        }
        if (this.channelDeliveryInfo.isEmpty()) {
            isAcked = false;
        }
        return isAcked;
    }

    public int getNumOfDeliveries4Channel(UUID channelID) {
        if (null != this.channelDeliveryInfo.get(channelID)) {
            return this.channelDeliveryInfo.get(channelID).getDeliveryCount();
        }
        return 0;
    }

    public boolean addMessageStatus(MessageStatus state) {
        boolean isValidTransition = false;
        if (this.messageStatus.isEmpty()) {
            if (MessageStatus.READ.equals((Object)state)) {
                isValidTransition = true;
            } else {
                log.warn((Object)("Invalid message state transition suggested: " + (Object)((Object)state) + " Message ID: " + this.messageID + "slot = " + this.slot.getId()));
            }
        } else {
            isValidTransition = this.messageStatus.get(this.messageStatus.size() - 1).isValidNextTransition(state);
            if (!isValidTransition) {
                log.warn((Object)("Invalid message state transition from " + (Object)((Object)this.messageStatus.get(this.messageStatus.size() - 1)) + " suggested: " + (Object)((Object)state) + " Message ID: " + this.messageID + " slot = " + this.slot.getId() + " Message Status History >> " + this.messageStatus));
            }
        }
        this.messageStatus.add(state);
        return isValidTransition;
    }

    public String dumpMessageStatus() throws AndesException {
        StringBuilder information = new StringBuilder();
        information.append("Message ID ");
        information.append(Long.toString(this.messageID));
        information.append(',');
        information.append("Message Header ");
        information.append("null");
        information.append(',');
        information.append("Destination ");
        information.append(this.getDestination());
        information.append(',');
        information.append("Message status ");
        information.append(this.getStatusHistoryAsString());
        information.append(',');
        information.append("Slot Info {");
        information.append(this.slot.toString());
        information.append("},");
        information.append("Timestamp ");
        information.append(Long.toString(this.timeMessageIsRead));
        information.append(',');
        information.append("Expiration time ");
        information.append(Long.toString(this.expirationTime));
        information.append(',');
        information.append("Channels sent ");
        String deliveries = "";
        for (UUID channelID : this.getAllDeliveredChannels()) {
            deliveries = deliveries + channelID + " : " + this.channelDeliveryInfo.get(channelID).getMessageStatusHistoryForChannelAsString() + " | ";
        }
        information.append(deliveries);
        information.append('\n');
        return information.toString();
    }

    public void setIsBeyondLastRollbackedMessage(boolean beyondLastRollbackedMessage) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setIsBeyondLastRollbackedMessage : " + beyondLastRollbackedMessage));
        }
        this.isBeyondLastRollbackedMessage = beyondLastRollbackedMessage;
    }

    private class ChannelInformation {
        private Integer channelToNumOfDeliveries = 0;
        private List<ChannelMessageStatus> messageStatusesForChannel = new ArrayList<ChannelMessageStatus>(5);

        private ChannelInformation() {
        }

        private int incrementDeliveryCount() {
            this.channelToNumOfDeliveries = this.channelToNumOfDeliveries + 1;
            return this.channelToNumOfDeliveries;
        }

        private int decrementDeliveryCount() {
            this.channelToNumOfDeliveries = this.channelToNumOfDeliveries - 1;
            return this.channelToNumOfDeliveries;
        }

        private int getDeliveryCount() {
            return this.channelToNumOfDeliveries;
        }

        private boolean addChannelStatus(ChannelMessageStatus state) {
            boolean isValidTransition = false;
            if (this.messageStatusesForChannel.isEmpty()) {
                if (ChannelMessageStatus.DISPATCHED.equals((Object)state)) {
                    isValidTransition = true;
                    this.messageStatusesForChannel.add(state);
                } else {
                    log.warn((Object)("Invalid channel message state transition suggested: " + (Object)((Object)state) + " Message ID: " + DeliverableAndesMetadata.this.messageID + " Slot = " + DeliverableAndesMetadata.this.slot.getId() + " Message Status History >> " + DeliverableAndesMetadata.this.messageStatus));
                }
            } else {
                isValidTransition = this.messageStatusesForChannel.get(this.messageStatusesForChannel.size() - 1).isValidNextTransition(state);
                if (isValidTransition) {
                    this.messageStatusesForChannel.add(state);
                } else {
                    log.warn((Object)("Invalid channel message state transition from " + (Object)((Object)this.messageStatusesForChannel.get(this.messageStatusesForChannel.size() - 1)) + " suggested: " + (Object)((Object)state) + " Message ID: " + DeliverableAndesMetadata.this.messageID + " Slot = " + DeliverableAndesMetadata.this.slot.getId() + " Channel Status History >> " + this.messageStatusesForChannel));
                }
            }
            return isValidTransition;
        }

        private ChannelMessageStatus getLatestMessageStatus() {
            if (!this.messageStatusesForChannel.isEmpty()) {
                return this.messageStatusesForChannel.get(this.messageStatusesForChannel.size() - 1);
            }
            return null;
        }

        private String getMessageStatusHistoryForChannelAsString() {
            StringBuilder channelInfo = new StringBuilder();
            for (ChannelMessageStatus channelMessageStatus : this.messageStatusesForChannel) {
                channelInfo.append((Object)channelMessageStatus).append(">>");
            }
            return channelInfo.toString();
        }
    }
}

