/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentTrackingList<T> {
    private final LinkedList<T> dataList = new LinkedList();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public boolean contains(T item) {
        try {
            this.lock.readLock().lock();
            boolean bl = this.dataList.contains(item);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void add(T item) {
        try {
            this.lock.writeLock().lock();
            this.dataList.add(item);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void remove(T item) {
        try {
            this.lock.writeLock().lock();
            this.dataList.remove(item);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

