/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.util.EnumSet;

public enum ChannelMessageStatus {
    DISPATCHED,
    SEND_FAILED,
    ACKED,
    NACKED,
    CLIENT_REJECTED,
    RECOVERED,
    CLOSED;

    private EnumSet<ChannelMessageStatus> next;
    private EnumSet<ChannelMessageStatus> previous;

    public boolean isValidNextTransition(ChannelMessageStatus nextState) {
        return this.next.contains((Object)nextState);
    }

    public boolean isValidPreviousState(ChannelMessageStatus previousState) {
        return this.previous.contains((Object)previousState);
    }

    static {
        ChannelMessageStatus.DISPATCHED.next = EnumSet.of(SEND_FAILED, ACKED, NACKED, RECOVERED, CLOSED);
        ChannelMessageStatus.DISPATCHED.previous = EnumSet.complementOf(EnumSet.allOf(ChannelMessageStatus.class));
        ChannelMessageStatus.SEND_FAILED.next = EnumSet.of(DISPATCHED, CLIENT_REJECTED, CLOSED);
        ChannelMessageStatus.SEND_FAILED.previous = EnumSet.of(DISPATCHED);
        ChannelMessageStatus.ACKED.next = EnumSet.of(RECOVERED, CLOSED);
        ChannelMessageStatus.ACKED.previous = EnumSet.of(DISPATCHED);
        ChannelMessageStatus.NACKED.next = EnumSet.of(DISPATCHED, RECOVERED, CLOSED);
        ChannelMessageStatus.NACKED.previous = EnumSet.of(DISPATCHED);
        ChannelMessageStatus.CLIENT_REJECTED.next = EnumSet.complementOf(EnumSet.allOf(ChannelMessageStatus.class));
        ChannelMessageStatus.CLIENT_REJECTED.previous = EnumSet.of(SEND_FAILED);
        ChannelMessageStatus.RECOVERED.next = EnumSet.of(DISPATCHED, CLOSED);
        ChannelMessageStatus.RECOVERED.previous = EnumSet.of(DISPATCHED, ACKED, NACKED);
        ChannelMessageStatus.CLOSED.next = EnumSet.of(SEND_FAILED, CLOSED);
        ChannelMessageStatus.CLOSED.previous = EnumSet.allOf(ChannelMessageStatus.class);
    }
}

