/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import com.gs.collections.impl.map.mutable.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.server.ClusterResourceHolder;

public class AndesUtils {
    private static Log log = LogFactory.getLog(AndesUtils.class);
    public static final String AMQP_TOPIC_STORAGE_QUEUE_PREFIX = "AMQP_Topic";
    public static final String MQTT_TOPIC_STORAGE_QUEUE_PREFIX = "MQTT_Topic";
    private static ConcurrentHashMap<String, Long> browserMessageIdCorrelater = new ConcurrentHashMap();

    public static synchronized void registerBrowserMessageId(String browserMessageId, long andesMessageId) {
        browserMessageIdCorrelater.put(browserMessageId, andesMessageId);
    }

    public static synchronized Long getAndesMessageId(String browserMessageId) {
        Long andesMessageId = browserMessageIdCorrelater.containsKey(browserMessageId) ? browserMessageIdCorrelater.get(browserMessageId) : Long.valueOf(-1L);
        return andesMessageId;
    }

    public static String getStorageQueueForDestination(String routingKey, String messageRouterName, String queueName, boolean isQueueDurable) {
        String nodeID = ClusterResourceHolder.getInstance().getClusterManager().getMyNodeID();
        String storageQueueName = AMQPUtils.TOPIC_EXCHANGE_NAME.equals(messageRouterName) ? (!isQueueDurable ? "AMQP_Topic_" + routingKey + "_" + nodeID : queueName) : ("mqtt.topic".equals(messageRouterName) ? (!isQueueDurable ? "MQTT_Topic_" + routingKey + "_" + nodeID : queueName) : (AMQPUtils.DIRECT_EXCHANGE_NAME.equals(messageRouterName) ? routingKey : queueName));
        return storageQueueName;
    }
}

