/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AMQPConstructStore;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesContextInformationManager;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.disruptor.inbound.InboundDBSyncRequestEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventManager;
import org.wso2.andes.kernel.subscription.AndesSubscriptionManager;
import org.wso2.andes.store.FailureObservingStoreManager;
import org.wso2.andes.store.HealthAwareStore;
import org.wso2.andes.store.StoreHealthListener;

public class AndesRecoveryTask
implements Runnable,
StoreHealthListener {
    private AndesContextStore andesContextStore;
    private AMQPConstructStore amqpConstructStore;
    private AndesContextInformationManager contextInformationManager;
    private AndesSubscriptionManager subscriptionManager;
    private InboundEventManager inboundEventManager;
    private AtomicBoolean isRunning;
    AtomicBoolean isContextStoreOperational = new AtomicBoolean(true);
    private static final Log log = LogFactory.getLog(AndesRecoveryTask.class);

    public AndesRecoveryTask(AndesContextInformationManager contextInformationManager, AndesSubscriptionManager subscriptionManager, InboundEventManager inboundEventManager) {
        FailureObservingStoreManager.registerStoreHealthListener(this);
        this.andesContextStore = AndesContext.getInstance().getAndesContextStore();
        this.amqpConstructStore = AndesContext.getInstance().getAMQPConstructStore();
        this.contextInformationManager = contextInformationManager;
        this.subscriptionManager = subscriptionManager;
        this.inboundEventManager = inboundEventManager;
        this.isRunning = new AtomicBoolean(false);
    }

    @Override
    public void run() {
        if (!this.isRunning.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.isContextStoreOperational.get()) {
                this.recoverBrokerArtifacts();
            } else {
                log.warn((Object)"AndesRecoveryTask was paused due to non-operational context store.");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error in running andes recovery task", e);
        }
        finally {
            this.isRunning.set(false);
        }
    }

    public void executeNow() {
        this.run();
    }

    public void recoverBrokerArtifacts() throws AndesException {
        if (this.isContextStoreOperational.get()) {
            InboundDBSyncRequestEvent dbSyncRequestEvent = new InboundDBSyncRequestEvent();
            dbSyncRequestEvent.prepareEvent(this.andesContextStore, this.amqpConstructStore, this.contextInformationManager, this.subscriptionManager);
            this.inboundEventManager.publishStateEvent(dbSyncRequestEvent);
        } else {
            log.warn((Object)"AndesRecoveryTask was paused due to non-operational context store.");
        }
    }

    @Override
    public void storeNonOperational(HealthAwareStore store, Exception ex) {
        if (store.getClass().getSuperclass().isInstance(AndesContextStore.class)) {
            this.isContextStoreOperational.set(false);
            log.info((Object)"AndesRecoveryTask paused due to non-operational context store.");
        }
    }

    @Override
    public void storeOperational(HealthAwareStore store) {
        if (store instanceof AndesContextStore) {
            this.isContextStoreOperational.set(true);
            log.info((Object)"AndesRecoveryTask became operational. Recovering broker artifacts.");
            try {
                this.recoverBrokerArtifacts();
            }
            catch (AndesException e) {
                log.error((Object)"Error in running andes recovery task", (Throwable)e);
            }
        }
    }
}

