/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.kernel.AMQPMetaDataHandler;
import org.wso2.andes.mqtt.MQTTMessageMetaData;
import org.wso2.andes.mqtt.MQTTMetaDataHandler;
import org.wso2.andes.server.message.MessageMetaData;
import org.wso2.andes.server.store.MessageMetaDataType;
import org.wso2.andes.server.store.StorableMessageMetaData;

public class AndesMessageMetadata
implements Comparable<AndesMessageMetadata> {
    private static Log log = LogFactory.getLog(AndesMessageMetadata.class);
    long messageID;
    byte[] metadata;
    long expirationTime;
    boolean isTopic;
    String messageRouterName;
    long arrivalTime;
    private String destination;
    private String storageQueueName;
    private boolean isPersistent;
    private int messageContentLength;
    private int qosLevel;
    private MessageMetaDataType metaDataType;
    private boolean isCompressed;
    private Map<String, Object> propertyMap = new HashMap<String, Object>();
    private boolean retain;

    public AndesMessageMetadata() {
        this.retain = false;
    }

    public void setRetain(boolean retain) {
        this.retain = retain;
    }

    public AndesMessageMetadata(long messageID, byte[] metadata, boolean parse) {
        this.messageID = messageID;
        this.metadata = metadata;
        if (parse) {
            this.parseMetaData();
        }
    }

    public long getMessageID() {
        return this.messageID;
    }

    public boolean isRetain() {
        return this.retain;
    }

    public void setMessageID(long messageID) {
        this.messageID = messageID;
    }

    public int getQosLevel() {
        return this.qosLevel;
    }

    public void setQosLevel(int qosLevel) {
        this.qosLevel = qosLevel;
    }

    public byte[] getMetadata() {
        return this.metadata;
    }

    public void setMetadata(byte[] metadata) {
        this.metadata = metadata;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public boolean isTopic() {
        return this.isTopic;
    }

    public String getMessageRouterName() {
        return this.messageRouterName;
    }

    public void setMessageRouterName(String messageRouterName) {
        this.messageRouterName = messageRouterName;
    }

    public void setTopic(boolean isTopic) {
        this.isTopic = isTopic;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getStorageQueueName() {
        return this.storageQueueName;
    }

    public void setStorageQueueName(String storageQueueName) {
        this.storageQueueName = storageQueueName;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public void setPersistent(boolean persistent) {
        this.isPersistent = persistent;
    }

    public long getArrivalTime() {
        return this.arrivalTime;
    }

    public void setArrivalTime(long arrivalTime) {
        this.arrivalTime = arrivalTime;
    }

    public AndesMessageMetadata shallowCopy(long messageId) {
        AndesMessageMetadata clone = new AndesMessageMetadata();
        clone.messageID = messageId;
        clone.retain = this.retain;
        clone.metadata = this.metadata;
        clone.expirationTime = this.expirationTime;
        clone.isTopic = this.isTopic;
        clone.messageRouterName = this.messageRouterName;
        clone.destination = this.destination;
        clone.storageQueueName = this.storageQueueName;
        clone.isPersistent = this.isPersistent;
        clone.arrivalTime = this.arrivalTime;
        clone.metaDataType = this.metaDataType;
        clone.propertyMap = this.propertyMap;
        clone.messageContentLength = this.messageContentLength;
        clone.isCompressed = this.isCompressed;
        return clone;
    }

    public void updateMetadata(String newDestination, String newExchangeName, long newArrivalTime) {
        this.metadata = this.createNewMetadata(this.metadata, newDestination, newExchangeName, newArrivalTime);
        this.destination = newDestination;
        if (log.isDebugEnabled()) {
            log.debug((Object)("updated andes message metadata id= " + this.messageID + " new destination = " + newDestination));
        }
    }

    public void updateMetadata(boolean isCompressedMessage) {
        this.metadata = this.createNewMetadata(this.metadata, isCompressedMessage);
        this.isCompressed = isCompressedMessage;
        if (log.isDebugEnabled()) {
            log.debug((Object)("updated andes message metadata id = " + this.messageID + ", compression state of the message is " + isCompressedMessage));
        }
    }

    public boolean isExpired() {
        if (this.expirationTime != 0L) {
            long now = System.currentTimeMillis();
            return now > this.expirationTime;
        }
        return false;
    }

    private void parseMetaData() {
        MessageMetaDataType type;
        ByteBuffer buf = ByteBuffer.wrap(this.metadata);
        buf.position(1);
        buf = buf.slice();
        this.metaDataType = type = MessageMetaDataType.values()[this.metadata[0]];
        StorableMessageMetaData mdt = type.getFactory().createMetaData(buf);
        if (type.equals((Object)MessageMetaDataType.META_DATA_0_10) || type.equals((Object)MessageMetaDataType.META_DATA_0_8)) {
            this.isPersistent = ((MessageMetaData)mdt).isPersistent();
            this.expirationTime = ((MessageMetaData)mdt).getMessageHeader().getExpiration();
            this.arrivalTime = ((MessageMetaData)mdt).getArrivalTime();
            this.destination = ((MessageMetaData)mdt).getMessagePublishInfo().getRoutingKey().toString();
            this.messageContentLength = ((MessageMetaData)mdt).getContentSize();
            this.isTopic = ((MessageMetaData)mdt).getMessagePublishInfo().getExchange().equals(AMQPUtils.TOPIC_EXCHANGE_NAME);
            this.messageRouterName = ((MessageMetaData)mdt).getMessagePublishInfo().getExchange().toString();
            this.isCompressed = ((MessageMetaData)mdt).isCompressed();
        }
        if (type.equals((Object)MessageMetaDataType.META_DATA_MQTT)) {
            this.arrivalTime = ((MQTTMessageMetaData)mdt).getMessageArrivalTime();
            this.isTopic = ((MQTTMessageMetaData)mdt).isTopic();
            this.messageRouterName = "mqtt.topic";
            this.destination = ((MQTTMessageMetaData)mdt).getDestination();
            this.isPersistent = ((MQTTMessageMetaData)mdt).isPersistent();
            this.messageContentLength = ((MQTTMessageMetaData)mdt).getContentSize();
            this.qosLevel = ((MQTTMessageMetaData)mdt).getQosLevel();
            this.isCompressed = ((MQTTMessageMetaData)mdt).isCompressed();
        }
    }

    private byte[] createNewMetadata(byte[] originalMetadata, String routingKey, String exchangeName, long arrivalTime) {
        MessageMetaDataType type;
        ByteBuffer buf = ByteBuffer.wrap(originalMetadata);
        buf.position(1);
        buf = buf.slice();
        this.metaDataType = type = MessageMetaDataType.values()[originalMetadata[0]];
        StorableMessageMetaData originalMessageMetadata = type.getFactory().createMetaData(buf);
        byte[] underlying = MessageMetaDataType.META_DATA_MQTT.equals((Object)type) ? MQTTMetaDataHandler.constructMetadata(routingKey, buf, originalMessageMetadata, exchangeName) : AMQPMetaDataHandler.constructMetadata(routingKey, buf, originalMessageMetadata, exchangeName, arrivalTime);
        return underlying;
    }

    private byte[] createNewMetadata(byte[] originalMetadata, boolean isCompressed) {
        MessageMetaDataType type;
        ByteBuffer buf = ByteBuffer.wrap(originalMetadata);
        buf.position(1);
        buf = buf.slice();
        this.metaDataType = type = MessageMetaDataType.values()[originalMetadata[0]];
        StorableMessageMetaData originalMessageMetadata = type.getFactory().createMetaData(buf);
        byte[] underlying = MessageMetaDataType.META_DATA_MQTT.equals((Object)type) ? MQTTMetaDataHandler.constructMetadata(buf, originalMessageMetadata, isCompressed) : AMQPMetaDataHandler.constructMetadata(buf, originalMessageMetadata, isCompressed);
        return underlying;
    }

    public int getMessageContentLength() {
        return this.messageContentLength;
    }

    public void setMessageContentLength(int messageContentLength) {
        this.messageContentLength = messageContentLength;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public void setCompressed(boolean isCompressed) {
        this.isCompressed = isCompressed;
    }

    @Override
    public int compareTo(AndesMessageMetadata other) {
        if (this.getMessageID() == other.getMessageID()) {
            return 0;
        }
        return this.getMessageID() > other.getMessageID() ? 1 : -1;
    }

    public MessageMetaDataType getMetaDataType() {
        return this.metaDataType;
    }

    public void setMetaDataType(MessageMetaDataType metaDataType) {
        this.metaDataType = metaDataType;
    }

    public void addProperty(String key, Object value) {
        this.propertyMap.put(key, value);
    }

    public Object getProperty(String key) {
        return this.propertyMap.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AndesMessageMetadata)) {
            return false;
        }
        AndesMessageMetadata andesMessageMetadata = (AndesMessageMetadata)o;
        return this.getMessageID() == andesMessageMetadata.getMessageID();
    }

    public int hashCode() {
        return (int)(this.getMessageID() ^ this.getMessageID() >>> 32);
    }

    public boolean isExpirationDefined() {
        return 0L < this.expirationTime;
    }

    public String toString() {
        return "messageID : " + this.messageID + "\nmetadata array length (bytes) : " + this.metadata.length + "\nexpirationTime : " + this.expirationTime + "\nisTopic : " + this.isTopic + "\nmessageRouterName : " + this.messageRouterName + "\narrivalTime : " + this.arrivalTime + "\ndestination : " + this.destination + "\nstorageQueueName : " + this.storageQueueName + "\nisPersistent : " + this.isPersistent + "\nmessageContentLength : " + this.messageContentLength + "\nqosLevel : " + this.qosLevel + "\nmetaDataType : " + (Object)((Object)this.metaDataType) + "\nisCompressed : " + this.isCompressed + "\npropertyMap : " + this.propertyMap.toString() + "\nretain : " + this.retain;
    }
}

