/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.StoreConfiguration;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AMQPConstructStore;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesContextInformationManager;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesRecoveryTask;
import org.wso2.andes.kernel.MessageExpiryManager;
import org.wso2.andes.kernel.MessageStore;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.PeriodicExpiryMessageDeletionTask;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventManager;
import org.wso2.andes.kernel.disruptor.inbound.InboundExchangeEvent;
import org.wso2.andes.kernel.dtx.DtxRegistry;
import org.wso2.andes.kernel.registry.MessageRouterRegistry;
import org.wso2.andes.kernel.registry.StorageQueueRegistry;
import org.wso2.andes.kernel.registry.SubscriptionRegistry;
import org.wso2.andes.kernel.slot.SlotCreator;
import org.wso2.andes.kernel.slot.SlotDeletionExecutor;
import org.wso2.andes.kernel.slot.SlotManagerClusterMode;
import org.wso2.andes.kernel.subscription.AndesSubscriptionManager;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cluster.ClusterAgent;
import org.wso2.andes.server.cluster.ClusterManagementInformationMBean;
import org.wso2.andes.server.cluster.ClusterManager;
import org.wso2.andes.server.cluster.coordination.ClusterNotificationListenerManager;
import org.wso2.andes.server.cluster.coordination.CoordinationComponentFactory;
import org.wso2.andes.server.cluster.coordination.hazelcast.HazelcastAgent;
import org.wso2.andes.server.information.management.MessageStatusInformationMBean;
import org.wso2.andes.server.information.management.SubscriptionManagementInformationMBean;
import org.wso2.andes.server.queue.DLCQueueUtils;
import org.wso2.andes.server.virtualhost.VirtualHost;
import org.wso2.andes.server.virtualhost.VirtualHostConfigSynchronizer;
import org.wso2.andes.store.FailureObservingAndesContextStore;
import org.wso2.andes.store.FailureObservingMessageStore;
import org.wso2.andes.store.FailureObservingStoreManager;
import org.wso2.andes.thrift.MBThriftServer;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.UserStoreException;

public class AndesKernelBoot {
    private static Log log = LogFactory.getLog(AndesKernelBoot.class);
    private static MessageStore messageStore;
    private static AMQPConstructStore amqpConstructStore;
    private static SubscriptionRegistry subscriptionRegistry;
    private static ScheduledExecutorService andesRecoveryTaskScheduler;
    private static ScheduledExecutorService expiryMessageDeletionTaskScheduler;
    private static AndesContextStore contextStore;
    private static boolean isKernelShuttingDown;
    private static ClusterNotificationListenerManager clusterNotificationListenerManager;

    public static void initializeComponents() throws AndesException {
        isKernelShuttingDown = false;
        int threadPoolCount = 1;
        andesRecoveryTaskScheduler = Executors.newScheduledThreadPool(threadPoolCount);
        expiryMessageDeletionTaskScheduler = Executors.newScheduledThreadPool(threadPoolCount);
        AndesKernelBoot.startHouseKeepingThreads();
        AndesKernelBoot.createDefinedProtocolArtifacts();
        AndesKernelBoot.syncNodeWithClusterState();
        AndesKernelBoot.registerMBeans();
        AndesKernelBoot.startThriftServer();
        Andes.getInstance().startSafeZoneUpdateWorkers();
        int slotDeletingWorkerCount = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_SLOT_DELETE_WORKER_COUNT);
        int maxNumberOfPendingSlotsToDelete = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_SLOT_DELETE_QUEUE_DEPTH_WARNING_THRESHOLD);
        SlotDeletionExecutor.getInstance().init(slotDeletingWorkerCount, maxNumberOfPendingSlotsToDelete);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void clearMembershipEventsAndRecoverDistributedSlotMap() throws AndesException {
        if (AndesContext.getInstance().isClusteringEnabled()) {
            HazelcastAgent hazelcastAgent = HazelcastAgent.getInstance();
            try {
                hazelcastAgent.acquireInitializationLock();
                if (hazelcastAgent.isClusterInitializedSuccessfully()) return;
                AndesKernelBoot.removeNonDurableQueues();
                AndesKernelBoot.clearSlotStorage();
                ClusterAgent clusterAgent = AndesContext.getInstance().getClusterAgent();
                contextStore.setLocalSafeZoneOfNode(clusterAgent.getLocalNodeIdentifier(), 0L);
                AndesKernelBoot.recoverMapsForEachQueue();
                hazelcastAgent.indicateSuccessfulInitilization();
                return;
            }
            finally {
                hazelcastAgent.releaseInitializationLock();
            }
        } else {
            AndesKernelBoot.recoverMapsForEachQueue();
        }
    }

    private static void removeNonDurableQueues() throws AndesException {
        List<StorageQueue> queueList = contextStore.getAllQueuesStored();
        for (StorageQueue storageQueue : queueList) {
            String queueName = storageQueue.getName();
            if (storageQueue.isDurable() || !queueName.startsWith("AMQP_Topic")) continue;
            messageStore.deleteAllMessageMetadata(queueName);
            contextStore.deleteBindingInformation(AMQPUtils.TOPIC_EXCHANGE_NAME, queueName);
            contextStore.deleteQueueInformation(queueName);
            messageStore.removeQueue(queueName);
        }
    }

    private static void recoverMapsForEachQueue() throws AndesException {
        List<StorageQueue> queueList = contextStore.getAllQueuesStored();
        ArrayList futureSlotRecoveryExecutorList = new ArrayList();
        Integer concurrentReads = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.RECOVERY_MESSAGES_CONCURRENT_STORAGE_QUEUE_READS);
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("SlotRecoveryThread-%d").build();
        ExecutorService executorService = Executors.newFixedThreadPool(concurrentReads, namedThreadFactory);
        for (StorageQueue storageQueue : queueList) {
            String queueName = storageQueue.getName();
            if (DLCQueueUtils.isDeadLetterQueue(queueName)) continue;
            Future<?> submit = executorService.submit(new SlotCreator(messageStore, queueName));
            futureSlotRecoveryExecutorList.add(submit);
        }
        for (Future future : futureSlotRecoveryExecutorList) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                log.error((Object)"Error occurred in slot recovery.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.error((Object)"Error occurred in slot recovery.", (Throwable)e);
            }
        }
        executorService.shutdown();
    }

    public static void initVirtualHostConfigSynchronizer(VirtualHost defaultVirtualHost) {
        VirtualHostConfigSynchronizer _VirtualHostConfigSynchronizer = new VirtualHostConfigSynchronizer(defaultVirtualHost);
        ClusterResourceHolder.getInstance().setVirtualHostConfigSynchronizer(_VirtualHostConfigSynchronizer);
    }

    public static void shutDownAndesKernel() throws AndesException {
        isKernelShuttingDown = true;
        Andes.getInstance().shutDown();
    }

    private static AndesContextStore createAndesContextStoreFromConfig() throws Exception {
        StoreConfiguration andesConfiguration = AndesContext.getInstance().getStoreConfiguration();
        String contextStoreClassName = andesConfiguration.getAndesContextStoreClassName();
        Class<AndesContextStore> contextStoreClass = Class.forName(contextStoreClassName).asSubclass(AndesContextStore.class);
        AndesContextStore contextStoreInstance = contextStoreClass.newInstance();
        contextStoreInstance.init(andesConfiguration.getContextStoreProperties());
        log.info((Object)("AndesContextStore initialised with " + contextStoreClassName));
        return contextStoreInstance;
    }

    private static MessageStore createMessageStoreFromConfig(AndesContextStore andesContextStore, FailureObservingStoreManager failureObservingStoreManager) throws Exception {
        StoreConfiguration andesConfiguration = AndesContext.getInstance().getStoreConfiguration();
        String messageStoreClassName = andesConfiguration.getMessageStoreClassName();
        Class<MessageStore> messageStoreClass = Class.forName(messageStoreClassName).asSubclass(MessageStore.class);
        MessageStore messageStoreInConfig = messageStoreClass.newInstance();
        FailureObservingMessageStore failureObservingMessageStore = new FailureObservingMessageStore(messageStoreInConfig, failureObservingStoreManager);
        failureObservingMessageStore.initializeMessageStore(andesContextStore, andesConfiguration.getMessageStoreProperties());
        log.info((Object)("Andes MessageStore initialised with " + messageStoreClassName));
        return failureObservingMessageStore;
    }

    public static void startAndesStores() throws Exception {
        AndesContextStore contextStoreInConfig = AndesKernelBoot.createAndesContextStoreFromConfig();
        FailureObservingStoreManager failureObservingStoreManager = new FailureObservingStoreManager();
        contextStore = new FailureObservingAndesContextStore(contextStoreInConfig, failureObservingStoreManager);
        AndesContext.getInstance().setAndesContextStore(contextStore);
        messageStore = AndesKernelBoot.createMessageStoreFromConfig(contextStoreInConfig, failureObservingStoreManager);
        AndesContext.getInstance().setMessageStore(messageStore);
        amqpConstructStore = new AMQPConstructStore(contextStore);
        AndesContext.getInstance().setAMQPConstructStore(amqpConstructStore);
        MessageRouterRegistry messageRouterRegistry = new MessageRouterRegistry();
        AndesContext.getInstance().setMessageRouterRegistry(messageRouterRegistry);
        StorageQueueRegistry storageQueueRegistry = new StorageQueueRegistry();
        AndesContext.getInstance().setStorageQueueRegistry(storageQueueRegistry);
        subscriptionRegistry = new SubscriptionRegistry();
    }

    private static void startAndesComponents() throws Exception {
        AndesSubscriptionManager subscriptionManager = new AndesSubscriptionManager(subscriptionRegistry, contextStore);
        AndesContext.getInstance().setAndesSubscriptionManager(subscriptionManager);
        ClusterResourceHolder.getInstance().setSubscriptionManager(subscriptionManager);
        MessagingEngine messagingEngine = MessagingEngine.getInstance();
        messagingEngine.initialise(messageStore, new MessageExpiryManager(messageStore), subscriptionManager);
        AndesContextInformationManager contextInformationManager = new AndesContextInformationManager(amqpConstructStore, subscriptionManager, contextStore, messageStore);
        AndesContext.getInstance().setAndesContextInformationManager(contextInformationManager);
        InboundEventManager inboundEventManager = new InboundEventManager(messagingEngine);
        AndesContext.getInstance().setInboundEventManager(inboundEventManager);
        DtxRegistry dtxRegistry = new DtxRegistry(messageStore.getDtxStore(), messagingEngine, inboundEventManager);
        Andes.getInstance().initialise(messagingEngine, inboundEventManager, contextInformationManager, subscriptionManager, dtxRegistry);
        if (null != clusterNotificationListenerManager) {
            clusterNotificationListenerManager.initializeListener(inboundEventManager, subscriptionManager, contextInformationManager);
        }
    }

    private static void createDefinedProtocolArtifacts() throws AndesException {
        InboundExchangeEvent inboundExchangeEvent = new InboundExchangeEvent("mqtt.topic", "topic", false);
        Andes.getInstance().createExchange(inboundExchangeEvent);
    }

    private static void initClusterEventListener() throws AndesException {
        CoordinationComponentFactory coordinationComponentFactory = new CoordinationComponentFactory();
        clusterNotificationListenerManager = coordinationComponentFactory.createClusterNotificationListener();
        AndesContext.getInstance().setClusterNotificationListenerManager(clusterNotificationListenerManager);
    }

    public static void startAndesCluster() throws Exception {
        AndesKernelBoot.initClusterManager();
        AndesKernelBoot.initClusterEventListener();
        AndesKernelBoot.clearMembershipEventsAndRecoverDistributedSlotMap();
        AndesKernelBoot.startAndesComponents();
    }

    public static void shutDownAndesClusterEventSynchronization() throws AndesException {
        if (ClusterResourceHolder.getInstance().getClusterManager().isClusteringEnabled()) {
            clusterNotificationListenerManager.stopListener();
        }
    }

    public static void syncNodeWithClusterState() throws AndesException {
        log.info((Object)"Syncing exchanges, queues, bindings and subscriptions");
        ClusterResourceHolder.getInstance().getAndesRecoveryTask().recoverBrokerArtifacts();
        AndesContext.getInstance().getAndesSubscriptionManager().closeAllActiveLocalSubscriptions();
    }

    public static void startHouseKeepingThreads() throws AndesException {
        AndesContextInformationManager contextInformationManager = AndesContext.getInstance().getAndesContextInformationManager();
        AndesSubscriptionManager subscriptionManager = AndesContext.getInstance().getAndesSubscriptionManager();
        InboundEventManager inboundEventManager = AndesContext.getInstance().getInboundEventManager();
        AndesRecoveryTask andesRecoveryTask = new AndesRecoveryTask(contextInformationManager, subscriptionManager, inboundEventManager);
        PeriodicExpiryMessageDeletionTask periodicExpiryMessageDeletionTask = null;
        int recoveryTaskScheduledPeriod = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_FAILOVER_VHOST_SYNC_TASK_INTERVAL);
        int dbBasedDeletionTaskScheduledPeriod = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_PERIODIC_EXPIRY_MESSAGE_DELETION_INTERVAL);
        int safeDeleteRegionSlotCount = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_SAFE_DELETE_REGION_SLOT_COUNT);
        periodicExpiryMessageDeletionTask = new PeriodicExpiryMessageDeletionTask();
        andesRecoveryTaskScheduler.scheduleAtFixedRate(andesRecoveryTask, recoveryTaskScheduledPeriod, recoveryTaskScheduledPeriod, TimeUnit.SECONDS);
        if (safeDeleteRegionSlotCount >= 1) {
            expiryMessageDeletionTaskScheduler.scheduleAtFixedRate(periodicExpiryMessageDeletionTask, dbBasedDeletionTaskScheduledPeriod, dbBasedDeletionTaskScheduledPeriod, TimeUnit.SECONDS);
        } else {
            log.error((Object)("DB based expiry message deletion task is not scheduled due to not providing a valid safe delete region slot count is not given. Given slot count is " + safeDeleteRegionSlotCount));
        }
        ClusterResourceHolder.getInstance().setAndesRecoveryTask(andesRecoveryTask);
    }

    public static void stopHouseKeepingThreads() {
        log.info((Object)"Stop syncing exchanges, queues, bindings and subscriptions...");
        int threadTerminationTimePerod = 20;
        try {
            andesRecoveryTaskScheduler.shutdown();
            expiryMessageDeletionTaskScheduler.shutdown();
            expiryMessageDeletionTaskScheduler.awaitTermination(threadTerminationTimePerod, TimeUnit.SECONDS);
            andesRecoveryTaskScheduler.awaitTermination(threadTerminationTimePerod, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            andesRecoveryTaskScheduler.shutdownNow();
            log.warn((Object)"Recovery task scheduler is forcefully shutdown.");
        }
    }

    public static void registerMBeans() throws AndesException {
        try {
            ClusterManagementInformationMBean clusterManagementMBean = new ClusterManagementInformationMBean(ClusterResourceHolder.getInstance().getClusterManager());
            clusterManagementMBean.register();
            SubscriptionManagementInformationMBean subscriptionManagementInformationMBean = new SubscriptionManagementInformationMBean();
            subscriptionManagementInformationMBean.register();
            MessageStatusInformationMBean messageStatusInformationMBean = new MessageStatusInformationMBean();
            messageStatusInformationMBean.register();
        }
        catch (JMException ex) {
            throw new AndesException("Unable to register Andes MBeans", ex);
        }
    }

    private static void initClusterManager() throws AndesException {
        ClusterManager clusterManager = new ClusterManager();
        clusterManager.init();
        ClusterResourceHolder.getInstance().setClusterManager(clusterManager);
    }

    public static void reInitializeAndesStores() throws Exception {
        log.info((Object)"Reinitializing Andes Stores...");
        StoreConfiguration virtualHostsConfiguration = AndesContext.getInstance().getStoreConfiguration();
        AndesContextStore andesContextStore = AndesContext.getInstance().getAndesContextStore();
        andesContextStore.init(virtualHostsConfiguration.getContextStoreProperties());
        messageStore.initializeMessageStore(andesContextStore, virtualHostsConfiguration.getMessageStoreProperties());
    }

    public static void startMessaging() {
        Andes.getInstance().startMessageDelivery();
    }

    private static void stopMessaging() {
        Andes.getInstance().stopMessageDelivery();
    }

    private static void startThriftServer() throws AndesException {
        if (AndesContext.getInstance().isClusteringEnabled()) {
            MBThriftServer.getInstance().start(AndesContext.getInstance().getThriftServerHost(), AndesContext.getInstance().getThriftServerPort(), "MB-ThriftServer-main-thread");
        }
    }

    public static void stopThriftServer() {
        MBThriftServer.getInstance().stop();
    }

    public static void createSuperTenantDLC() throws AndesException {
        CarbonContext carbonContext = CarbonContext.getThreadLocalCarbonContext();
        try {
            String adminUserName = carbonContext.getUserRealm().getRealmConfiguration().getAdminUserName();
            DLCQueueUtils.createDLCQueue(carbonContext.getTenantDomain(), adminUserName);
        }
        catch (UserStoreException e) {
            throw new AndesException("Error getting super tenant username", e);
        }
    }

    public static boolean isKernelShuttingDown() {
        return isKernelShuttingDown;
    }

    private static void clearSlotStorage() throws AndesException {
        SlotManagerClusterMode.getInstance().clearSlotStorage();
        log.info((Object)"Slots stored in last session were cleared to avoid duplicates when recovering.");
    }

    static {
        isKernelShuttingDown = false;
    }
}

