/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AMQPConstructStore;
import org.wso2.andes.kernel.AndesBinding;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.ClusterNotificationListener;
import org.wso2.andes.kernel.MessageStore;
import org.wso2.andes.kernel.disruptor.inbound.InboundBindingEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundBindingSyncEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundExchangeEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundExchangeSyncEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundQueueEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundQueueSyncEvent;
import org.wso2.andes.kernel.disruptor.inbound.QueueInfo;
import org.wso2.andes.kernel.router.AndesMessageRouter;
import org.wso2.andes.kernel.router.MessageRouterFactory;
import org.wso2.andes.kernel.router.QueueMessageRouter;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.kernel.subscription.AndesSubscriptionManager;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cluster.coordination.ClusterNotificationAgent;
import org.wso2.andes.server.cluster.coordination.CoordinationComponentFactory;

public class AndesContextInformationManager {
    private static final Log log = LogFactory.getLog(AndesContextInformationManager.class);
    private AndesContextStore contextStore;
    private MessageRouterFactory messageRouterFactory;
    private MessageStore messageStore;
    private AMQPConstructStore amqpConstructStore;
    AndesSubscriptionManager subscriptionManager;
    private ClusterNotificationAgent clusterNotificationAgent;

    public AndesContextInformationManager(AMQPConstructStore constructStore, AndesSubscriptionManager subscriptionManager, AndesContextStore contextStore, MessageStore messageStore) throws AndesException {
        this.subscriptionManager = subscriptionManager;
        this.messageRouterFactory = new MessageRouterFactory();
        this.messageStore = messageStore;
        this.contextStore = contextStore;
        this.amqpConstructStore = constructStore;
        CoordinationComponentFactory coordinationComponentFactory = new CoordinationComponentFactory();
        this.clusterNotificationAgent = coordinationComponentFactory.createClusterNotificationAgent();
    }

    public void createExchange(InboundExchangeEvent exchangeEvent) throws AndesException {
        AndesMessageRouter messageRouter = this.messageRouterFactory.createMessageRouter(exchangeEvent.getMessageRouterName(), exchangeEvent.getType(), exchangeEvent.isAutoDelete());
        AndesContext.getInstance().getMessageRouterRegistry().registerMessageRouter(messageRouter.getName(), messageRouter);
        this.contextStore.storeExchangeInformation(messageRouter.getName(), messageRouter.encodeAsString());
        this.clusterNotificationAgent.notifyMessageRouterChange(messageRouter, ClusterNotificationListener.MessageRouterChange.Added);
    }

    public void syncExchangeCreate(InboundExchangeSyncEvent exchangeSyncEvent) throws AndesException {
        AndesMessageRouter messageRouter = this.messageRouterFactory.createMessageRouter(exchangeSyncEvent.getEncodedExchangeInfo());
        AndesContext.getInstance().getMessageRouterRegistry().registerMessageRouter(messageRouter.getName(), messageRouter);
        ClusterResourceHolder.getInstance().getVirtualHostConfigSynchronizer().clusterExchangeAdded(messageRouter);
        log.info((Object)("Message Router Sync [create]: " + messageRouter.getName()));
    }

    public void deleteExchange(InboundExchangeEvent messageRouterEvent) throws AndesException {
        AndesMessageRouter removedRouter = AndesContext.getInstance().getMessageRouterRegistry().removeMessageRouter(messageRouterEvent.getMessageRouterName());
        this.contextStore.deleteExchangeInformation(messageRouterEvent.getMessageRouterName());
        this.clusterNotificationAgent.notifyMessageRouterChange(removedRouter, ClusterNotificationListener.MessageRouterChange.Deleted);
    }

    public void syncExchangeDelete(InboundExchangeSyncEvent exchangeSyncEvent) throws AndesException {
        QueueMessageRouter mockMessageRouter = new QueueMessageRouter(exchangeSyncEvent.getEncodedExchangeInfo());
        String messageRouterName = mockMessageRouter.getName();
        AndesMessageRouter removedRouter = AndesContext.getInstance().getMessageRouterRegistry().removeMessageRouter(messageRouterName);
        ClusterResourceHolder.getInstance().getVirtualHostConfigSynchronizer().clusterExchangeRemoved(messageRouterName);
        log.info((Object)("Message Router Sync [delete]: " + removedRouter.getName()));
    }

    public int handleQueuePurge(InboundQueueEvent queuePurgeEvent) throws AndesException {
        StorageQueue queue = queuePurgeEvent.toStorageQueue();
        StorageQueue registeredQueue = AndesContext.getInstance().getStorageQueueRegistry().getStorageQueue(queue.getName());
        int numOfMessagesPurged = registeredQueue.purgeMessages();
        this.clusterNotificationAgent.notifyQueueChange(queue, ClusterNotificationListener.QueueChange.Purged);
        return numOfMessagesPurged;
    }

    public void handleQueuePurgeNotification(InboundQueueSyncEvent queuePurgeNotification) throws AndesException {
        StorageQueue queueWithEvent = queuePurgeNotification.toStorageQueue();
        StorageQueue registeredQueue = AndesContext.getInstance().getStorageQueueRegistry().getStorageQueue(queueWithEvent.getName());
        registeredQueue.purgeMessagesInMemory();
        log.info((Object)("Queue Sync [purge]: " + registeredQueue.getName()));
    }

    public void createQueue(InboundQueueEvent queueCreateEvent) throws AndesException {
        StorageQueue queueEvent = queueCreateEvent.toStorageQueue();
        StorageQueue queue = AndesContext.getInstance().getStorageQueueRegistry().registerStorageQueue(queueEvent.getName(), queueEvent.isDurable(), queueEvent.isShared(), queueEvent.getQueueOwner(), queueEvent.isExclusive());
        this.storeAndNotifyQueueAddition(queueEvent);
        log.info((Object)("Queue Created: " + queue.getName()));
    }

    public void syncQueueCreate(InboundQueueSyncEvent queueCreateEvent) throws AndesException {
        StorageQueue queueEvent = queueCreateEvent.toStorageQueue();
        StorageQueue storageQueueToAdd = AndesContext.getInstance().getStorageQueueRegistry().registerStorageQueue(queueEvent.getName(), queueEvent.isDurable(), queueEvent.isShared(), queueEvent.getQueueOwner(), queueEvent.isExclusive());
        ClusterResourceHolder.getInstance().getVirtualHostConfigSynchronizer().clusterQueueAdded(storageQueueToAdd);
        log.info((Object)("Queue Sync [create]: " + storageQueueToAdd.getName()));
    }

    public boolean checkIfQueueDeletable(String queueName) throws AndesException {
        boolean queueDeletable = false;
        Iterable<AndesSubscription> activeSubscriptions = this.subscriptionManager.getAllSubscriptionsByQueue(queueName);
        if (!activeSubscriptions.iterator().hasNext()) {
            queueDeletable = true;
        }
        return queueDeletable;
    }

    public void deleteQueue(StorageQueue storageQueue) throws AndesException {
        String storageQueueName = storageQueue.getName();
        List<AndesBinding> removedBindings = this.amqpConstructStore.removeAllBindingsForQueue(storageQueueName);
        for (AndesBinding removedBinding : removedBindings) {
            this.clusterNotificationAgent.notifyBindingsChange(removedBinding, ClusterNotificationListener.BindingChange.Deleted);
        }
        int purgedMessageCount = storageQueue.purgeMessages();
        if (log.isDebugEnabled()) {
            log.debug((Object)(purgedMessageCount + " messages purged while deleting queue " + storageQueueName));
        }
        this.contextStore.deleteQueueInformation(storageQueueName);
        this.messageStore.removeLocalQueueData(storageQueueName);
        AndesContext.getInstance().getStorageQueueRegistry().removeStorageQueue(storageQueueName);
        this.clusterNotificationAgent.notifyQueueChange(storageQueue, ClusterNotificationListener.QueueChange.Deleted);
        log.info((Object)("Queue Deleted: " + storageQueueName));
    }

    public void syncQueueDelete(InboundQueueSyncEvent queueDeleteSyncEvent) throws AndesException {
        StorageQueue storageQueue = queueDeleteSyncEvent.toStorageQueue();
        String storageQueueName = storageQueue.getName();
        if (this.subscriptionManager.isActiveLocalSubscriptionsExistForQueue(storageQueueName)) {
            AndesBinding binding = new AndesBinding(storageQueue.getMessageRouter().getName(), storageQueue, storageQueue.getMessageRouterBindingKey());
            this.storeAndNotifyQueueAddition(storageQueue);
            this.storeAndNotifyBindingAddition(binding);
            log.info((Object)"Queue Add and Binding Add notification sent due to active subscription.");
        } else {
            this.handleQueuePurgeNotification(queueDeleteSyncEvent);
            this.amqpConstructStore.removeAllBindingsForQueue(storageQueueName);
            this.messageStore.removeLocalQueueData(storageQueueName);
            StorageQueue queueToDelete = AndesContext.getInstance().getStorageQueueRegistry().removeStorageQueue(storageQueueName);
            ClusterResourceHolder.getInstance().getVirtualHostConfigSynchronizer().clusterQueueRemoved(queueToDelete);
            log.info((Object)("Queue Sync [delete]: " + storageQueueName));
        }
    }

    public void createBinding(InboundBindingEvent bindingEvent) throws AndesException {
        QueueInfo queueInfo = bindingEvent.getBoundedQueue();
        StorageQueue queue = AndesContext.getInstance().getStorageQueueRegistry().getStorageQueue(queueInfo.getQueueName());
        if (null == queue) {
            InboundQueueEvent queueCreateEvent = new InboundQueueEvent(queueInfo.getQueueName(), queueInfo.isDurable(), queueInfo.isShared(), queueInfo.getQueueOwner(), queueInfo.isExclusive());
            queueCreateEvent.prepareForCreateQueue(this);
            this.createQueue(queueCreateEvent);
            queue = AndesContext.getInstance().getStorageQueueRegistry().getStorageQueue(queueInfo.getQueueName());
        }
        String bindingKey = bindingEvent.getBindingKey();
        String messageRouterName = bindingEvent.getBoundMessageRouterName();
        AndesMessageRouter messageRouter = AndesContext.getInstance().getMessageRouterRegistry().getMessageRouter(messageRouterName);
        boolean queueAlreadyBound = queue.bindQueueToMessageRouter(bindingKey, messageRouter);
        if (!queueAlreadyBound) {
            AndesBinding binding = new AndesBinding(bindingEvent.getBoundMessageRouterName(), queue, bindingEvent.getBindingKey());
            this.storeAndNotifyBindingAddition(binding);
            log.info((Object)("Binding Created: " + binding.toString()));
        }
    }

    public void syncCreateBinding(InboundBindingSyncEvent bindingSyncEvent) throws AndesException {
        AndesBinding binding = new AndesBinding(bindingSyncEvent.getEncodedBindingInfo());
        StorageQueue queueToBind = binding.getBoundQueue();
        String messageRouterToBind = binding.getMessageRouterName();
        AndesMessageRouter messageRouter = AndesContext.getInstance().getMessageRouterRegistry().getMessageRouter(messageRouterToBind);
        boolean queueAlreadyBound = queueToBind.bindQueueToMessageRouter(binding.getBindingKey(), messageRouter);
        if (!queueAlreadyBound) {
            this.amqpConstructStore.addBinding(binding, false);
            ClusterResourceHolder.getInstance().getVirtualHostConfigSynchronizer().clusterBindingAdded(binding);
            log.info((Object)("Binding Sync [create]: " + binding.toString()));
        }
    }

    public void removeBinding(InboundBindingEvent removeBindingEvent) throws AndesException {
        String messageRouterName = removeBindingEvent.getBoundMessageRouterName();
        String boundQueueName = removeBindingEvent.getBoundedQueue().getQueueName();
        String bindingKey = removeBindingEvent.getBindingKey();
        this.removeBinding(messageRouterName, boundQueueName, bindingKey);
    }

    public void removeBinding(String messageRouterName, String boundQueueName, String bindingKey) throws AndesException {
        StorageQueue queue = AndesContext.getInstance().getStorageQueueRegistry().getStorageQueue(boundQueueName);
        AndesMessageRouter messageRouter = AndesContext.getInstance().getMessageRouterRegistry().getMessageRouter(messageRouterName);
        if (null != queue && null != messageRouter) {
            messageRouter.removeMapping(bindingKey, queue);
            AndesBinding removedBinding = this.amqpConstructStore.removeBinding(messageRouterName, boundQueueName, true);
            this.clusterNotificationAgent.notifyBindingsChange(removedBinding, ClusterNotificationListener.BindingChange.Deleted);
            log.info((Object)("Binding Deleted: " + removedBinding.toString()));
        }
    }

    public void syncRemoveBinding(InboundBindingSyncEvent bindingSyncEvent) throws AndesException {
        AndesBinding binding = new AndesBinding(bindingSyncEvent.getEncodedBindingInfo());
        if (!this.subscriptionManager.isActiveLocalSubscriptionsExistForQueue(binding.getBoundQueue().getName())) {
            AndesBinding removedBinding = this.amqpConstructStore.removeBinding(binding.getMessageRouterName(), binding.getBoundQueue().getName(), true);
            if (null != removedBinding) {
                StorageQueue boundQueue = removedBinding.getBoundQueue();
                boundQueue.unbindQueueFromMessageRouter();
                ClusterResourceHolder.getInstance().getVirtualHostConfigSynchronizer().clusterBindingRemoved(removedBinding);
                log.info((Object)("Binding Sync [delete]: " + binding.toString()));
            }
        } else {
            log.info((Object)"Binding not deleted due to active subscription.");
        }
    }

    private void storeAndNotifyQueueAddition(StorageQueue storageQueue) throws AndesException {
        String storageQueueName = storageQueue.getName();
        this.contextStore.storeQueueInformation(storageQueueName, storageQueue.encodeAsString());
        this.messageStore.addQueue(storageQueueName);
        this.clusterNotificationAgent.notifyQueueChange(storageQueue, ClusterNotificationListener.QueueChange.Added);
    }

    private void storeAndNotifyBindingAddition(AndesBinding binding) throws AndesException {
        this.amqpConstructStore.addBinding(binding, true);
        this.clusterNotificationAgent.notifyBindingsChange(binding, ClusterNotificationListener.BindingChange.Added);
    }
}

