/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.util.List;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.StoreConfiguration;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AMQPConstructStore;
import org.wso2.andes.kernel.AndesContextInformationManager;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.MessageStore;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventManager;
import org.wso2.andes.kernel.registry.MessageRouterRegistry;
import org.wso2.andes.kernel.registry.StorageQueueRegistry;
import org.wso2.andes.kernel.subscription.AndesSubscriptionManager;
import org.wso2.andes.server.cluster.ClusterAgent;
import org.wso2.andes.server.cluster.coordination.ClusterNotificationListenerManager;

public class AndesContext {
    private AndesSubscriptionManager andesSubscriptionManager;
    private AndesContextStore andesContextStore;
    private StoreConfiguration storeConfiguration;
    private boolean isClusteringEnabled;
    private AMQPConstructStore AMQPConstructStore;
    private static AndesContext instance = new AndesContext();
    private MessageStore messageStore;
    private int deliveryTimeoutForMessage;
    private ClusterAgent clusterAgent;
    private StorageQueueRegistry storageQueueRegistry;
    private MessageRouterRegistry messageRouterRegistry;
    private InboundEventManager inboundEventManager;
    private AndesContextInformationManager andesContextInformationManager;
    private ClusterNotificationListenerManager clusterNotificationListenerManager;

    public ClusterAgent getClusterAgent() {
        return this.clusterAgent;
    }

    public void setClusterAgent(ClusterAgent clusterAgent) {
        this.clusterAgent = clusterAgent;
    }

    public StoreConfiguration getStoreConfiguration() {
        return this.storeConfiguration;
    }

    public AndesSubscriptionManager getAndesSubscriptionManager() {
        return this.andesSubscriptionManager;
    }

    public void setAndesSubscriptionManager(AndesSubscriptionManager andesSubscriptionManager) {
        this.andesSubscriptionManager = andesSubscriptionManager;
    }

    public void setAndesContextStore(AndesContextStore andesContextStore) {
        this.andesContextStore = andesContextStore;
    }

    public AndesContextStore getAndesContextStore() {
        return this.andesContextStore;
    }

    public static AndesContext getInstance() {
        return instance;
    }

    public boolean isClusteringEnabled() {
        return this.isClusteringEnabled;
    }

    public void setClusteringEnabled(boolean isClusteringEnabled) {
        this.isClusteringEnabled = isClusteringEnabled;
    }

    public void setAMQPConstructStore(AMQPConstructStore AMQPConstructStore2) {
        this.AMQPConstructStore = AMQPConstructStore2;
    }

    public AMQPConstructStore getAMQPConstructStore() {
        return this.AMQPConstructStore;
    }

    public String getThriftServerHost() {
        return (String)AndesConfigurationManager.readValue(AndesConfiguration.COORDINATION_THRIFT_SERVER_HOST);
    }

    public Integer getThriftServerPort() {
        return (Integer)AndesConfigurationManager.readValue(AndesConfiguration.COORDINATION_THRIFT_SERVER_PORT);
    }

    public void constructStoreConfiguration() {
        this.storeConfiguration = new StoreConfiguration();
        this.storeConfiguration.setMessageStoreClassName((String)AndesConfigurationManager.readValue(AndesConfiguration.PERSISTENCE_MESSAGE_STORE_HANDLER));
        List<String> messageStoreProperties = AndesConfigurationManager.readValueList(AndesConfiguration.LIST_PERSISTENCE_MESSAGE_STORE_PROPERTIES);
        for (String messageStoreProperty : messageStoreProperties) {
            this.storeConfiguration.addMessageStoreProperty(messageStoreProperty, (String)AndesConfigurationManager.readValueOfChildByKey(AndesConfiguration.PERSISTENCE_MESSAGE_STORE_PROPERTY, messageStoreProperty));
        }
        this.storeConfiguration.setAndesContextStoreClassName((String)AndesConfigurationManager.readValue(AndesConfiguration.PERSISTENCE_CONTEXT_STORE_HANDLER));
        List<String> contextStoreProperties = AndesConfigurationManager.readValueList(AndesConfiguration.LIST_PERSISTENCE_CONTEXT_STORE_PROPERTIES);
        for (String contextStoreProperty : contextStoreProperties) {
            this.storeConfiguration.addContextStoreProperty(contextStoreProperty, (String)AndesConfigurationManager.readValueOfChildByKey(AndesConfiguration.PERSISTENCE_CONTEXT_STORE_PROPERTY, contextStoreProperty));
        }
    }

    public int getDeliveryTimeoutForMessage() {
        return this.deliveryTimeoutForMessage;
    }

    public void setDeliveryTimeoutForMessage(int deliveryTimeoutForMessage) {
        this.deliveryTimeoutForMessage = deliveryTimeoutForMessage;
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public void setMessageStore(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public void setStorageQueueRegistry(StorageQueueRegistry storageQueueRegistry) {
        this.storageQueueRegistry = storageQueueRegistry;
    }

    public MessageRouterRegistry getMessageRouterRegistry() {
        return this.messageRouterRegistry;
    }

    public void setMessageRouterRegistry(MessageRouterRegistry messageRouterRegistry) {
        this.messageRouterRegistry = messageRouterRegistry;
    }

    public StorageQueueRegistry getStorageQueueRegistry() {
        return this.storageQueueRegistry;
    }

    public void setInboundEventManager(InboundEventManager inboundEventManager) {
        this.inboundEventManager = inboundEventManager;
    }

    public InboundEventManager getInboundEventManager() {
        return this.inboundEventManager;
    }

    public void setAndesContextInformationManager(AndesContextInformationManager contextInformationManager) {
        this.andesContextInformationManager = contextInformationManager;
    }

    public AndesContextInformationManager getAndesContextInformationManager() {
        return this.andesContextInformationManager;
    }

    public ClusterNotificationListenerManager getClusterNotificationListenerManager() {
        return this.clusterNotificationListenerManager;
    }

    public void setClusterNotificationListenerManager(ClusterNotificationListenerManager clusterNotificationListenerManager) {
        this.clusterNotificationListenerManager = clusterNotificationListenerManager;
    }
}

