/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.FlowControlListener;
import org.wso2.andes.kernel.FlowControlManager;

public class AndesChannel {
    private static Log log = LogFactory.getLog(AndesChannel.class);
    private static AtomicLong idGenerator = new AtomicLong(0L);
    private final FlowControlListener listener;
    private final Integer flowControlLowLimit;
    private final Integer flowControlHighLimit;
    private final FlowControlManager flowControlManager;
    private final long id;
    private final ScheduledExecutorService executor;
    private Runnable flowControlTimeoutTask = new FlowControlTimeoutTask();
    private AtomicInteger messagesOnBuffer;
    private boolean flowControlEnabled;
    private boolean globalBufferBasedFlowControlEnabled;
    private boolean globalErrorBasedFlowControlEnabled;
    private ScheduledFuture<?> scheduledFlowControlTimeoutFuture;
    private String destination;
    private String identifier;

    public AndesChannel(FlowControlManager flowControlManager, String channelId, FlowControlListener listener, boolean globalBufferBasedFlowControlEnabled, boolean globalErrBasedFlowControlEnabled) {
        this.flowControlManager = flowControlManager;
        this.listener = listener;
        this.executor = flowControlManager.getScheduledExecutor();
        this.globalBufferBasedFlowControlEnabled = globalBufferBasedFlowControlEnabled;
        this.globalErrorBasedFlowControlEnabled = globalErrBasedFlowControlEnabled;
        this.flowControlLowLimit = flowControlManager.getChannelLowLimit();
        this.flowControlHighLimit = flowControlManager.getChannelHighLimit();
        this.identifier = channelId;
        this.id = idGenerator.incrementAndGet();
        this.messagesOnBuffer = new AtomicInteger(0);
        this.flowControlEnabled = false;
        log.info((Object)("Channel created (ID: " + this.getIdentifier() + ")"));
    }

    public AndesChannel(FlowControlManager flowControlManager, FlowControlListener listener, boolean globalBufferBasedFlowControlEnabled, boolean globalErrBasedFlowControlEnabled) {
        this(flowControlManager, "Internel_channel", listener, globalBufferBasedFlowControlEnabled, globalErrBasedFlowControlEnabled);
    }

    public void notifyGlobalBufferBasedFlowControlActivation() {
        this.globalBufferBasedFlowControlEnabled = true;
    }

    public void notifyGlobalBufferBasedFlowControlDeactivation() {
        this.globalBufferBasedFlowControlEnabled = false;
        this.unblockLocalChannel();
    }

    public void notifyGlobalErrorBasedFlowControlActivation() {
        this.globalErrorBasedFlowControlEnabled = true;
        this.blockLocalChannel();
    }

    public void notifyGlobalErrorBasedFlowControlDeactivation() {
        this.globalErrorBasedFlowControlEnabled = false;
        this.unblockLocalChannel();
    }

    private synchronized void unblockLocalChannel() {
        if (this.flowControlEnabled) {
            this.scheduledFlowControlTimeoutFuture.cancel(false);
            this.flowControlEnabled = false;
            this.listener.unblock();
            log.info((Object)("Flow control disabled for channel [ ID: " + this.getId() + " , Identifier: " + this.getIdentifier() + " , Destination: " + this.getDestination() + " ]"));
        }
    }

    private synchronized void blockLocalChannel() {
        if (!this.flowControlEnabled) {
            this.flowControlEnabled = true;
            this.listener.block();
            this.scheduledFlowControlTimeoutFuture = this.executor.schedule(this.flowControlTimeoutTask, 1L, TimeUnit.MINUTES);
            log.info((Object)("Flow control enabled for channel [ ID: " + this.getId() + " , Identifier: " + this.getIdentifier() + " , Destination: " + this.getDestination() + " ]"));
        }
    }

    public void recordAdditionToBuffer(int size) {
        this.flowControlManager.notifyAddition(size);
        int count = this.messagesOnBuffer.addAndGet(size);
        if (!this.flowControlEnabled && (this.globalBufferBasedFlowControlEnabled || count >= this.flowControlHighLimit || this.globalErrorBasedFlowControlEnabled)) {
            this.blockLocalChannel();
        }
    }

    public void recordRemovalFromBuffer(int size) {
        this.flowControlManager.notifyRemoval(size);
        int count = this.messagesOnBuffer.addAndGet(-size);
        if (this.flowControlEnabled && !this.globalBufferBasedFlowControlEnabled && count <= this.flowControlLowLimit && !this.globalErrorBasedFlowControlEnabled) {
            this.unblockLocalChannel();
        }
    }

    public void disconnect() {
        this.listener.disconnect();
    }

    public long getId() {
        return this.id;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    private class FlowControlTimeoutTask
    implements Runnable {
        private FlowControlTimeoutTask() {
        }

        @Override
        public void run() {
            if (AndesChannel.this.flowControlEnabled && !AndesChannel.this.globalBufferBasedFlowControlEnabled && AndesChannel.this.messagesOnBuffer.get() <= AndesChannel.this.flowControlLowLimit && !AndesChannel.this.globalErrorBasedFlowControlEnabled) {
                AndesChannel.this.unblockLocalChannel();
            }
        }
    }
}

