/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.io.Serializable;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.subscription.StorageQueue;

public class AndesBinding
implements Serializable {
    private String messageRouterName;
    private String bindingKey;
    private StorageQueue boundQueue;

    public AndesBinding(String messageRouterName, StorageQueue boundQueue, String bindingKey) {
        this.messageRouterName = messageRouterName;
        this.boundQueue = boundQueue;
        this.bindingKey = bindingKey;
    }

    public String getMessageRouterName() {
        return this.messageRouterName;
    }

    public String getBindingKey() {
        return this.bindingKey;
    }

    public StorageQueue getBoundQueue() {
        return this.boundQueue;
    }

    public AndesBinding(String bindingAsStr) throws AndesException {
        String[] propertyToken;
        block10: for (String pt : propertyToken = bindingAsStr.split(",")) {
            String[] tokens = pt.split("=");
            switch (tokens[0]) {
                case "boundMessageRouter": {
                    this.messageRouterName = tokens[1];
                    continue block10;
                }
                case "boundQueueName": {
                    this.boundQueue = AndesContext.getInstance().getStorageQueueRegistry().getStorageQueue(tokens[1]);
                    if (null != this.boundQueue) continue block10;
                    throw new AndesException("Queue to bind is not found " + tokens[1]);
                }
                case "bindingKey": {
                    this.bindingKey = tokens[1];
                }
            }
        }
    }

    public String encodeAsString() {
        return "boundMessageRouter=" + this.messageRouterName + ",boundQueueName=" + this.boundQueue.getName() + ",bindingKey=" + this.bindingKey;
    }

    public String toString() {
        return "[Binding]E=" + this.messageRouterName + "/Q=" + this.boundQueue.getName() + "/RK=" + this.bindingKey + "/D=" + this.boundQueue.isDurable() + "/EX=" + this.boundQueue.isExclusive();
    }

    public boolean equals(Object o) {
        if (o instanceof AndesBinding) {
            AndesBinding c = (AndesBinding)o;
            if (this.messageRouterName.equals(c.messageRouterName) && this.boundQueue.getName().equals(c.boundQueue.getName()) && this.bindingKey.equals(c.bindingKey)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.messageRouterName).append((Object)this.boundQueue.getName()).append((Object)this.bindingKey).toHashCode();
    }
}

