/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesAckData;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.tools.utils.MessageTracer;
import org.wso2.carbon.metrics.manager.Counter;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.Meter;
import org.wso2.carbon.metrics.manager.MetricManager;

public class AndesAckEvent {
    private static Log log = LogFactory.getLog(AndesAckEvent.class);
    private AndesAckData ackData;
    private DeliverableAndesMetadata metadataReference;
    private boolean isBaringMessageRemovable = false;

    public AndesAckEvent(AndesAckData ackData) {
        this.ackData = ackData;
    }

    public void setMetadataReference() throws AndesException {
        AndesSubscription localSubscription = AndesContext.getInstance().getAndesSubscriptionManager().getSubscriptionByProtocolChannel(this.ackData.getChannelId());
        if (null == localSubscription) {
            throw new AndesException("Cannot handle acknowledgement for message ID = " + this.ackData.getMessageId() + " as subscription is closed channelID= " + this.ackData.getChannelId());
        }
        this.metadataReference = localSubscription.getSubscriberConnection().getUnAckedMessage(this.ackData.getMessageId());
        this.addTraceLog();
    }

    public DeliverableAndesMetadata getMetadataReference() {
        return this.metadataReference;
    }

    public boolean processEvent() throws AndesException {
        boolean deleteMessage = this.metadataReference.markAsAcknowledgedByChannel(this.ackData.getChannelId());
        AndesSubscription subscription = AndesContext.getInstance().getAndesSubscriptionManager().getSubscriptionByProtocolChannel(this.ackData.getChannelId());
        subscription.onMessageAck(this.ackData.getMessageId());
        if (deleteMessage) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Ok to delete message id " + this.ackData.getMessageId()));
            }
            this.isBaringMessageRemovable = true;
        }
        return deleteMessage;
    }

    public boolean isBaringMessageRemovable() {
        return this.isBaringMessageRemovable;
    }

    private void addTraceLog() {
        MessageTracer.trace(this.metadataReference.messageID, this.metadataReference.getDestination(), "ACK metadata reference set by disruptor");
        Meter ackMeter = MetricManager.meter((String)("org.wso2.mb.ack.receive|" + this.metadataReference.getMessageRouterName() + "|" + this.metadataReference.getDestination()), (Level[])new Level[]{Level.INFO});
        ackMeter.mark();
        Counter counter = MetricManager.counter((String)("org.wso2.mb.ack.count|" + this.metadataReference.getMessageRouterName() + "|" + this.metadataReference.getDestination()), (Level[])new Level[]{Level.INFO});
        counter.inc();
    }
}

