/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.LongObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesAckData;
import org.wso2.andes.kernel.AndesChannel;
import org.wso2.andes.kernel.AndesContent;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesContextInformationManager;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.AndesMessagePart;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.FlowControlListener;
import org.wso2.andes.kernel.FlowControlManager;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.SafeZoneUpdateEventTriggeringTask;
import org.wso2.andes.kernel.SubscriptionAlreadyExistsException;
import org.wso2.andes.kernel.disruptor.DisruptorEventCallback;
import org.wso2.andes.kernel.disruptor.inbound.InboundBindingEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundChannelFlowEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundDeleteDLCMessagesEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundDeleteMessagesEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventManager;
import org.wso2.andes.kernel.disruptor.inbound.InboundExchangeEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundKernelOpsEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundMessageRecoveryEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundMessageRejectEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundQueueEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundSubscriptionEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundTransactionEvent;
import org.wso2.andes.kernel.disruptor.inbound.PubAckHandler;
import org.wso2.andes.kernel.dtx.DistributedTransaction;
import org.wso2.andes.kernel.dtx.DtxRegistry;
import org.wso2.andes.kernel.slot.SlotMessageCounter;
import org.wso2.andes.kernel.subscription.AndesSubscriptionManager;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.tools.utils.MessageTracer;
import org.wso2.carbon.metrics.manager.Counter;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.Meter;
import org.wso2.carbon.metrics.manager.MetricManager;

public class Andes {
    private static Log log = LogFactory.getLog(Andes.class);
    private static Andes instance = new Andes();
    private final int PURGE_TIMEOUT_SECONDS;
    private final FlowControlManager flowControlManager;
    private InboundEventManager inboundEventManager;
    private AndesContextInformationManager contextInformationManager;
    private MessagingEngine messagingEngine;
    private AndesSubscriptionManager subscriptionManager;
    private final ScheduledExecutorService safeZoneUpdateScheduler = Executors.newScheduledThreadPool(1);
    private static final int safeZoneUpdateTriggerInterval = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_MAX_SLOT_SUBMIT_DELAY);
    private final int maxTxBatchSize;
    private final long TX_EVENT_TIMEOUT;
    private DtxRegistry dtxRegistry;
    private List<UUID> dtxChannelList;
    private final int maxParallelDtxConnections;

    public static Andes getInstance() {
        return instance;
    }

    private Andes() {
        this.PURGE_TIMEOUT_SECONDS = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_PURGED_COUNT_TIMEOUT);
        this.flowControlManager = new FlowControlManager();
        this.maxTxBatchSize = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.MAX_TRANSACTION_BATCH_SIZE) * 1024;
        this.TX_EVENT_TIMEOUT = (Long)AndesConfigurationManager.readValue(AndesConfiguration.MAX_TRANSACTION_WAIT_TIMEOUT);
        this.maxParallelDtxConnections = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.MAX_PARALLEL_DISTRIBUTED_TRANSACTION_COUNT);
        this.dtxChannelList = new ArrayList<UUID>();
    }

    public void recoverMessagesOfChannel(UUID channelID, DisruptorEventCallback recoverOKCallback) throws AndesException {
        InboundMessageRecoveryEvent recoveryEvent = new InboundMessageRecoveryEvent(channelID, recoverOKCallback);
        this.inboundEventManager.publishMessageRecoveryEvent(recoveryEvent);
    }

    void initialise(MessagingEngine messagingEngine, InboundEventManager inboundEventManager, AndesContextInformationManager contextInformationManager, AndesSubscriptionManager subscriptionManager, DtxRegistry dtxRegistry) {
        this.contextInformationManager = contextInformationManager;
        this.messagingEngine = messagingEngine;
        this.subscriptionManager = subscriptionManager;
        this.inboundEventManager = inboundEventManager;
        this.dtxRegistry = dtxRegistry;
        log.info((Object)"Andes API initialised.");
    }

    public void startSafeZoneUpdateWorkers() {
        SafeZoneUpdateEventTriggeringTask safeZoneUpdateTask = new SafeZoneUpdateEventTriggeringTask(this.inboundEventManager);
        log.info((Object)"Starting Safe Zone Calculator for slots.");
        this.safeZoneUpdateScheduler.scheduleAtFixedRate(safeZoneUpdateTask, 5L, safeZoneUpdateTriggerInterval, TimeUnit.MILLISECONDS);
        SlotMessageCounter.getInstance().scheduleSubmitSlotToCoordinatorTimer();
    }

    public void messageReceived(AndesMessage message, AndesChannel andesChannel, PubAckHandler pubAckHandler) {
        MessageTracer.trace(message, "reached Andes core");
        this.inboundEventManager.messageReceived(message, andesChannel, pubAckHandler);
        Meter messageMeter = MetricManager.meter((String)"org.wso2.mb.message.receive", (Level[])new Level[]{Level.INFO});
        messageMeter.mark();
        Counter counter = MetricManager.counter((String)"org.wso2.mb.enqueue.count", (Level[])new Level[]{Level.INFO});
        counter.inc();
    }

    public void ackReceived(AndesAckData ackData) throws AndesException {
        Meter ackMeter = MetricManager.meter((String)"org.wso2.mb.ack.receive", (Level[])new Level[]{Level.INFO});
        ackMeter.mark();
        Counter counter = MetricManager.counter((String)"org.wso2.mb.ack.count", (Level[])new Level[]{Level.INFO});
        counter.inc();
        this.inboundEventManager.ackReceived(ackData);
    }

    public void closeLocalSubscription(InboundSubscriptionEvent subscriptionEvent) throws AndesException {
        subscriptionEvent.prepareForCloseSubscription(this.subscriptionManager);
        this.inboundEventManager.publishStateEvent(subscriptionEvent);
        try {
            subscriptionEvent.waitForCompletion();
        }
        catch (SubscriptionAlreadyExistsException e) {
            log.error((Object)"Error occurred while closing subscription ", (Throwable)e);
        }
    }

    public void openLocalSubscription(InboundSubscriptionEvent subscriptionEvent) throws AndesException {
        subscriptionEvent.prepareForNewSubscription(this.subscriptionManager);
        this.inboundEventManager.publishStateEvent(subscriptionEvent);
        subscriptionEvent.waitForCompletion();
    }

    public void unsubscribeLocalSubscription(InboundSubscriptionEvent subscriptionEvent) throws AndesException {
        this.closeLocalSubscription(subscriptionEvent);
        StorageQueue queue = AndesContext.getInstance().getStorageQueueRegistry().getStorageQueue(subscriptionEvent.getBoundStorageQueueName());
        InboundQueueEvent deleteQueueEvent = new InboundQueueEvent(queue.getName(), queue.isDurable(), queue.isShared(), queue.getQueueOwner(), queue.isExclusive());
        this.deleteQueue(deleteQueueEvent);
    }

    public void startMessageDelivery() {
        InboundKernelOpsEvent kernelOpsEvent = new InboundKernelOpsEvent();
        kernelOpsEvent.prepareForStartMessageDelivery(this.messagingEngine);
        this.inboundEventManager.publishStateEvent(kernelOpsEvent);
    }

    public void stopMessageDelivery() {
        InboundKernelOpsEvent kernelOpsEvent = new InboundKernelOpsEvent();
        kernelOpsEvent.prepareForStopMessageDelivery(this.messagingEngine);
        this.inboundEventManager.publishStateEvent(kernelOpsEvent);
    }

    public void shutDown() throws AndesException {
        InboundKernelOpsEvent kernelOpsEvent = new InboundKernelOpsEvent();
        kernelOpsEvent.gracefulShutdown(this.messagingEngine, this.inboundEventManager, this.flowControlManager, this.dtxRegistry);
        kernelOpsEvent.waitForTaskCompletion();
    }

    void startMessageExpirationWorker() {
        InboundKernelOpsEvent kernelOpsEvent = new InboundKernelOpsEvent();
        kernelOpsEvent.prepareForStartMessageExpirationWorker(this.messagingEngine);
        this.inboundEventManager.publishStateEvent(kernelOpsEvent);
    }

    void stopMessageExpirationWorker() {
        InboundKernelOpsEvent kernelOpsEvent = new InboundKernelOpsEvent();
        kernelOpsEvent.prepareForStopMessageExpirationWorker(this.messagingEngine);
        this.inboundEventManager.publishStateEvent(kernelOpsEvent);
    }

    public int purgeQueue(InboundQueueEvent queueEvent) throws AndesException {
        queueEvent.purgeQueue(this.contextInformationManager);
        this.inboundEventManager.publishStateEvent(queueEvent);
        try {
            return queueEvent.getPurgedCount(this.PURGE_TIMEOUT_SECONDS, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            log.error((Object)("Purge event timed out. Purge may have failed or may take longer than " + this.PURGE_TIMEOUT_SECONDS + " seconds"), (Throwable)e);
            return -1;
        }
    }

    public void deleteMessages(List<DeliverableAndesMetadata> messagesToRemove, boolean moveToDeadLetterChannel) throws AndesException {
        InboundDeleteMessagesEvent deleteMessagesEvent = new InboundDeleteMessagesEvent(messagesToRemove, moveToDeadLetterChannel);
        deleteMessagesEvent.prepareForDelete(this.messagingEngine);
        this.inboundEventManager.publishStateEvent(deleteMessagesEvent);
    }

    public void deleteMessages(Collection<AndesMessageMetadata> messagesToRemove, boolean moveToDeadLetterChannel) throws AndesException {
        InboundDeleteMessagesEvent deleteMessagesEvent = new InboundDeleteMessagesEvent(messagesToRemove, moveToDeadLetterChannel);
        deleteMessagesEvent.prepareForDelete(this.messagingEngine);
        this.inboundEventManager.publishStateEvent(deleteMessagesEvent);
    }

    public void deleteMessagesFromDLC(List<AndesMessageMetadata> messagesToRemove) throws AndesException {
        InboundDeleteDLCMessagesEvent deleteDLCMessagesEvent = new InboundDeleteDLCMessagesEvent(messagesToRemove);
        deleteDLCMessagesEvent.prepareForDelete(this.messagingEngine);
        this.inboundEventManager.publishStateEvent(deleteDLCMessagesEvent);
    }

    public void createQueue(InboundQueueEvent queueEvent) throws AndesException {
        queueEvent.prepareForCreateQueue(this.contextInformationManager);
        this.inboundEventManager.publishStateEvent(queueEvent);
        queueEvent.waitForCompletion();
    }

    public void deleteQueue(InboundQueueEvent queueEvent) throws AndesException {
        queueEvent.prepareForDeleteQueue(this.contextInformationManager);
        this.inboundEventManager.publishStateEvent(queueEvent);
    }

    public AndesMessagePart getMessageContentChunk(long messageID, int offsetInMessage) throws AndesException {
        return MessagingEngine.getInstance().getMessageContentChunk(messageID, offsetInMessage);
    }

    public AndesMessageMetadata getMessageMetaData(long messageID) throws AndesException {
        return MessagingEngine.getInstance().getMessageMetaData(messageID);
    }

    public void messageRejected(long messageId, UUID channelID, boolean reQueue, boolean isMessageBeyondLastRollback) throws AndesException {
        InboundMessageRejectEvent messageRejectEvent = new InboundMessageRejectEvent(messageId, channelID, reQueue);
        messageRejectEvent.prepareToRejectMessage(isMessageBeyondLastRollback);
        this.inboundEventManager.publishStateEvent(messageRejectEvent);
    }

    public void updateMetaDataInformation(String currentQueueName, List<AndesMessageMetadata> metadataList) throws AndesException {
        MessagingEngine.getInstance().updateMetaDataInformation(currentQueueName, metadataList);
    }

    public void moveMessageToDeadLetterChannel(DeliverableAndesMetadata message, String destinationQueueName) throws AndesException {
        MessagingEngine.getInstance().moveMessageToDeadLetterChannel(message, destinationQueueName);
    }

    public AndesMessagePart getContent(long messageId, int offsetValue) throws AndesException {
        return MessagingEngine.getInstance().getContent(messageId, offsetValue);
    }

    public LongObjectHashMap<List<AndesMessagePart>> getContent(LongArrayList messageIdList) throws AndesException {
        return MessagingEngine.getInstance().getContent(messageIdList);
    }

    public Map<String, Integer> getMessageCountForAllQueues(List<String> queueNames) throws AndesException {
        return MessagingEngine.getInstance().getMessageCountForAllQueues(queueNames);
    }

    public long getMessageCountOfQueue(String queueName) throws AndesException {
        return MessagingEngine.getInstance().getMessageCountOfQueue(queueName);
    }

    public long getMessageCountInDLC(String dlcQueueName) throws AndesException {
        return MessagingEngine.getInstance().getMessageCountInDLC(dlcQueueName);
    }

    public long getMessageCountInDLCForQueue(String queueName, String dlcQueueName) throws AndesException {
        return MessagingEngine.getInstance().getMessageCountInDLCForQueue(queueName, dlcQueueName);
    }

    public List<AndesMessageMetadata> getNextNMessageMetadataFromQueue(String queueName, long firstMsgId, int count) throws AndesException {
        return MessagingEngine.getInstance().getNextNMessageMetadataFromQueue(queueName, firstMsgId, count);
    }

    public List<AndesMessageMetadata> getNextNMessageMetadataInDLCForQueue(String queueName, String dlcQueueName, long firstMsgId, int count) throws AndesException {
        return MessagingEngine.getInstance().getNextNMessageMetadataInDLCForQueue(queueName, dlcQueueName, firstMsgId, count);
    }

    public List<AndesMessageMetadata> getNextNMessageMetadataFromDLC(String dlcQueueName, long firstMsgId, int count) throws AndesException {
        return MessagingEngine.getInstance().getNextNMessageMetadataFromDLC(dlcQueueName, firstMsgId, count);
    }

    public List<Long> getExpiredMessages(long lowerBoundMessageID, String queueName) throws AndesException {
        return MessagingEngine.getInstance().getExpiredMessages(lowerBoundMessageID, queueName);
    }

    public long getLastAssignedSlotMessageId(String queueName) throws AndesException {
        return MessagingEngine.getInstance().getLastAssignedSlotMessageId(queueName);
    }

    public long generateUniqueId() {
        return MessagingEngine.getInstance().generateUniqueId();
    }

    public AndesChannel createChannel(FlowControlListener listener) {
        return this.flowControlManager.createChannel(listener);
    }

    public AndesChannel createChannel(String channelId, FlowControlListener listener) throws AndesException {
        return this.flowControlManager.createChannel(channelId, listener);
    }

    public void deleteChannel(AndesChannel channel) {
        this.flowControlManager.deleteChannel(channel);
    }

    public void addBinding(InboundBindingEvent bindingsEvent) throws AndesException {
        bindingsEvent.prepareForAddBindingEvent(this.contextInformationManager);
        this.inboundEventManager.publishStateEvent(bindingsEvent);
        bindingsEvent.waitForCompletion();
    }

    public void removeBinding(InboundBindingEvent bindingEvent) throws AndesException {
        bindingEvent.prepareForRemoveBinding(this.contextInformationManager);
        this.inboundEventManager.publishStateEvent(bindingEvent);
    }

    public void createExchange(InboundExchangeEvent exchangeEvent) throws AndesException {
        exchangeEvent.prepareForCreateExchange(this.contextInformationManager);
        this.inboundEventManager.publishStateEvent(exchangeEvent);
    }

    public void deleteExchange(InboundExchangeEvent exchangeEvent) throws AndesException {
        exchangeEvent.prepareForDeleteExchange(this.contextInformationManager);
        this.inboundEventManager.publishStateEvent(exchangeEvent);
    }

    public boolean checkIfQueueDeletable(InboundQueueEvent queueEvent) throws AndesException {
        queueEvent.prepareForCheckIfQueueDeletable(this.contextInformationManager);
        this.inboundEventManager.publishStateEvent(queueEvent);
        return queueEvent.IsQueueDeletable();
    }

    public InboundTransactionEvent newTransaction(AndesChannel channel) throws AndesException {
        return new InboundTransactionEvent(this.messagingEngine, this.inboundEventManager, this.maxTxBatchSize, this.TX_EVENT_TIMEOUT, channel);
    }

    public List<DeliverableAndesMetadata> getRetainedMetadataByTopic(String topicName) throws AndesException {
        return MessagingEngine.getInstance().getRetainedMessageByTopic(topicName);
    }

    public AndesContent getRetainedMessageContent(AndesMessageMetadata metadata) throws AndesException {
        return MessagingEngine.getInstance().getRetainedMessageContent(metadata);
    }

    public void triggerRecoveryEvent() {
        this.inboundEventManager.publishRecoveryEvent();
    }

    public synchronized DistributedTransaction createDistributedTransaction(AndesChannel channel, UUID sessionID) throws AndesException {
        if (this.dtxChannelList.size() <= this.maxParallelDtxConnections) {
            DistributedTransaction distributedTransaction = new DistributedTransaction(this.dtxRegistry, this.inboundEventManager, channel);
            this.dtxChannelList.add(sessionID);
            return distributedTransaction;
        }
        throw new AndesException("Maximum number of parallel transactions limit " + this.maxParallelDtxConnections + " reached. ");
    }

    public synchronized void releaseDistributedTransaction(UUID sessionId) {
        this.dtxChannelList.remove(sessionId);
    }

    public ArrayList<Xid> getPreparedDtxTransactions() {
        return this.dtxRegistry.getPreparedTransactions();
    }

    public List<Long> getNextNMessageIdsInDLCForQueue(String sourceQueue, String dlcQueueName, long startMessageId, int messageLimit) throws AndesException {
        return MessagingEngine.getInstance().getNextNMessageIdsInDLCForQueue(sourceQueue, dlcQueueName, startMessageId, messageLimit);
    }

    public List<Long> getNextNMessageIdsInDLC(String dlcQueueName, long startMessageId, int messageLimit) throws AndesException {
        return MessagingEngine.getInstance().getNextNMessageIdsInDLC(dlcQueueName, startMessageId, messageLimit);
    }

    public void notifySubscriptionFlow(UUID channelId, boolean active, DisruptorEventCallback channelFlowCallback) {
        InboundChannelFlowEvent inboundChannelFlowEvent = new InboundChannelFlowEvent(channelId, active, channelFlowCallback);
        this.inboundEventManager.publishStateEvent(inboundChannelFlowEvent);
    }
}

