/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.nio.ByteBuffer;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.BasicContentHeaderProperties;
import org.wso2.andes.framing.ContentHeaderBody;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.server.message.AMQMessage;
import org.wso2.andes.server.message.CustomMessagePublishInfo;
import org.wso2.andes.server.message.MessageMetaData;
import org.wso2.andes.server.store.StorableMessageMetaData;

public class AMQPMetaDataHandler {
    public static byte[] constructMetadata(String routingKey, ByteBuffer buf, StorableMessageMetaData originalMetadata, String exchange, long arrivalTime) {
        ContentHeaderBody contentHeaderBody = ((MessageMetaData)originalMetadata).getContentHeaderBody();
        int contentChunkCount = ((MessageMetaData)originalMetadata).getContentChunkCount();
        long sessionID = ((MessageMetaData)originalMetadata).getPublisherSessionID();
        BasicContentHeaderProperties props = (BasicContentHeaderProperties)contentHeaderBody.getProperties();
        if (props.getExpiration() != 0L) {
            props.setExpiration(0L);
        }
        CustomMessagePublishInfo messagePublishInfo = new CustomMessagePublishInfo(originalMetadata);
        messagePublishInfo.setRoutingKey(new AMQShortString(routingKey));
        messagePublishInfo.setExchange(new AMQShortString(exchange));
        MessageMetaData modifiedMetaData = new MessageMetaData(messagePublishInfo, contentHeaderBody, sessionID, contentChunkCount, arrivalTime);
        int bodySize = 1 + modifiedMetaData.getStorableSize();
        byte[] underlying = new byte[bodySize];
        underlying[0] = (byte)modifiedMetaData.getType().ordinal();
        buf = ByteBuffer.wrap(underlying);
        buf.position(1);
        buf = buf.slice();
        modifiedMetaData.writeToBuffer(0, buf);
        return underlying;
    }

    public static byte[] constructMetadata(ByteBuffer buf, StorableMessageMetaData originalMetadata, boolean newCompressedMessageValue) {
        ContentHeaderBody contentHeaderBody = ((MessageMetaData)originalMetadata).getContentHeaderBody();
        int contentChunkCount = ((MessageMetaData)originalMetadata).getContentChunkCount();
        long arrivalTime = ((MessageMetaData)originalMetadata).getArrivalTime();
        long sessionID = ((MessageMetaData)originalMetadata).getPublisherSessionID();
        CustomMessagePublishInfo messagePublishInfo = new CustomMessagePublishInfo(originalMetadata);
        MessageMetaData modifiedMetaData = new MessageMetaData(messagePublishInfo, contentHeaderBody, sessionID, contentChunkCount, arrivalTime, newCompressedMessageValue);
        BasicContentHeaderProperties cdf = (BasicContentHeaderProperties)contentHeaderBody.getProperties();
        FieldTable headers = cdf.getHeaders();
        headers.setInteger("JMSXDeliveryCount", (Integer)5);
        int bodySize = modifiedMetaData.getStorableSize() + 1;
        byte[] underlying = new byte[bodySize];
        underlying[0] = (byte)modifiedMetaData.getType().ordinal();
        buf = ByteBuffer.wrap(underlying);
        buf.position(1);
        buf = buf.slice();
        modifiedMetaData.writeToBuffer(0, buf);
        return underlying;
    }

    public static void setIntProperty(AMQMessage message, int count) {
        MessageMetaData metaData = message.getMessageMetaData();
        ContentHeaderBody contentHeaderBody = metaData.getContentHeaderBody();
        BasicContentHeaderProperties cdf = (BasicContentHeaderProperties)contentHeaderBody.getProperties();
        FieldTable headers = cdf.getHeaders();
        headers.setInteger("JMSXDeliveryCount", (Integer)count);
        ((BasicContentHeaderProperties)message.getMessageMetaData().getContentHeaderBody().getProperties()).setHeaders(headers);
    }
}

