/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.andes.kernel.AndesBinding;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.AndesException;

public class AMQPConstructStore {
    private AndesContextStore andesContextStore;
    private Map<String, Map<String, AndesBinding>> andesBindings = new HashMap<String, Map<String, AndesBinding>>();

    public AMQPConstructStore(AndesContextStore contextStore) throws AndesException {
        this.andesContextStore = contextStore;
    }

    public void addBinding(AndesBinding binding, boolean isLocal) throws AndesException {
        String messageRouterName = binding.getMessageRouterName();
        String boundQueueName = binding.getBoundQueue().getName();
        if (isLocal) {
            this.andesContextStore.storeBindingInformation(messageRouterName, boundQueueName, binding.encodeAsString());
        }
        if (this.andesBindings.get(messageRouterName) != null) {
            this.andesBindings.get(messageRouterName).put(boundQueueName, binding);
        } else {
            HashMap<String, AndesBinding> tempBindingMap = new HashMap<String, AndesBinding>();
            tempBindingMap.put(boundQueueName, binding);
            this.andesBindings.put(messageRouterName, tempBindingMap);
        }
    }

    public AndesBinding removeBinding(String exchangeName, String queueName, boolean isLocal) throws AndesException {
        if (isLocal) {
            this.andesContextStore.deleteBindingInformation(exchangeName, queueName);
        }
        AndesBinding removedBinding = null;
        if (this.andesBindings.get(exchangeName).get(queueName) != null) {
            removedBinding = this.andesBindings.get(exchangeName).remove(queueName);
        }
        if (this.andesBindings.get(exchangeName).isEmpty()) {
            this.andesBindings.remove(exchangeName);
        }
        return removedBinding;
    }

    public List<AndesBinding> getBindingsForExchange(String exchange) throws AndesException {
        ArrayList<AndesBinding> bindings = new ArrayList<AndesBinding>();
        if (this.andesBindings.get(exchange) != null) {
            bindings.addAll(this.andesBindings.get(exchange).values());
        }
        return bindings;
    }

    public List<AndesBinding> removeAllBindingsForQueue(String queueName) throws AndesException {
        ArrayList<AndesBinding> bindings = new ArrayList<AndesBinding>();
        for (Map<String, AndesBinding> queueBindingMap : this.andesBindings.values()) {
            queueBindingMap.remove(queueName);
        }
        return bindings;
    }
}

