/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_91;

import java.util.Arrays;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.DtxEndBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_0_91.AMQMethodBody_0_91;
import org.wso2.andes.framing.amqp_0_91.MethodDispatcher_0_91;
import org.wso2.org.apache.mina.common.ByteBuffer;

public class DtxEndBodyImpl
extends AMQMethodBody_0_91
implements DtxEndBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new DtxEndBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 100;
    public static final int METHOD_ID = 30;
    private final int _format;
    private final byte[] _globalId;
    private final byte[] _branchId;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public DtxEndBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._format = this.readUnsignedShort(buffer);
        this._globalId = this.readBytes(buffer);
        this._branchId = this.readBytes(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public DtxEndBodyImpl(int format, byte[] globalId, byte[] branchId, boolean fail, boolean suspend) {
        this._format = format;
        this._globalId = globalId;
        this._branchId = branchId;
        byte bitfield0 = 0;
        if (fail) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (suspend) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 100;
    }

    @Override
    public int getMethod() {
        return 30;
    }

    @Override
    public final int getFormat() {
        return this._format;
    }

    @Override
    public final byte[] getGlobalId() {
        return this._globalId;
    }

    @Override
    public final byte[] getBranchId() {
        return this._branchId;
    }

    @Override
    public final boolean getFail() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    public final boolean getSuspend() {
        return (this._bitfield0 & 2) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._globalId);
        return size += this.getSizeOf(this._branchId);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._format);
        this.writeBytes(buffer, this._globalId);
        this.writeBytes(buffer, this._branchId);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_91)dispatcher).dispatchDtxEnd(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[DtxEndBodyImpl: ");
        buf.append("format=");
        buf.append(this.getFormat());
        buf.append(", ");
        buf.append("globalId=");
        buf.append(this.getGlobalId() == null ? "null" : Arrays.toString(this.getGlobalId()));
        buf.append(", ");
        buf.append("branchId=");
        buf.append(this.getBranchId() == null ? "null" : Arrays.toString(this.getBranchId()));
        buf.append(", ");
        buf.append("fail=");
        buf.append(this.getFail());
        buf.append(", ");
        buf.append("suspend=");
        buf.append(this.getSuspend());
        buf.append("]");
        return buf.toString();
    }
}

