/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_91;

import java.util.Arrays;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.DtxCommitBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_0_91.AMQMethodBody_0_91;
import org.wso2.andes.framing.amqp_0_91.MethodDispatcher_0_91;
import org.wso2.org.apache.mina.common.ByteBuffer;

public class DtxCommitBodyImpl
extends AMQMethodBody_0_91
implements DtxCommitBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new DtxCommitBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 100;
    public static final int METHOD_ID = 40;
    private final int _format;
    private final byte[] _globalId;
    private final byte[] _branchId;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public DtxCommitBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._format = this.readUnsignedShort(buffer);
        this._globalId = this.readBytes(buffer);
        this._branchId = this.readBytes(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public DtxCommitBodyImpl(int format, byte[] globalId, byte[] branchId, boolean onePhase) {
        this._format = format;
        this._globalId = globalId;
        this._branchId = branchId;
        byte bitfield0 = 0;
        if (onePhase) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 100;
    }

    @Override
    public int getMethod() {
        return 40;
    }

    @Override
    public final int getFormat() {
        return this._format;
    }

    @Override
    public final byte[] getGlobalId() {
        return this._globalId;
    }

    @Override
    public final byte[] getBranchId() {
        return this._branchId;
    }

    @Override
    public final boolean getOnePhase() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._globalId);
        return size += this.getSizeOf(this._branchId);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._format);
        this.writeBytes(buffer, this._globalId);
        this.writeBytes(buffer, this._branchId);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_91)dispatcher).dispatchDtxCommit(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[DtxCommitBodyImpl: ");
        buf.append("format=");
        buf.append(this.getFormat());
        buf.append(", ");
        buf.append("globalId=");
        buf.append(this.getGlobalId() == null ? "null" : Arrays.toString(this.getGlobalId()));
        buf.append(", ");
        buf.append("branchId=");
        buf.append(this.getBranchId() == null ? "null" : Arrays.toString(this.getBranchId()));
        buf.append(", ");
        buf.append("onePhase=");
        buf.append(this.getOnePhase());
        buf.append("]");
        return buf.toString();
    }
}

