/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.configuration.qpid.plugins;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.wso2.andes.configuration.qpid.plugins.ConfigurationPlugin;
import org.wso2.andes.configuration.qpid.plugins.ConfigurationPluginFactory;
import org.wso2.andes.configuration.qpid.plugins.SlowConsumerDetectionPolicyConfiguration;
import org.wso2.andes.policies.SlowConsumerPolicyPlugin;
import org.wso2.andes.policies.SlowConsumerPolicyPluginFactory;
import org.wso2.andes.server.plugins.PluginManager;
import org.wso2.andes.server.registry.ApplicationRegistry;

public class SlowConsumerDetectionQueueConfiguration
extends ConfigurationPlugin {
    private SlowConsumerPolicyPlugin _policyPlugin;

    @Override
    public String[] getElementsProcessed() {
        return new String[]{"messageAge", "depth", "messageCount"};
    }

    public long getMessageAge() {
        return this.getLongValue("messageAge");
    }

    public long getDepth() {
        return this.getLongValue("depth");
    }

    public long getMessageCount() {
        return this.getLongValue("messageCount");
    }

    public SlowConsumerPolicyPlugin getPolicy() {
        return this._policyPlugin;
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
        SlowConsumerPolicyPluginFactory pluginFactory;
        if (!(this.containsPositiveLong("messageAge") || this.containsPositiveLong("depth") || this.containsPositiveLong("messageCount"))) {
            throw new ConfigurationException("At least one configuration property('messageAge','depth' or 'messageCount') must be specified.");
        }
        SlowConsumerDetectionPolicyConfiguration policyConfig = (SlowConsumerDetectionPolicyConfiguration)this.getConfiguration(SlowConsumerDetectionPolicyConfiguration.class.getName());
        PluginManager pluginManager = ApplicationRegistry.getInstance().getPluginManager();
        Map<String, SlowConsumerPolicyPluginFactory> factories = pluginManager.getSlowConsumerPlugins();
        if (policyConfig == null) {
            throw new ConfigurationException("No Slow Consumer Policy specified. Known Policies:" + factories.keySet());
        }
        if (_logger.isDebugEnabled()) {
            Iterator<String> keys = policyConfig.getConfig().getKeys();
            while (keys.hasNext()) {
                String key = keys.next();
                _logger.debug((Object)("Policy Keys:" + key));
            }
        }
        if ((pluginFactory = factories.get(policyConfig.getPolicyName().toLowerCase())) == null) {
            throw new ConfigurationException("Unknown Slow Consumer Policy specified:" + policyConfig.getPolicyName() + " Known Policies:" + factories.keySet());
        }
        this._policyPlugin = (SlowConsumerPolicyPlugin)pluginFactory.newInstance(policyConfig);
        _logger.debug((Object)this);
    }

    @Override
    public String formatToString() {
        StringBuilder sb = new StringBuilder();
        if (this.getMessageAge() > 0L) {
            sb.append("Age:").append(this.getMessageAge()).append(":");
        }
        if (this.getDepth() > 0L) {
            sb.append("Depth:").append(this.getDepth()).append(":");
        }
        if (this.getMessageCount() > 0L) {
            sb.append("Count:").append(this.getMessageCount()).append(":");
        }
        sb.append("Policy[").append(this.getPolicy()).append("]");
        return sb.toString();
    }

    public static class SlowConsumerDetectionQueueConfigurationFactory
    implements ConfigurationPluginFactory {
        @Override
        public ConfigurationPlugin newInstance(String path, Configuration config) throws ConfigurationException {
            SlowConsumerDetectionQueueConfiguration slowConsumerConfig = new SlowConsumerDetectionQueueConfiguration();
            slowConsumerConfig.setConfiguration(path, config);
            return slowConsumerConfig;
        }

        @Override
        public List<String> getParentPaths() {
            return Arrays.asList("virtualhosts.virtualhost.queues.slow-consumer-detection", "virtualhosts.virtualhost.queues.queue.slow-consumer-detection", "virtualhosts.virtualhost.topics.slow-consumer-detection", "virtualhosts.virtualhost.topics.topic.slow-consumer-detection");
        }
    }
}

