/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.configuration.qpid.plugins;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.wso2.andes.configuration.qpid.plugins.ConfigurationPlugin;
import org.wso2.andes.configuration.qpid.plugins.ConfigurationPluginFactory;

public class SlowConsumerDetectionPolicyConfiguration
extends ConfigurationPlugin {
    @Override
    public String[] getElementsProcessed() {
        return new String[]{"name"};
    }

    public String getPolicyName() {
        return this.getStringValue("name");
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
        if (this.getPolicyName() == null) {
            throw new ConfigurationException("No Slow consumer policy defined.");
        }
    }

    @Override
    public String formatToString() {
        return "Policy:" + this.getPolicyName();
    }

    public static class SlowConsumerDetectionPolicyConfigurationFactory
    implements ConfigurationPluginFactory {
        @Override
        public ConfigurationPlugin newInstance(String path, Configuration config) throws ConfigurationException {
            SlowConsumerDetectionPolicyConfiguration slowConsumerConfig = new SlowConsumerDetectionPolicyConfiguration();
            slowConsumerConfig.setConfiguration(path, config);
            return slowConsumerConfig;
        }

        @Override
        public List<String> getParentPaths() {
            return Arrays.asList("virtualhosts.virtualhost.queues.slow-consumer-detection.policy", "virtualhosts.virtualhost.queues.queue.slow-consumer-detection.policy", "virtualhosts.virtualhost.topics.slow-consumer-detection.policy", "virtualhosts.virtualhost.topics.topic.slow-consumer-detection.policy");
        }
    }
}

