/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.configuration.qpid.plugins;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.wso2.andes.configuration.qpid.plugins.ConfigurationPlugin;
import org.wso2.andes.configuration.qpid.plugins.ConfigurationPluginFactory;

public class SlowConsumerDetectionConfiguration
extends ConfigurationPlugin {
    TimeUnit _timeUnit = TimeUnit.SECONDS;

    @Override
    public String[] getElementsProcessed() {
        return new String[]{"delay", "timeunit"};
    }

    public long getDelay() {
        return this.getLongValue("delay", 10L);
    }

    public TimeUnit getTimeUnit() {
        return this._timeUnit;
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
        this.validatePositiveLong("delay");
        String timeUnit = this.getStringValue("timeunit");
        if (timeUnit != null) {
            try {
                this._timeUnit = TimeUnit.valueOf(timeUnit.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                throw new ConfigurationException("Unable to configure Slow Consumer Detection invalid TimeUnit:" + timeUnit);
            }
        }
    }

    public static class SlowConsumerDetectionConfigurationFactory
    implements ConfigurationPluginFactory {
        @Override
        public ConfigurationPlugin newInstance(String path, Configuration config) throws ConfigurationException {
            SlowConsumerDetectionConfiguration slowConsumerConfig = new SlowConsumerDetectionConfiguration();
            slowConsumerConfig.setConfiguration(path, config);
            return slowConsumerConfig;
        }

        @Override
        public List<String> getParentPaths() {
            return Arrays.asList("virtualhosts.virtualhost.slow-consumer-detection");
        }
    }
}

