/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.configuration.qpid;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.andes.configuration.qpid.BrokerConfig;
import org.wso2.andes.configuration.qpid.ConfigStore;
import org.wso2.andes.configuration.qpid.ConfiguredObject;
import org.wso2.andes.configuration.qpid.SystemConfig;
import org.wso2.andes.configuration.qpid.SystemConfigType;

public class SystemConfigImpl
implements SystemConfig {
    private static final String OS_NAME = System.getProperty("os.name");
    private static final String OS_ARCH = System.getProperty("os.arch");
    private static final String OS_VERSION = System.getProperty("os.version");
    private final UUID _id;
    private String _name;
    private final String _host;
    private final Map<UUID, BrokerConfig> _brokers = new ConcurrentHashMap<UUID, BrokerConfig>();
    private final long _createTime = System.currentTimeMillis();
    private final ConfigStore _store;

    public SystemConfigImpl(ConfigStore store) {
        this(store.createId(), store);
    }

    public SystemConfigImpl(UUID id, ConfigStore store) {
        String host;
        this._id = id;
        this._store = store;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            host = addr.getHostName();
        }
        catch (UnknownHostException e) {
            host = "localhost";
        }
        this._host = host;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getOperatingSystemName() {
        return OS_NAME;
    }

    @Override
    public String getNodeName() {
        return this._host;
    }

    @Override
    public String getOSRelease() {
        return OS_VERSION;
    }

    @Override
    public String getOSVersion() {
        return "";
    }

    @Override
    public String getOSArchitecture() {
        return OS_ARCH;
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public SystemConfigType getConfigType() {
        return SystemConfigType.getInstance();
    }

    @Override
    public ConfiguredObject getParent() {
        return null;
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public void addBroker(BrokerConfig broker) {
        broker.setSystem(this);
        this._store.addConfiguredObject(broker);
        this._brokers.put(broker.getId(), broker);
    }

    @Override
    public void removeBroker(BrokerConfig broker) {
        this._brokers.remove(broker.getId());
        this._store.removeConfiguredObject(broker);
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }
}

