/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.configuration.qpid;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationFactory;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.configuration.modules.JKSStore;
import org.wso2.andes.configuration.qpid.VirtualHostConfiguration;
import org.wso2.andes.configuration.qpid.plugins.ConfigurationPlugin;
import org.wso2.andes.server.registry.ApplicationRegistry;
import org.wso2.andes.server.virtualhost.VirtualHost;
import org.wso2.andes.server.virtualhost.VirtualHostRegistry;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ServerConfiguration
extends ConfigurationPlugin
implements SignalHandler {
    protected static final Logger _logger = Logger.getLogger(ServerConfiguration.class);
    public static final int DEFAULT_BUFFER_SIZE = 262144;
    public static final int DEFAULT_SOCKET_BUFFER_SIZE = 32768;
    public static final String DEFAULT_STATUS_UPDATES = "on";
    public static final String SECURITY_CONFIG_RELOADED = "SECURITY CONFIGURATION RELOADED";
    public static final int DEFAULT_FRAME_SIZE = 65536;
    public static final int DEFAULT_PORT = 5672;
    public static final int DEFAULT_SSL_PORT = 8672;
    public static final long DEFAULT_HOUSEKEEPING_PERIOD = 30000L;
    public static final int DEFAULT_JMXPORT = 8999;
    public static final String QPID_HOME = "QPID_HOME";
    public static final String QPID_WORK = "QPID_WORK";
    private Map<String, VirtualHostConfiguration> _virtualHosts = new HashMap<String, VirtualHostConfiguration>();
    private File _configFile;
    private File _vhostsFile;
    private static final Map<String, String> envVarMap = new HashMap<String, String>();
    public static final String MGMT_CUSTOM_REGISTRY_SOCKET = "management.custom-registry-socket";
    public static final String STATUS_UPDATES = "status-updates";
    public static final String ADVANCED_LOCALE = "advanced.locale";

    public ServerConfiguration(File configurationURL) throws ConfigurationException {
        this(ServerConfiguration.parseConfig(configurationURL));
        this._configFile = configurationURL;
        try {
            Signal sig = new Signal("HUP");
            Signal.handle(sig, this);
        }
        catch (Exception e) {
            _logger.info((Object)("Signal HUP not supported for OS: " + System.getProperty("os.name")));
        }
    }

    public ServerConfiguration(Configuration conf) {
        this._configuration = conf;
    }

    public void initialise() throws ConfigurationException {
        this.setConfiguration("", this._configuration);
        this.setupVirtualHosts(this._configuration);
    }

    @Override
    public String[] getElementsProcessed() {
        return new String[]{""};
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
        if (this.getListValue("security.jmx.access").size() > 0) {
            String message = "Validation error : security/jmx/access is no longer a supported element within the configuration xml." + (this._configFile == null ? "" : " Configuration file : " + this._configFile);
            throw new ConfigurationException(message);
        }
        if (this.getListValue("security.jmx.principal-database").size() > 0) {
            String message = "Validation error : security/jmx/principal-database is no longer a supported element within the configuration xml." + (this._configFile == null ? "" : " Configuration file : " + this._configFile);
            throw new ConfigurationException(message);
        }
        if (this.getListValue("security.principal-databases.principal-database(0).class").size() > 0) {
            String message = "Validation error : security/principal-databases is no longer supported within the configuration xml." + (this._configFile == null ? "" : " Configuration file : " + this._configFile);
            throw new ConfigurationException(message);
        }
    }

    protected void setupVirtualHosts(Configuration conf) throws ConfigurationException {
        String[] vhostFiles = conf.getStringArray("virtualhosts");
        Configuration vhostConfig = conf.subset("virtualhosts");
        if (vhostFiles.length != 0 && !vhostConfig.subset("virtualhost").isEmpty()) {
            throw new ConfigurationException("Only one of external or embedded virtualhosts configuration allowed.");
        }
        if (vhostFiles.length > 1) {
            throw new ConfigurationException("Only one external virtualhosts configuration file allowed, multiple filenames found.");
        }
        Configuration vhostConfiguration = new HierarchicalConfiguration();
        if (!vhostConfig.subset("virtualhost").isEmpty()) {
            vhostConfiguration = vhostConfig;
        } else {
            for (String fileName : vhostFiles) {
                this._vhostsFile = new File(fileName);
                if (!this._vhostsFile.exists()) {
                    throw new ConfigurationException("Virtualhosts file does not exist");
                }
                vhostConfiguration = ServerConfiguration.parseConfig(new File(fileName));
                String defaultVirtualHost = vhostConfiguration.getString("default");
                this._configuration.setProperty("virtualhosts.default", defaultVirtualHost);
            }
        }
        List<Object> hosts = vhostConfiguration.getList("virtualhost.name");
        for (Object host : hosts) {
            String name = (String)host;
            VirtualHostConfiguration virtualhost = new VirtualHostConfiguration(name, vhostConfiguration.subset("virtualhost." + name));
            this._virtualHosts.put(virtualhost.getName(), virtualhost);
        }
    }

    private static void substituteEnvironmentVariables(Configuration conf) {
        for (Map.Entry<String, String> var : envVarMap.entrySet()) {
            String val = System.getenv(var.getKey());
            if (val == null) continue;
            conf.setProperty(var.getValue(), val);
        }
    }

    private static Configuration parseConfig(File file) throws ConfigurationException {
        ConfigurationFactory factory = new ConfigurationFactory();
        factory.setConfigurationFileName(file.getAbsolutePath());
        Configuration conf = factory.getConfiguration();
        Iterator<String> keys = conf.getKeys();
        if (!keys.hasNext()) {
            conf = ServerConfiguration.flatConfig(file);
        }
        ServerConfiguration.substituteEnvironmentVariables(conf);
        return conf;
    }

    public boolean getStatusUpdatesEnabled() {
        String value = this.getStringValue(STATUS_UPDATES, DEFAULT_STATUS_UPDATES);
        return value.equalsIgnoreCase(DEFAULT_STATUS_UPDATES);
    }

    public Locale getLocale() {
        Locale locale;
        String localeString = this.getStringValue(ADVANCED_LOCALE);
        if (localeString == null) {
            return Locale.getDefault();
        }
        String[] parts = localeString.split("_");
        switch (parts.length) {
            case 1: {
                locale = new Locale(localeString);
                break;
            }
            case 2: {
                locale = new Locale(parts[0], parts[1]);
                break;
            }
            default: {
                StringBuilder variant = new StringBuilder(parts[2]);
                if (parts.length > 3) {
                    for (int index = 3; index < parts.length; ++index) {
                        variant.append('_').append(parts[index]);
                    }
                }
                locale = new Locale(parts[0], parts[1], variant.toString());
            }
        }
        return locale;
    }

    public static Configuration flatConfig(File file) throws ConfigurationException {
        final MyConfiguration conf = new MyConfiguration();
        conf.addConfiguration(new SystemConfiguration(){

            @Override
            protected String interpolate(String o) {
                return conf.interpolate(o);
            }
        });
        conf.addConfiguration(new XMLConfiguration(file){

            @Override
            protected String interpolate(String o) {
                return conf.interpolate(o);
            }
        });
        return conf;
    }

    @Override
    public void handle(Signal arg0) {
        try {
            this.reparseConfigFileSecuritySections();
        }
        catch (ConfigurationException e) {
            _logger.error((Object)"Could not reload configuration file security sections", (Throwable)((Object)e));
        }
    }

    public void reparseConfigFileSecuritySections() throws ConfigurationException {
        if (this._configFile != null) {
            Configuration newConfig = ServerConfiguration.parseConfig(this._configFile);
            this.setConfiguration("", newConfig);
            ApplicationRegistry.getInstance().getSecurityManager().configureHostPlugins(this);
            Configuration newVhosts = this._vhostsFile == null ? newConfig.subset("virtualhosts") : ServerConfiguration.parseConfig(this._vhostsFile);
            VirtualHostRegistry vhostRegistry = ApplicationRegistry.getInstance().getVirtualHostRegistry();
            for (String hostName : this._virtualHosts.keySet()) {
                VirtualHost vhost = vhostRegistry.getVirtualHost(hostName);
                Configuration vhostConfig = newVhosts.subset("virtualhost." + hostName);
                vhost.getConfiguration().setConfiguration("virtualhosts.virtualhost", vhostConfig);
                vhost.getSecurityManager().configureGlobalPlugins(this);
                vhost.getSecurityManager().configureHostPlugins(vhost.getConfiguration());
            }
            _logger.warn((Object)SECURITY_CONFIG_RELOADED);
        }
    }

    public String getQpidWork() {
        return System.getProperty(QPID_WORK, System.getProperty("java.io.tmpdir"));
    }

    public void setJMXManagementPort(int mport) {
        this.getConfig().setProperty("management.jmxport", mport);
    }

    public int getJMXManagementPort() {
        return this.getIntValue("management.jmxport", 8999);
    }

    public boolean getUseCustomRMISocketFactory() {
        return this.getBooleanValue(MGMT_CUSTOM_REGISTRY_SOCKET, true);
    }

    public boolean getPlatformMbeanserver() {
        return this.getBooleanValue("management.platform-mbeanserver", true);
    }

    public String[] getVirtualHosts() {
        return this._virtualHosts.keySet().toArray(new String[this._virtualHosts.size()]);
    }

    public String getPluginDirectory() {
        return this.getStringValue("plugin-directory");
    }

    public String getCacheDirectory() {
        return this.getStringValue("cache-directory");
    }

    public VirtualHostConfiguration getVirtualHostConfig(String name) {
        return this._virtualHosts.get(name);
    }

    public int getFrameSize() {
        return this.getIntValue("advanced.framesize", 65536);
    }

    public boolean getSynchedClocks() {
        return this.getBooleanValue("advanced.synced-clocks");
    }

    public boolean getMsgAuth() {
        return this.getBooleanValue("security.msg-auth");
    }

    public String getManagementKeyStorePath() {
        return this.getStringValue("management.ssl.keyStorePath");
    }

    public boolean getManagementSSLEnabled() {
        return this.getBooleanValue("management.ssl.enabled", true);
    }

    public String getManagementKeyStorePassword() {
        return this.getStringValue("management.ssl.keyStorePassword");
    }

    public boolean getQueueAutoRegister() {
        return this.getBooleanValue("queue.auto_register", true);
    }

    public boolean getManagementEnabled() {
        return this.getBooleanValue("management.enabled", true);
    }

    public void setManagementEnabled(boolean enabled) {
        this.getConfig().setProperty("management.enabled", enabled);
    }

    public int getHeartBeatDelay() {
        return this.getIntValue("heartbeat.delay", 0);
    }

    public double getHeartBeatTimeout() {
        return this.getDoubleValue("heartbeat.timeoutFactor", 2.0);
    }

    public long getMaximumMessageAge() {
        return this.getLongValue("maximumMessageAge");
    }

    public long getMaximumMessageCount() {
        return this.getLongValue("maximumMessageCount");
    }

    public long getMaximumQueueDepth() {
        return this.getLongValue("maximumQueueDepth");
    }

    public long getMaximumMessageSize() {
        return this.getLongValue("maximumMessageSize");
    }

    public long getMinimumAlertRepeatGap() {
        return this.getLongValue("minimumAlertRepeatGap");
    }

    public long getCapacity() {
        return this.getLongValue("capacity");
    }

    public long getFlowResumeCapacity() {
        return this.getLongValue("flowResumeCapacity", this.getCapacity());
    }

    public int getConnectorProcessors() {
        return this.getIntValue("connector.processors", 4);
    }

    public List getPorts() {
        Integer port = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_AMQP_DEFAULT_CONNECTION_PORT);
        return Collections.singletonList(port);
    }

    public List getPortExclude010() {
        return this.getListValue("connector.non010port");
    }

    public List getPortExclude091() {
        return this.getListValue("connector.non091port");
    }

    public List getPortExclude09() {
        return this.getListValue("connector.non09port");
    }

    public List getPortExclude08() {
        return this.getListValue("connector.non08port");
    }

    public String getBind() {
        return (String)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_AMQP_BIND_ADDRESS);
    }

    public int getReceiveBufferSize() {
        return this.getIntValue("connector.socketReceiveBuffer", 32768);
    }

    public int getWriteBufferSize() {
        return this.getIntValue("connector.socketWriteBuffer", 32768);
    }

    public boolean getTcpNoDelay() {
        return this.getBooleanValue("connector.tcpNoDelay", true);
    }

    public boolean getEnableExecutorPool() {
        return this.getBooleanValue("advanced.filterchain[@enableExecutorPool]");
    }

    public boolean getEnableSSL() {
        return (Boolean)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_AMQP_SSL_CONNECTION_ENABLED);
    }

    public boolean getSSLOnly() {
        return (Boolean)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_AMQP_SSL_CONNECTION_ENABLED) != false && (Boolean)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_AMQP_DEFAULT_CONNECTION_ENABLED) == false;
    }

    public boolean getMQTTSSLOnly() {
        return (Boolean)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_SSL_CONNECTION_ENABLED) != false && (Boolean)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_DEFAULT_CONNECTION_ENABLED) == false;
    }

    public List getSSLPorts() {
        Integer sslPort = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_AMQP_SSL_CONNECTION_PORT);
        return Collections.singletonList(sslPort);
    }

    public String getKeystorePath() {
        return ((JKSStore)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_AMQP_SSL_CONNECTION_KEYSTORE)).getStoreLocation();
    }

    public String getKeystorePassword() {
        return ((JKSStore)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_AMQP_SSL_CONNECTION_KEYSTORE)).getPassword();
    }

    public String getKeyStoreCertType() {
        return ((JKSStore)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_AMQP_SSL_CONNECTION_KEYSTORE)).getStoreAlgorithm();
    }

    public boolean getUseBiasedWrites() {
        return this.getBooleanValue("advanced.useWriteBiasedPool");
    }

    public String getDefaultVirtualHost() {
        return this.getStringValue("virtualhosts.default");
    }

    public void setHousekeepingExpiredMessageCheckPeriod(long value) {
        this.getConfig().setProperty("housekeeping.expiredMessageCheckPeriod", value);
    }

    public long getHousekeepingCheckPeriod() {
        return this.getLongValue("housekeeping.checkPeriod", this.getLongValue("housekeeping.expiredMessageCheckPeriod", 30000L));
    }

    public boolean isStatisticsGenerationBrokerEnabled() {
        return this.getConfig().getBoolean("statistics.generation.broker", false);
    }

    public boolean isStatisticsGenerationVirtualhostsEnabled() {
        return this.getConfig().getBoolean("statistics.generation.virtualhosts", false);
    }

    public boolean isStatisticsGenerationConnectionsEnabled() {
        return this.getConfig().getBoolean("statistics.generation.connections", false);
    }

    public long getStatisticsReportingPeriod() {
        return this.getConfig().getLong("statistics.reporting.period", 0L);
    }

    public boolean isStatisticsReportResetEnabled() {
        return this.getConfig().getBoolean("statistics.reporting.reset", false);
    }

    public int getMaxChannelCount() {
        return this.getIntValue("maximumChannelCount", 256);
    }

    static {
        envVarMap.put("QPID_ENABLEDIRECTBUFFERS", "advanced.enableDirectBuffers");
        envVarMap.put("QPID_SSLPORT", "connector.ssl.port");
        envVarMap.put("QPID_WRITEBIASED", "advanced.useWriteBiasedPool");
        envVarMap.put("QPID_JMXPORT", "management.jmxport");
        envVarMap.put("QPID_FRAMESIZE", "advanced.framesize");
        envVarMap.put("QPID_MSGAUTH", "security.msg-auth");
        envVarMap.put("QPID_AUTOREGISTER", "auto_register");
        envVarMap.put("QPID_MANAGEMENTENABLED", "management.enabled");
        envVarMap.put("QPID_HEARTBEATDELAY", "heartbeat.delay");
        envVarMap.put("QPID_HEARTBEATTIMEOUTFACTOR", "heartbeat.timeoutFactor");
        envVarMap.put("QPID_MAXIMUMMESSAGEAGE", "maximumMessageAge");
        envVarMap.put("QPID_MAXIMUMMESSAGECOUNT", "maximumMessageCount");
        envVarMap.put("QPID_MAXIMUMQUEUEDEPTH", "maximumQueueDepth");
        envVarMap.put("QPID_MAXIMUMMESSAGESIZE", "maximumMessageSize");
        envVarMap.put("QPID_MAXIMUMCHANNELCOUNT", "maximumChannelCount");
        envVarMap.put("QPID_MINIMUMALERTREPEATGAP", "minimumAlertRepeatGap");
        envVarMap.put("QPID_QUEUECAPACITY", "capacity");
        envVarMap.put("QPID_FLOWRESUMECAPACITY", "flowResumeCapacity");
        envVarMap.put("QPID_SOCKETRECEIVEBUFFER", "connector.socketReceiveBuffer");
        envVarMap.put("QPID_SOCKETWRITEBUFFER", "connector.socketWriteBuffer");
        envVarMap.put("QPID_TCPNODELAY", "connector.tcpNoDelay");
        envVarMap.put("QPID_ENABLEPOOLEDALLOCATOR", "advanced.enablePooledAllocator");
        envVarMap.put("QPID_STATUS-UPDATES", STATUS_UPDATES);
    }

    public static class MyConfiguration
    extends CompositeConfiguration {
        @Override
        public String interpolate(String obj) {
            return super.interpolate(obj);
        }
    }
}

