/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.configuration.qpid;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    public static final String QPID_HOME = "QPID_HOME";
    final String QPIDHOME = System.getProperty("QPID_HOME");
    private static Logger _devlog = LoggerFactory.getLogger(Configuration.class);
    public static final String DEFAULT_CONFIG_FILE = "etc/config.xml";
    protected final Options _options = new Options();
    protected CommandLine _commandLine;
    protected File _configFile;

    public void processCommandline(String[] args) throws InitException {
        try {
            this._commandLine = new PosixParser().parse(this._options, args);
        }
        catch (ParseException e) {
            throw new InitException("Unable to parse commmandline", e);
        }
        File defaultConfigFile = new File(this.QPIDHOME, DEFAULT_CONFIG_FILE);
        this.setConfig(new File(this._commandLine.getOptionValue("c", defaultConfigFile.getPath())));
    }

    public void setConfig(File file) {
        this._configFile = file;
    }

    public void setOption(Option option) {
        this._options.addOption(option);
    }

    public String getOptionValue(String ... option) {
        if (option.length == 1) {
            return this._commandLine.getOptionValue(option[0]);
        }
        if (option.length == 2) {
            return this._commandLine.getOptionValue(option[0], option[1]);
        }
        return null;
    }

    public void loadConfig(File file) throws InitException {
        this.setConfig(file);
        this.loadConfig();
    }

    private void loadConfig() throws InitException {
        if (!this._configFile.exists()) {
            String error = "File " + this._configFile + " could not be found. Check the file exists and is readable.";
            if (this.QPIDHOME == null) {
                error = error + "\nNote: " + QPID_HOME + " is not set.";
            }
            throw new InitException(error, null);
        }
        _devlog.debug("Using configuration file " + this._configFile.getAbsolutePath());
    }

    public File getConfigFile() {
        return this._configFile;
    }

    public static class InitException
    extends Exception {
        InitException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

