/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.configuration.qpid;

import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.wso2.andes.configuration.qpid.ConfigObjectType;
import org.wso2.andes.configuration.qpid.ConfiguredObject;
import org.wso2.andes.configuration.qpid.SystemConfig;

public class ConfigStore {
    private ConcurrentHashMap<ConfigObjectType, ConcurrentHashMap<UUID, ConfiguredObject>> _typeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<ConfigObjectType, CopyOnWriteArrayList<ConfigEventListener>> _listenerMap = new ConcurrentHashMap();
    private AtomicReference<SystemConfig> _root = new AtomicReference<Object>(null);
    private final AtomicLong _objectIdSource = new AtomicLong(0L);

    private ConfigStore() {
    }

    public <T extends ConfigObjectType<T, C>, C extends ConfiguredObject<T, C>> ConfiguredObject<T, C> getConfiguredObject(ConfigObjectType<T, C> type, UUID id) {
        ConcurrentHashMap<UUID, ConfiguredObject> typeMap = this._typeMap.get(type);
        if (typeMap != null) {
            return typeMap.get(id);
        }
        return null;
    }

    public <T extends ConfigObjectType<T, C>, C extends ConfiguredObject<T, C>> Collection<? extends C> getConfiguredObjects(ConfigObjectType<T, C> type) {
        ConcurrentHashMap<UUID, ConfiguredObject> typeMap = this._typeMap.get(type);
        if (typeMap != null) {
            return typeMap.values();
        }
        return Collections.EMPTY_LIST;
    }

    public <T extends ConfigObjectType<T, C>, C extends ConfiguredObject<T, C>> void addConfiguredObject(ConfiguredObject<T, C> object) {
        ConcurrentHashMap typeMap = this._typeMap.get(object.getConfigType());
        if (typeMap == null) {
            typeMap = new ConcurrentHashMap();
            ConcurrentHashMap<UUID, ConfiguredObject> oldMap = this._typeMap.putIfAbsent((ConfigObjectType)object.getConfigType(), typeMap);
            if (oldMap != null) {
                typeMap = oldMap;
            }
        }
        typeMap.put(object.getId(), object);
        this.sendEvent(Event.CREATED, object);
    }

    public <T extends ConfigObjectType<T, C>, C extends ConfiguredObject<T, C>> void removeConfiguredObject(ConfiguredObject<T, C> object) {
        ConcurrentHashMap<UUID, ConfiguredObject> typeMap = this._typeMap.get(object.getConfigType());
        if (typeMap != null) {
            typeMap.remove(object.getId());
            this.sendEvent(Event.DELETED, object);
        }
    }

    public <T extends ConfigObjectType<T, C>, C extends ConfiguredObject<T, C>> void addConfigEventListener(ConfigObjectType<T, C> type, ConfigEventListener<T, C> listener) {
        CopyOnWriteArrayList<ConfigEventListener> oldListeners;
        CopyOnWriteArrayList listeners = this._listenerMap.get(type);
        if (listeners == null && (oldListeners = this._listenerMap.putIfAbsent(type, listeners = new CopyOnWriteArrayList())) != null) {
            listeners = oldListeners;
        }
        listeners.add(listener);
    }

    public <T extends ConfigObjectType<T, C>, C extends ConfiguredObject<T, C>> void removeConfigEventListener(ConfigObjectType<T, C> type, ConfigEventListener<T, C> listener) {
        CopyOnWriteArrayList<ConfigEventListener> listeners = this._listenerMap.get(type);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    private void sendEvent(Event e, ConfiguredObject o) {
        CopyOnWriteArrayList<ConfigEventListener> listeners = this._listenerMap.get(o.getConfigType());
        if (listeners != null) {
            for (ConfigEventListener listener : listeners) {
                listener.onEvent(o, e);
            }
        }
    }

    public boolean setRoot(SystemConfig object) {
        if (this._root.compareAndSet(null, object)) {
            this.addConfiguredObject(object);
            return true;
        }
        return false;
    }

    public UUID createId() {
        return new UUID(0L, this._objectIdSource.getAndIncrement());
    }

    public SystemConfig getRoot() {
        return this._root.get();
    }

    public static ConfigStore newInstance() {
        return new ConfigStore();
    }

    public static interface ConfigEventListener<T extends ConfigObjectType<T, C>, C extends ConfiguredObject<T, C>> {
        public void onEvent(C var1, Event var2);
    }

    public static enum Event {
        CREATED,
        DELETED;

    }
}

