/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.configuration.modules;

import java.io.File;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.wso2.andes.configuration.AndesConfigurationManager;

public class JKSStore {
    private static final String JKS_BASE_PATH = "repository" + File.separator + "resources" + File.separator + "security" + File.separator;
    private final String DEFAULT_STORE_PASSWORD = "wso2carbon";
    private final String relativeXPathForLocation = "/location";
    private final String relativeXPathForPassword = "/password";
    private final String relativeXPathForStoreAlgorithm = "/certType";
    private String storeLocation;
    private String password;
    private String storeAlgorithm;

    public String getStoreLocation() {
        return this.storeLocation;
    }

    public String getPassword() {
        return this.password;
    }

    public String getStoreAlgorithm() {
        return this.storeAlgorithm;
    }

    public void setStoreAlgorithm(String storeAlgorithm) {
        this.storeAlgorithm = storeAlgorithm;
    }

    public JKSStore(String rootXPath) throws ConfigurationException {
        String locationXPath = rootXPath + "/location";
        String passwordXPath = rootXPath + "/password";
        String storeAlgorithmXPath = rootXPath + "/certType";
        String defaultStoreLocation = null;
        String defaultStoreAlgorithm = null;
        if (StringUtils.containsIgnoreCase((String)rootXPath, (String)"trustStore")) {
            defaultStoreLocation = JKS_BASE_PATH + "wso2carbon.jks";
            defaultStoreAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        } else {
            defaultStoreAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            defaultStoreLocation = JKS_BASE_PATH + "client-truststore.jks";
        }
        this.storeLocation = AndesConfigurationManager.deriveValidConfigurationValue(locationXPath, String.class, defaultStoreLocation);
        this.password = AndesConfigurationManager.deriveValidConfigurationValue(passwordXPath, String.class, "wso2carbon");
        this.storeAlgorithm = AndesConfigurationManager.deriveValidConfigurationValue(storeAlgorithmXPath, String.class, defaultStoreAlgorithm);
    }
}

