/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.configuration.util.ConfigurationProperty;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.carbon.core.util.Utils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class AndesConfigurationManager {
    private static Log log = LogFactory.getLog(AndesConfigurationManager.class);
    private static final String PORT_TYPE = "_PORT";
    private static final String LIST_TYPE = "LIST_";
    private static final QName SECURE_VAULT_QNAME = new QName("http://org.wso2.securevault/configuration", "secretAlias");
    private static final String CONFIG_MODULE_PACKAGE = "org.wso2.andes.configuration.modules";
    private static final String GENERIC_CONFIGURATION_PARSE_ERROR = "Error occurred when trying to parse configuration value {0}.";
    private static final String NO_CHILD_FOR_KEY_IN_PROPERTY = "There was no child at the given key {0} for the parent property {1}.";
    private static final String PROPERTY_NOT_A_LIST = "The input property {0} does not contain a list of child properties.";
    private static final String PROPERTY_NOT_A_PORT = "The input property {0} is not defined as an integer value. Therefore it is not a port property.";
    public static final String CARBON_CONFIG_DIR_PATH = "carbon.config.dir.path";
    public static final String CARBON_HOME = "carbon.home";
    private static String componentsPath = System.getProperty("carbon.config.dir.path");
    private static final String ROOT_CONFIG_FILE_NAME = "broker.xml";
    private static CompositeConfiguration compositeConfiguration;
    private static ConcurrentHashMap<String, String> cipherValueMap;
    private static int carbonPortOffset;

    public static void initialize(int portOffset) throws AndesException {
        String ROOT_CONFIG_FILE_PATH = componentsPath != null ? Paths.get(componentsPath, new String[0]).toString() : Paths.get(System.getProperty(CARBON_HOME), "repository", "conf").toString();
        String brokerConfigFilePath = ROOT_CONFIG_FILE_PATH + File.separator + ROOT_CONFIG_FILE_NAME;
        log.info((Object)("Main andes configuration located at : " + brokerConfigFilePath));
        try {
            compositeConfiguration = new CompositeConfiguration();
            compositeConfiguration.setDelimiterParsingDisabled(true);
            XMLConfiguration rootConfiguration = new XMLConfiguration();
            rootConfiguration.setDelimiterParsingDisabled(true);
            rootConfiguration.setFileName(brokerConfigFilePath);
            rootConfiguration.setExpressionEngine(new XPathExpressionEngine());
            rootConfiguration.load();
            compositeConfiguration.addConfiguration(rootConfiguration);
            AndesConfigurationManager.decryptConfigurationFromFile(brokerConfigFilePath);
            AndesConfigurationManager.addDerivedProperties();
            carbonPortOffset = portOffset;
            int deliveryTimeoutForMessage = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_TOPIC_MESSAGE_DELIVERY_TIMEOUT);
            AndesContext.getInstance().setDeliveryTimeoutForMessage(deliveryTimeoutForMessage);
        }
        catch (ConfigurationException e) {
            String error = "Error occurred when trying to construct configurations from file at path : " + brokerConfigFilePath;
            log.error((Object)error, (Throwable)((Object)e));
            throw new AndesException(error, (Throwable)((Object)e));
        }
        catch (UnknownHostException e) {
            String error = "Error occurred when trying to derive the bind address for messaging from configurations.";
            log.error((Object)error, (Throwable)e);
            throw new AndesException(error, e);
        }
        catch (FileNotFoundException e) {
            String error = "Error occurred when trying to read the configuration file : " + brokerConfigFilePath;
            log.error((Object)error, (Throwable)e);
            throw new AndesException(error, e);
        }
        catch (JaxenException e) {
            String error = "Error occurred when trying to process cipher text in file : " + brokerConfigFilePath;
            log.error((Object)error, (Throwable)e);
            throw new AndesException(error, e);
        }
        catch (XMLStreamException e) {
            String error = "Error occurred when trying to process cipher text in file : " + brokerConfigFilePath;
            log.error((Object)error, (Throwable)e);
            throw new AndesException(error, e);
        }
    }

    public static <T> T readValue(ConfigurationProperty configurationProperty) {
        if (configurationProperty.get().getName().endsWith(PORT_TYPE)) {
            return (T)AndesConfigurationManager.readPortValue(configurationProperty);
        }
        try {
            return AndesConfigurationManager.deriveValidConfigurationValue(configurationProperty);
        }
        catch (ConfigurationException e) {
            log.error((Object)e);
            try {
                return AndesConfigurationManager.deriveValidConfigurationValue(configurationProperty);
            }
            catch (ConfigurationException e1) {
                log.error((Object)e);
                return null;
            }
        }
    }

    public static <T> T readValueOfChildByKey(AndesConfiguration configurationProperty, String key) {
        String constructedKey = configurationProperty.get().getKeyInFile().replace("{key}", key);
        try {
            return (T)AndesConfigurationManager.deriveValidConfigurationValue(constructedKey, configurationProperty.get().getDataType(), configurationProperty.get().getDefaultValue());
        }
        catch (ConfigurationException e) {
            log.error((Object)MessageFormat.format(NO_CHILD_FOR_KEY_IN_PROPERTY, key, configurationProperty), (Throwable)((Object)e));
            return null;
        }
    }

    public static List<String> readValueList(AndesConfiguration configurationProperty) {
        if (configurationProperty.toString().startsWith(LIST_TYPE)) {
            return Arrays.asList(compositeConfiguration.getStringArray(configurationProperty.get().getKeyInFile()));
        }
        log.error((Object)MessageFormat.format(PROPERTY_NOT_A_LIST, configurationProperty));
        return new ArrayList<String>();
    }

    public static <T> T deriveValidConfigurationValue(ConfigurationProperty configurationProperty) throws ConfigurationException {
        if (compositeConfiguration.containsKey(configurationProperty.get().getKeyInFile())) {
            return (T)AndesConfigurationManager.deriveValidConfigurationValue(configurationProperty.get().getKeyInFile(), configurationProperty.get().getDataType(), configurationProperty.get().getDefaultValue());
        }
        if (configurationProperty.hasDeprecatedProperty() && compositeConfiguration.containsKey(configurationProperty.getDeprecated().get().getKeyInFile())) {
            log.warn((Object)("configuration [" + configurationProperty.getDeprecated().get().getKeyInFile() + "] is deprecated. please use: [" + configurationProperty.get().getKeyInFile() + "]"));
            return (T)AndesConfigurationManager.deriveValidConfigurationValue(configurationProperty.getDeprecated().get().getKeyInFile(), configurationProperty.getDeprecated().get().getDataType(), configurationProperty.getDeprecated().get().getDefaultValue());
        }
        return (T)AndesConfigurationManager.deriveValidConfigurationValue(configurationProperty.get().getKeyInFile(), configurationProperty.get().getDataType(), configurationProperty.get().getDefaultValue());
    }

    public static <T> T deriveValidConfigurationValue(String key, Class<T> dataType, String defaultValue) throws ConfigurationException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading andes configuration value " + key));
        }
        String readValue = compositeConfiguration.getString(key);
        String validValue = defaultValue;
        if (StringUtils.isBlank((String)readValue) && !CONFIG_MODULE_PACKAGE.equals(dataType.getPackage().getName())) {
            log.warn((Object)("Error when trying to read property : " + key + ". Switching to default value : " + defaultValue));
        } else {
            validValue = AndesConfigurationManager.overrideWithDecryptedValue(key, readValue);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Valid value read for andes configuration property " + key + " is : " + validValue));
        }
        try {
            if (Boolean.class.equals(dataType)) {
                return dataType.cast(Boolean.parseBoolean(validValue));
            }
            if (Date.class.equals(dataType)) {
                SimpleDateFormat df = new SimpleDateFormat("MMM dd kk:mm:ss z yyyy", Locale.ENGLISH);
                return dataType.cast(df.parse(validValue));
            }
            if (dataType.isEnum()) {
                return Enum.valueOf(dataType, validValue.toUpperCase(Locale.ENGLISH));
            }
            if (CONFIG_MODULE_PACKAGE.equals(dataType.getPackage().getName())) {
                return dataType.getConstructor(String.class).newInstance(key);
            }
            return dataType.getConstructor(String.class).newInstance(validValue);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException(MessageFormat.format(GENERIC_CONFIGURATION_PARSE_ERROR, key), e);
        }
        catch (ParseException e) {
            throw new ConfigurationException(MessageFormat.format(GENERIC_CONFIGURATION_PARSE_ERROR, key), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(MessageFormat.format(GENERIC_CONFIGURATION_PARSE_ERROR, key), e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(MessageFormat.format(GENERIC_CONFIGURATION_PARSE_ERROR, key), e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(MessageFormat.format(GENERIC_CONFIGURATION_PARSE_ERROR, key), e);
        }
    }

    private static void addDerivedProperties() throws AndesException, UnknownHostException {
        InetAddress host;
        if ("*".equals(AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_BIND_ADDRESS))) {
            host = InetAddress.getLocalHost();
            compositeConfiguration.setProperty(AndesConfiguration.TRANSPORTS_MQTT_BIND_ADDRESS.get().getKeyInFile(), host.getHostAddress());
        }
        if ("*".equals(AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_AMQP_BIND_ADDRESS))) {
            host = InetAddress.getLocalHost();
            compositeConfiguration.setProperty(AndesConfiguration.TRANSPORTS_AMQP_BIND_ADDRESS.get().getKeyInFile(), host.getHostAddress());
        }
    }

    private static Integer readPortValue(ConfigurationProperty configurationProperty) {
        if (!Integer.class.equals(configurationProperty.get().getDataType())) {
            log.error((Object)MessageFormat.format(PROPERTY_NOT_A_PORT, configurationProperty));
            return 0;
        }
        try {
            Integer portFromConfiguration = (Integer)AndesConfigurationManager.deriveValidConfigurationValue(configurationProperty.get().getKeyInFile(), configurationProperty.get().getDataType(), configurationProperty.get().getDefaultValue());
            return portFromConfiguration + carbonPortOffset;
        }
        catch (ConfigurationException e) {
            log.error((Object)MessageFormat.format(GENERIC_CONFIGURATION_PARSE_ERROR, configurationProperty), (Throwable)((Object)e));
            return Integer.parseInt(configurationProperty.get().getDefaultValue()) + carbonPortOffset;
        }
    }

    private static void decryptConfigurationFromFile(String filePath) throws FileNotFoundException, JaxenException, XMLStreamException {
        cipherValueMap = new ConcurrentHashMap();
        StAXOMBuilder stAXOMBuilder = new StAXOMBuilder((InputStream)new FileInputStream(new File(filePath)));
        OMElement dom = stAXOMBuilder.getDocumentElement();
        SecretResolver secretResolver = SecretResolverFactory.create((OMElement)dom, (boolean)false);
        Stack<String> nameStack = new Stack<String>();
        AndesConfigurationManager.readChildElements(dom, nameStack, secretResolver);
    }

    private static void readChildElements(OMElement serverConfig, Stack<String> nameStack, SecretResolver secretResolver) {
        Iterator childElements = serverConfig.getChildElements();
        while (childElements.hasNext()) {
            OMElement element = (OMElement)childElements.next();
            nameStack.push(element.getLocalName());
            if (AndesConfigurationManager.elementHasText(element)) {
                String key = AndesConfigurationManager.getKey(nameStack);
                String resolvedValue = MiscellaneousUtil.resolve((OMElement)element, (SecretResolver)secretResolver);
                String value = resolvedValue != null && !resolvedValue.isEmpty() ? resolvedValue : element.getText();
                value = Utils.replaceSystemProperty((String)value);
                cipherValueMap.put(key, value);
            }
            AndesConfigurationManager.readChildElements(element, nameStack, secretResolver);
            nameStack.pop();
        }
    }

    private static String getKey(Stack<String> nameStack) {
        StringBuffer key = new StringBuffer();
        for (int i = 0; i < nameStack.size(); ++i) {
            String name = (String)nameStack.elementAt(i);
            key.append(name).append(".");
        }
        key.deleteCharAt(key.lastIndexOf("."));
        return key.toString();
    }

    private static boolean elementHasText(OMElement element) {
        String text = element.getText();
        return text != null && text.trim().length() != 0;
    }

    private static String overrideWithDecryptedValue(String keyInFile, String rawValue) {
        String secretAlias;
        if (keyInFile.contains("@") && log.isDebugEnabled()) {
            log.debug((Object)("Ciphertool does not operate on xml attributes or lists. ( input key : " + keyInFile + " )"));
        }
        if (!StringUtils.isBlank((String)keyInFile) && cipherValueMap.containsKey(secretAlias = keyInFile.replaceAll("/", "."))) {
            return cipherValueMap.get(secretAlias);
        }
        return rawValue;
    }
}

