/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.security.amqplain;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.framing.FieldTableFactory;

public class AmqPlainSaslClient
implements SaslClient {
    public static final String MECHANISM = "AMQPLAIN";
    private CallbackHandler _cbh;

    public AmqPlainSaslClient(CallbackHandler cbh) {
        this._cbh = cbh;
    }

    @Override
    public String getMechanismName() {
        return MECHANISM;
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        NameCallback nameCallback = new NameCallback("prompt", "defaultName");
        PasswordCallback pwdCallback = new PasswordCallback("prompt", false);
        Callback[] callbacks = new Callback[]{nameCallback, pwdCallback};
        try {
            this._cbh.handle(callbacks);
        }
        catch (Exception e) {
            throw new SaslException("Error handling SASL callbacks: " + e, e);
        }
        FieldTable table = FieldTableFactory.newFieldTable();
        table.setString("LOGIN", nameCallback.getName());
        table.setString("PASSWORD", new String(pwdCallback.getPassword()));
        return table.getDataAsBytes();
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new SaslException("Not supported");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new SaslException("Not supported");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public void dispose() throws SaslException {
        this._cbh = null;
    }
}

