/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.protocol;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.org.apache.mina.common.IoFilter;
import org.wso2.org.apache.mina.common.IoFilterAdapter;
import org.wso2.org.apache.mina.common.IoSession;

public class ProtocolBufferMonitorFilter
extends IoFilterAdapter {
    private static final Logger _logger = LoggerFactory.getLogger(ProtocolBufferMonitorFilter.class);
    public static final long DEFAULT_FREQUENCY = 5000L;
    public static final int DEFAULT_THRESHOLD = 3000;
    private int _bufferedMessages = 0;
    private int _threshold;
    private long _lastMessageOutputTime;
    private long _outputFrequencyInMillis;

    public ProtocolBufferMonitorFilter() {
        this._threshold = 3000;
        this._outputFrequencyInMillis = 5000L;
    }

    public ProtocolBufferMonitorFilter(int threshold, long frequency) {
        this._threshold = threshold;
        this._outputFrequencyInMillis = frequency;
    }

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        long now;
        ++this._bufferedMessages;
        if (this._bufferedMessages > this._threshold && (now = System.currentTimeMillis()) - this._lastMessageOutputTime > this._outputFrequencyInMillis) {
            _logger.warn("Protocol message buffer exceeded threshold of " + this._threshold + ". Current backlog: " + this._bufferedMessages);
            this._lastMessageOutputTime = now;
        }
        nextFilter.messageReceived(session, message);
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        --this._bufferedMessages;
        nextFilter.messageSent(session, message);
    }

    public int getBufferedMessages() {
        return this._bufferedMessages;
    }

    public int getThreshold() {
        return this._threshold;
    }

    public void setThreshold(int threshold) {
        this._threshold = threshold;
    }

    public long getOutputFrequencyInMillis() {
        return this._outputFrequencyInMillis;
    }

    public void setOutputFrequencyInMillis(long outputFrequencyInMillis) {
        this._outputFrequencyInMillis = outputFrequencyInMillis;
    }

    public long getLastMessageOutputTime() {
        return this._lastMessageOutputTime;
    }
}

