/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.amqp;

import java.nio.ByteBuffer;
import org.apache.log4j.Logger;
import org.wso2.andes.kernel.AndesContent;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.server.store.ForwardingStoredMessage;
import org.wso2.andes.server.store.StorableMessageMetaData;
import org.wso2.andes.server.store.StoredMessage;

public class QpidStoredMessage<T extends StorableMessageMetaData>
extends ForwardingStoredMessage<T> {
    private static final Logger log = Logger.getLogger(QpidStoredMessage.class);
    private final AndesContent content;

    public QpidStoredMessage(StoredMessage<T> s, AndesContent content) {
        super(s);
        this.content = content;
    }

    @Override
    public int getContent(int offsetInMessage, ByteBuffer dst) {
        int bytesWrittenToBuffer = 0;
        try {
            bytesWrittenToBuffer = this.content.putContent(offsetInMessage, dst);
        }
        catch (AndesException e) {
            log.error((Object)("Error while getting message content chunk offset " + offsetInMessage), (Throwable)e);
        }
        return bytesWrittenToBuffer;
    }
}

