/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.amqp;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQInternalException;
import org.wso2.andes.amqp.AMQPLocalSubscription;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.exchange.ExchangeDefaults;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.abstraction.ContentChunk;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.kernel.AndesAckData;
import org.wso2.andes.kernel.AndesChannel;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.AndesMessagePart;
import org.wso2.andes.kernel.AndesUtils;
import org.wso2.andes.kernel.DisablePubAckImpl;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.ProtocolType;
import org.wso2.andes.kernel.QueueBrowserMessageFlusher;
import org.wso2.andes.kernel.SubscriptionAlreadyExistsException;
import org.wso2.andes.kernel.disruptor.DisruptorEventCallback;
import org.wso2.andes.kernel.disruptor.inbound.InboundBindingEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundExchangeEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundQueueEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundSubscriptionEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundTransactionEvent;
import org.wso2.andes.kernel.disruptor.inbound.PubAckHandler;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.kernel.subscription.SubscriberConnection;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.binding.Binding;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.message.AMQMessage;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.IncomingMessage;
import org.wso2.andes.server.store.StorableMessageMetaData;
import org.wso2.andes.server.subscription.Subscription;
import org.wso2.andes.server.subscription.SubscriptionImpl;
import org.wso2.andes.tools.utils.MessageTracer;

public class QpidAndesBridge {
    private static Log log = LogFactory.getLog(QpidAndesBridge.class);
    private static AtomicLong receivedMessageCounter = new AtomicLong();
    private static long last10kMessageReceivedTimestamp = System.currentTimeMillis();
    private static PubAckHandler pubAckHandler = new DisablePubAckImpl();

    public static void recoverMessagesOfChannel(AMQChannel channel, DisruptorEventCallback recoverOKCallback) throws AMQException {
        try {
            UUID channelID = channel.getId();
            Andes.getInstance().recoverMessagesOfChannel(channelID, recoverOKCallback);
        }
        catch (AndesException e) {
            throw new AMQException(AMQConstant.INTERNAL_ERROR, "Error while handling recovered message", e);
        }
    }

    private QpidAndesBridge() {
    }

    public static void messageReceived(IncomingMessage incomingMessage, AndesChannel andesChannel, InboundTransactionEvent transactionEvent) throws AMQException {
        Long localCount;
        try {
            AndesMessage andesMessage = QpidAndesBridge.convertToAndesMessage(incomingMessage);
            if (null == transactionEvent) {
                Andes.getInstance().messageReceived(andesMessage, andesChannel, pubAckHandler);
            } else {
                transactionEvent.preProcessEnqueue(andesMessage);
            }
        }
        catch (AndesException e) {
            throw new AMQException(AMQConstant.INTERNAL_ERROR, "Error while storing incoming message metadata", e);
        }
        if (log.isDebugEnabled() && (localCount = Long.valueOf(receivedMessageCounter.incrementAndGet())) % 10000L == 0L) {
            long timeTook = System.currentTimeMillis() - last10kMessageReceivedTimestamp;
            log.debug((Object)("Received " + localCount + ", throughput = " + 10000000L / timeTook + " msg/sec, " + timeTook));
            last10kMessageReceivedTimestamp = System.currentTimeMillis();
        }
    }

    public static void messageReceived(AndesMessage andesMessage, AndesChannel andesChannel) {
        Long localCount;
        Andes.getInstance().messageReceived(andesMessage, andesChannel, pubAckHandler);
        if (log.isDebugEnabled() && (localCount = Long.valueOf(receivedMessageCounter.incrementAndGet())) % 10000L == 0L) {
            long timetook = System.currentTimeMillis() - last10kMessageReceivedTimestamp;
            log.debug((Object)("Received " + localCount + ", throughput = " + 10000000L / timetook + " msg/sec, " + timetook));
            last10kMessageReceivedTimestamp = System.currentTimeMillis();
        }
    }

    public static AndesMessage convertToAndesMessage(IncomingMessage incomingMessage) throws AndesException {
        long receivedTime = System.currentTimeMillis();
        AMQMessage message = new AMQMessage(incomingMessage.getStoredMessage());
        message.setExpiration(incomingMessage.getExpiration());
        message.getMessageMetaData().setArrivalTime(receivedTime);
        AndesMessageMetadata metadata = AMQPUtils.convertAMQMessageToAndesMetadata(message);
        String queue = message.getRoutingKey();
        if (queue == null) {
            throw new AndesException("Queue cannot be null, for " + incomingMessage.getMessageNumber());
        }
        AndesMessage andesMessage = new AndesMessage(metadata);
        int contentChunks = incomingMessage.getBodyCount();
        int offset = 0;
        for (int i = 0; i < contentChunks; ++i) {
            ContentChunk chunk = incomingMessage.getContentChunk(i);
            AndesMessagePart messagePart = QpidAndesBridge.messageContentChunkReceived(metadata.getMessageID(), offset, chunk.getData().buf());
            offset += chunk.getSize();
            andesMessage.addMessagePart(messagePart);
        }
        return andesMessage;
    }

    public static StorableMessageMetaData getMessageMetaData(long messageID) throws AMQException {
        StorableMessageMetaData metaData;
        try {
            metaData = AMQPUtils.convertAndesMetadataToAMQMetadata(MessagingEngine.getInstance().getMessageMetaData(messageID));
        }
        catch (AndesException e) {
            log.error((Object)"Error in getting meta data for messageID", (Throwable)e);
            throw new AMQException(AMQConstant.INTERNAL_ERROR, "Error in getting meta data for messageID " + messageID, e);
        }
        return metaData;
    }

    public static AndesMessagePart messageContentChunkReceived(long messageID, int offsetInMessage, ByteBuffer src) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Content Part Received id " + messageID + ", offset " + offsetInMessage));
        }
        AndesMessagePart part = new AndesMessagePart();
        src = src.slice();
        byte[] chunkData = new byte[src.limit()];
        src.duplicate().get(chunkData);
        part.setData(chunkData);
        part.setMessageID(messageID);
        part.setOffSet(offsetInMessage);
        return part;
    }

    public static int getMessageContentChunk(long messageId, int offsetInMessage, ByteBuffer dst) throws AMQException {
        int contentLenWritten;
        try {
            contentLenWritten = AMQPUtils.fillBufferFromContent(messageId, offsetInMessage, dst);
        }
        catch (AndesException e) {
            log.error((Object)"Error in getting message content", (Throwable)e);
            throw new AMQException(AMQConstant.INTERNAL_ERROR, "Error in getting message content chunk messageId " + messageId + " offset=" + offsetInMessage, e);
        }
        return contentLenWritten;
    }

    public static void ackReceived(UUID channelId, long messageId) throws AMQException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ack received for message id= " + messageId + " channelId= " + channelId));
            }
            AndesAckData andesAckData = new AndesAckData(channelId, messageId);
            MessageTracer.traceAck(andesAckData, "ACK received from protocol");
            Andes.getInstance().ackReceived(andesAckData);
        }
        catch (AndesException e) {
            log.error((Object)"Exception occurred while handling ack", (Throwable)e);
            throw new AMQException(AMQConstant.INTERNAL_ERROR, "Error in getting handling ack for " + messageId, e);
        }
    }

    public static void rejectMessage(AMQMessage message, AMQChannel channel, boolean reQueue) throws AMQException {
        try {
            channel.setLastRejectedMessageId(message.getMessageNumber());
            boolean isMessageBeyondLastRollback = channel.isMessageBeyondLastRollback(message.getMessageNumber());
            log.info((Object)("Reject received id = " + message.getMessageId() + " channel id= " + channel.getChannelId() + "requeue = " + reQueue));
            Andes.getInstance().messageRejected(message.getMessageId(), channel.getId(), reQueue, isMessageBeyondLastRollback);
            if (log.isDebugEnabled()) {
                log.debug((Object)("AMQP BRIDGE: rejected message id= " + message.getMessageId() + " channel = " + channel.getId() + " reQueue= " + reQueue));
            }
        }
        catch (AndesException e) {
            throw new AMQException(AMQConstant.INTERNAL_ERROR, "Error while handling rejected message", e);
        }
    }

    public static void createAMQPSubscription(Subscription subscription, AMQQueue queue, Runnable consumeCallback) throws AMQException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("AMQP BRIDGE: create AMQP Subscription subID " + subscription.getSubscriptionID() + " from queue " + queue.getName()));
            }
            if (subscription instanceof SubscriptionImpl.BrowserSubscription) {
                QueueBrowserMessageFlusher deliveryWorker = new QueueBrowserMessageFlusher(subscription, queue);
                deliveryWorker.readAndSendFromMessageStore();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding Subscription " + subscription.getSubscriptionID() + " to queue " + queue.getName()));
                }
                QpidAndesBridge.addLocalSubscriptionsForAllBindingsOfQueue(queue, subscription, consumeCallback);
            }
        }
        catch (SubscriptionAlreadyExistsException e) {
            log.error((Object)"Error occurred while adding an already existing subscription", (Throwable)e);
            throw new AMQQueue.ExistingExclusiveSubscription();
        }
        catch (AndesException e) {
            log.error((Object)"Error while adding the subscription", (Throwable)e);
            throw new AMQException(AMQConstant.INTERNAL_ERROR, "Error while registering subscription", e);
        }
    }

    public static void closeAMQPSubscription(AMQQueue queue, Subscription subscription) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AMQP BRIDGE: close AMQP Subscription subID " + subscription.getSubscriptionID() + " from queue " + queue.getName()));
        }
        if (!(subscription instanceof SubscriptionImpl.BrowserSubscription)) {
            QpidAndesBridge.closeLocalSubscriptionsForAllBindingsOfQueue(queue, subscription);
        }
    }

    public static void createExchange(Exchange exchange) throws AMQException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AMQP BRIDGE: create Exchange" + exchange.getName()));
        }
        try {
            InboundExchangeEvent exchangeEvent = AMQPUtils.createAndesExchange(exchange);
            Andes.getInstance().createExchange(exchangeEvent);
        }
        catch (AndesException e) {
            log.error((Object)"error while creating exchange", (Throwable)e);
            throw new AMQException(AMQConstant.INTERNAL_ERROR, "error while creating exchange", e);
        }
    }

    public static void deleteExchange(Exchange exchange) throws AMQException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AMQP BRIDGE: delete Exchange " + exchange.getName()));
        }
        try {
            Andes.getInstance().deleteExchange(AMQPUtils.createAndesExchange(exchange));
        }
        catch (AndesException e) {
            log.error((Object)"error while deleting exchange", (Throwable)e);
            throw new AMQException(AMQConstant.INTERNAL_ERROR, "error while deleting exchange", e);
        }
    }

    public static void createQueue(AMQQueue queue) throws AMQException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AMQP BRIDGE: create queue: " + queue.getName()));
        }
        try {
            List<StorageQueue> queues = AndesContext.getInstance().getStorageQueueRegistry().getAllStorageQueues();
            for (StorageQueue storageQueue : queues) {
                if (!storageQueue.getName().equals(queue.getName())) continue;
                throw new AMQException("Cannot create already existing queue: " + queue.getName());
            }
            Andes.getInstance().createQueue(AMQPUtils.createInboundQueueEvent(queue));
        }
        catch (AndesException e) {
            log.error((Object)"error while creating queue", (Throwable)e);
            throw new AMQException(AMQConstant.INTERNAL_ERROR, "error while creating queue", e);
        }
    }

    public static void deleteQueue(AMQQueue queue) throws AMQException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AMQP BRIDGE:  delete queue : " + queue.getName()));
        }
        try {
            if (queue.isDurable() && !queue.isAutoDelete()) {
                InboundQueueEvent queueEvent = AMQPUtils.createInboundQueueEvent(queue);
                Andes.getInstance().deleteQueue(queueEvent);
            }
        }
        catch (AndesException e) {
            log.error((Object)"error while removing queue", (Throwable)e);
            throw new AMQException(AMQConstant.INTERNAL_ERROR, "error while removing queue", e);
        }
    }

    public static void createBinding(Exchange exchange, AMQShortString routingKey, AMQQueue queue) throws AMQInternalException {
        if (exchange.getNameShortString().equals(ExchangeDefaults.DEFAULT_EXCHANGE_NAME)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Ignored binding for default exchange " + exchange.getNameShortString()));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("AMQP BRIDGE: addBinding exchange=" + exchange.getName() + " routingKey=" + routingKey + " queue=" + queue.getName()));
        }
        try {
            InboundBindingEvent binding = AMQPUtils.createAndesBindingEvent(exchange, queue, routingKey);
            Andes.getInstance().addBinding(binding);
        }
        catch (AndesException e) {
            log.error((Object)"error while creating binding", (Throwable)e);
            throw new AMQInternalException("error while creating binding", e);
        }
    }

    public static void removeBinding(Binding binding) throws AndesException {
        Exchange exchange = binding.getExchange();
        if (exchange.getNameShortString().equals(ExchangeDefaults.DEFAULT_EXCHANGE_NAME)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Ignored binding for default exchange " + exchange.getNameShortString()));
            }
            return;
        }
        if (!binding.getQueue().isDurable() && exchange.getNameShortString().equals(ExchangeDefaults.TOPIC_EXCHANGE_NAME)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Ignored binding for non durable topic " + binding.getBindingKey()));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("AMQP BRIDGE: removeBinding binding key: " + binding.getBindingKey() + " exchange: " + binding.getExchange().getName() + " queue: " + binding.getQueue().getName()));
        }
        InboundBindingEvent inboundBindingEvent = AMQPUtils.createAndesBindingEvent(binding.getExchange(), binding.getQueue(), new AMQShortString(binding.getBindingKey()));
        Andes.getInstance().removeBinding(inboundBindingEvent);
    }

    private static void addLocalSubscriptionsForAllBindingsOfQueue(AMQQueue queue, Subscription subscription, Runnable sendConsumeOk) throws AndesException {
        String localNodeID = ClusterResourceHolder.getInstance().getClusterManager().getMyNodeID();
        List<Binding> bindingList = queue.getBindings();
        if (bindingList != null && !bindingList.isEmpty()) {
            HashSet<String> uniqueStorageQueues = new HashSet<String>();
            ArrayList<InboundSubscriptionEvent> alreadyAddedSubscriptions = new ArrayList<InboundSubscriptionEvent>();
            try {
                for (Binding b : bindingList) {
                    boolean isDurable;
                    String queueName;
                    if (b.getExchange().getNameShortString().equals(ExchangeDefaults.DEFAULT_EXCHANGE_NAME.toString())) continue;
                    ProtocolType protocol = ProtocolType.AMQP;
                    String subscriptionIdentifier = queue.getName();
                    String boundExchangeName = b.getExchange().getName();
                    String bindingKey = b.getBindingKey();
                    String storageQueueToBind = AndesUtils.getStorageQueueForDestination(bindingKey, boundExchangeName, queueName = queue.getName(), isDurable = b.getQueue().isDurable());
                    if (!uniqueStorageQueues.add(storageQueueToBind)) continue;
                    AMQPLocalSubscription outboundSubscription = new AMQPLocalSubscription(subscription);
                    String ipAddressOfSubscriber = ((SubscriptionImpl.AckSubscription)subscription).getChannel().getSessionName();
                    SubscriberConnection subscriberConnection = new SubscriberConnection(ipAddressOfSubscriber, localNodeID, subscription.getIdOfUnderlyingChannel(), outboundSubscription);
                    InboundSubscriptionEvent subscriptionEvent = new InboundSubscriptionEvent(protocol, subscriptionIdentifier, storageQueueToBind, bindingKey, subscriberConnection, sendConsumeOk);
                    Andes.getInstance().openLocalSubscription(subscriptionEvent);
                    alreadyAddedSubscriptions.add(subscriptionEvent);
                }
            }
            catch (AndesException e) {
                log.warn((Object)("Reverting already created subscription entries for subscription " + subscription), (Throwable)e);
                for (InboundSubscriptionEvent alreadyAddedSub : alreadyAddedSubscriptions) {
                    Andes.getInstance().closeLocalSubscription(alreadyAddedSub);
                }
                throw e;
            }
        }
    }

    private static void closeLocalSubscriptionsForAllBindingsOfQueue(AMQQueue queue, Subscription subscription) {
        String localNodeID = ClusterResourceHolder.getInstance().getClusterManager().getMyNodeID();
        List<Binding> bindingList = queue.getBindings();
        if (bindingList != null && !bindingList.isEmpty()) {
            HashSet<String> uniqueStorageQueues = new HashSet<String>();
            for (Binding b : bindingList) {
                boolean isDurable;
                String queueName;
                if (b.getExchange().getNameShortString().equals(ExchangeDefaults.DEFAULT_EXCHANGE_NAME.toString())) continue;
                ProtocolType protocol = ProtocolType.AMQP;
                String subscriptionIdentifier = "";
                String boundExchangeName = b.getExchange().getName();
                String bindingKey = b.getBindingKey();
                String storageQueueToBind = AndesUtils.getStorageQueueForDestination(bindingKey, boundExchangeName, queueName = queue.getName(), isDurable = b.getQueue().isDurable());
                if (!uniqueStorageQueues.add(storageQueueToBind)) continue;
                AMQPLocalSubscription outboundSubscription = new AMQPLocalSubscription(subscription);
                String IPAddressOfSubscriber = ((SubscriptionImpl.AckSubscription)subscription).getChannel().getSessionName();
                SubscriberConnection subscriberConnection = new SubscriberConnection(IPAddressOfSubscriber, localNodeID, subscription.getIdOfUnderlyingChannel(), outboundSubscription);
                InboundSubscriptionEvent subscriptionEvent = new InboundSubscriptionEvent(protocol, subscriptionIdentifier, storageQueueToBind, bindingKey, subscriberConnection);
                try {
                    Andes.getInstance().closeLocalSubscription(subscriptionEvent);
                }
                catch (AndesException e) {
                    log.warn((Object)"Error occurred while closing the subscription", (Throwable)e);
                }
            }
        }
    }

    public static void notifyChannelFlow(UUID channelId, boolean active, DisruptorEventCallback channelFlowCallback) {
        Andes.getInstance().notifySubscriptionFlow(channelId, active, channelFlowCallback);
    }
}

