/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.amqp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.amqp.AMQPDeliveryRule;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AMQPMetaDataHandler;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.ProtocolMessage;
import org.wso2.andes.server.message.AMQMessage;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.tools.utils.MessageTracer;

public class MaximumNumOfDeliveryRule
implements AMQPDeliveryRule {
    private static Log log = LogFactory.getLog(MaximumNumOfDeliveryRule.class);
    private int maximumRedeliveryTimes = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_AMQP_MAXIMUM_REDELIVERY_ATTEMPTS);

    @Override
    public boolean evaluate(QueueEntry message) throws AndesException {
        long messageID = message.getMessage().getMessageNumber();
        ProtocolMessage protocolMessage = ((AMQMessage)message.getMessage()).getAndesMetadataReference();
        int numOfDeliveriesOfCurrentMsg = protocolMessage.getNumberOfDeliveriesForProtocolChannel();
        AMQPMetaDataHandler.setIntProperty((AMQMessage)message.getMessage(), numOfDeliveriesOfCurrentMsg);
        MessageTracer.trace(messageID, numOfDeliveriesOfCurrentMsg, protocolMessage.getChannelID(), "Delivery count evaluated");
        if (numOfDeliveriesOfCurrentMsg > this.maximumRedeliveryTimes + 1) {
            log.warn((Object)("Number of Maximum Redelivery Tries Has Breached. Message id = " + messageID));
            return false;
        }
        return true;
    }
}

