/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.amqp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.amqp.AMQPDeliveryRule;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.message.AMQMessage;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.subscription.Subscription;

public class AmqpNoLocalRule
implements AMQPDeliveryRule {
    private static Log log = LogFactory.getLog(AmqpNoLocalRule.class);
    private Subscription amqpSubscription;
    private AMQChannel amqChannel;

    public AmqpNoLocalRule(Subscription amqpSubscription, AMQChannel channel) {
        this.amqpSubscription = amqpSubscription;
        this.amqChannel = channel;
    }

    @Override
    public boolean evaluate(QueueEntry message) {
        boolean isOKToDelivery;
        AMQMessage amqMessage = (AMQMessage)message.getMessage();
        if (this.amqpSubscription.isNoLocal()) {
            if (amqMessage.getMessageMetaData().getPublisherSessionID() != this.amqChannel.getProtocolSession().getSessionID()) {
                isOKToDelivery = true;
            } else {
                isOKToDelivery = false;
                log.warn((Object)("No Local violation id: " + amqMessage.getMessageId()));
            }
        } else {
            isOKToDelivery = true;
        }
        return isOKToDelivery;
    }
}

