/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.amqp;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.amqp.QpidStoredMessage;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.kernel.AndesContent;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.AndesMessagePart;
import org.wso2.andes.kernel.AndesUtils;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.ProtocolMessage;
import org.wso2.andes.kernel.disruptor.inbound.InboundBindingEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundExchangeEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundQueueEvent;
import org.wso2.andes.kernel.disruptor.inbound.QueueInfo;
import org.wso2.andes.server.exchange.DirectExchange;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.exchange.TopicExchange;
import org.wso2.andes.server.message.AMQMessage;
import org.wso2.andes.server.message.MessageMetaData;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.queue.SimpleQueueEntryList;
import org.wso2.andes.server.store.MessageMetaDataType;
import org.wso2.andes.server.store.StorableMessageMetaData;
import org.wso2.andes.server.store.StoredMessage;
import org.wso2.andes.store.StoredAMQPMessage;

public class AMQPUtils {
    public static final String TOPIC_AND_CHILDREN_WILDCARD = "#";
    public static final String IMMEDIATE_CHILDREN_WILDCARD = "*";
    public static String DIRECT_EXCHANGE_NAME = "amq.direct";
    public static String TOPIC_EXCHANGE_NAME = "amq.topic";
    public static String DEFAULT_EXCHANGE_NAME = "<<default>>";
    public static String DLC_EXCHANGE_NAME = "amq.dlc";
    public static String DEFAULT_ANDES_CHANNEL_IDENTIFIER = "AMQP-Unknown";
    public static int DEFAULT_CONTENT_CHUNK_SIZE;
    private static Log log;
    private static Map<Long, AndesMessagePart> messagePartCache;

    public static AMQMessage getAMQMessageFromAndesMetaData(AndesMessageMetadata metadata) {
        long messageId = metadata.getMessageID();
        StorableMessageMetaData metaData = AMQPUtils.convertAndesMetadataToAMQMetadata(metadata);
        StoredAMQPMessage message = new StoredAMQPMessage(messageId, metaData);
        AMQMessage amqMessage = new AMQMessage(message);
        return amqMessage;
    }

    public static AMQMessage getQueueEntryFromStoredMessage(StoredMessage<MessageMetaData> storedMessage, AndesContent content) {
        QpidStoredMessage<MessageMetaData> message = new QpidStoredMessage<MessageMetaData>(storedMessage, content);
        return new AMQMessage(message);
    }

    public static AMQMessage getAMQMessageForDelivery(ProtocolMessage metadata, AndesContent content) {
        long messageId = metadata.getMessageID();
        StorableMessageMetaData metaData = AMQPUtils.convertAndesMetadataToAMQMetadata(metadata.getMessage());
        QpidStoredMessage<MessageMetaData> message = new QpidStoredMessage<MessageMetaData>(new StoredAMQPMessage(messageId, metaData), content);
        AMQMessage amqMessage = new AMQMessage(message);
        amqMessage.setAndesMetadataReference(metadata);
        return amqMessage;
    }

    public static QueueEntry convertAMQMessageToQueueEntry(AMQMessage message, AMQQueue queue) {
        SimpleQueueEntryList list = new SimpleQueueEntryList(queue);
        return list.add(message);
    }

    public static StorableMessageMetaData convertAndesMetadataToAMQMetadata(AndesMessageMetadata andesMessageMetadata) {
        byte[] dataAsBytes = andesMessageMetadata.getMetadata();
        ByteBuffer buf = ByteBuffer.wrap(dataAsBytes);
        buf.position(1);
        buf = buf.slice();
        MessageMetaDataType type = MessageMetaDataType.values()[dataAsBytes[0]];
        return type.getFactory().createMetaData(buf);
    }

    public static AndesMessageMetadata convertAMQMessageToAndesMetadata(AMQMessage amqMessage) {
        MessageMetaData amqMetadata = amqMessage.getMessageMetaData();
        String queue = amqMetadata.getMessagePublishInfo().getRoutingKey().toString();
        int bodySize = 1 + amqMetadata.getStorableSize();
        byte[] underlying = new byte[bodySize];
        underlying[0] = (byte)amqMetadata.getType().ordinal();
        ByteBuffer buf = ByteBuffer.wrap(underlying);
        buf.position(1);
        buf = buf.slice();
        amqMetadata.writeToBuffer(0, buf);
        AndesMessageMetadata metadata = new AndesMessageMetadata(amqMessage.getMessageId(), underlying, true);
        metadata.setArrivalTime(amqMessage.getArrivalTime());
        metadata.setMessageContentLength(amqMetadata.getContentSize());
        return metadata;
    }

    public static int fillBufferFromContent(long messageId, int offsetValue, ByteBuffer dst) throws AndesException {
        int written = 0;
        int initialBufferSize = dst.remaining();
        int currentOffsetValue = offsetValue;
        while (initialBufferSize > written) {
            int numOfBytesToRead;
            int numOfBytesAvailableToRead;
            int chunkIndex = currentOffsetValue / DEFAULT_CONTENT_CHUNK_SIZE;
            int indexToQuery = chunkIndex * DEFAULT_CONTENT_CHUNK_SIZE;
            int positionToReadFromChunk = currentOffsetValue - chunkIndex * DEFAULT_CONTENT_CHUNK_SIZE;
            AndesMessagePart messagePart = AMQPUtils.resolveCacheAndRetrieveMessagePart(messageId, indexToQuery);
            int messagePartSize = messagePart.getDataLength();
            int remainingSizeOfBuffer = initialBufferSize - dst.position();
            if (remainingSizeOfBuffer > (numOfBytesAvailableToRead = messagePartSize - positionToReadFromChunk)) {
                numOfBytesToRead = numOfBytesAvailableToRead;
                messagePartCache.remove(messageId);
            } else {
                numOfBytesToRead = initialBufferSize - written;
            }
            if (messagePart.getData() != null) {
                dst.put(messagePart.getData(), positionToReadFromChunk, numOfBytesToRead);
            }
            written += numOfBytesToRead;
            if (messagePartSize < DEFAULT_CONTENT_CHUNK_SIZE) break;
            currentOffsetValue += numOfBytesToRead;
        }
        return written;
    }

    private static AndesMessagePart resolveCacheAndRetrieveMessagePart(long messageId, int index) throws AndesException {
        AndesMessagePart messagePart = null;
        boolean needToCache = true;
        AndesMessagePart cachedMessagePart = messagePartCache.get(messageId);
        if (cachedMessagePart != null && cachedMessagePart.getOffset() == index) {
            messagePart = cachedMessagePart;
            needToCache = false;
        } else {
            messagePart = MessagingEngine.getInstance().getMessageContentChunk(messageId, index);
            if (messagePart == null) {
                throw new AndesException("Empty message part received while retrieving message content.");
            }
        }
        if (messagePart.getDataLength() < DEFAULT_CONTENT_CHUNK_SIZE) {
            needToCache = false;
        }
        if (needToCache) {
            messagePartCache.put(messageId, messagePart);
        }
        return messagePart;
    }

    public static InboundQueueEvent createInboundQueueEvent(AMQQueue amqQueue) {
        String queueName = amqQueue.getName();
        String queueOwner = amqQueue.getOwner() != null ? amqQueue.getOwner().toString() : "null";
        return new InboundQueueEvent(queueName, amqQueue.isDurable(), true, queueOwner, amqQueue.isExclusive());
    }

    public static InboundExchangeEvent createAndesExchange(Exchange exchange) {
        return new InboundExchangeEvent(exchange.getName(), exchange.getType().getName().toString(), exchange.isAutoDelete());
    }

    public static InboundBindingEvent createAndesBindingEvent(Exchange exchange, AMQQueue queue, AMQShortString routingKey) {
        String exchangeName = "";
        if (exchange.getType().equals(DirectExchange.TYPE)) {
            exchangeName = DirectExchange.TYPE.getDefaultExchangeName().toString();
        } else if (exchange.getType().equals(TopicExchange.TYPE)) {
            exchangeName = TopicExchange.TYPE.getDefaultExchangeName().toString();
        }
        String storageQueueName = AndesUtils.getStorageQueueForDestination(routingKey.toString(), exchangeName, queue.getName(), queue.isDurable());
        boolean isQueueShared = AMQPUtils.isQueueShared(queue.isDurable(), exchangeName);
        String queueOwner = "null";
        if (queue.getOwner() != null) {
            queueOwner = queue.getOwner().toString();
        }
        QueueInfo queueInformation = new QueueInfo(storageQueueName, queue.isDurable(), isQueueShared, queueOwner, queue.isExclusive());
        return new InboundBindingEvent(queueInformation, exchangeName, routingKey.toString());
    }

    private static boolean isQueueShared(boolean isDurable, String exchangeName) {
        boolean isQueueShared = true;
        if (TOPIC_EXCHANGE_NAME.equals(exchangeName) && !isDurable) {
            isQueueShared = false;
        }
        return isQueueShared;
    }

    public static boolean isTargetQueueBoundByMatchingToRoutingKey(String queueBoundRoutingKey, String messageRoutingKey) {
        boolean isMatching = false;
        if (queueBoundRoutingKey.equals(messageRoutingKey)) {
            isMatching = true;
        } else if (queueBoundRoutingKey.indexOf(TOPIC_AND_CHILDREN_WILDCARD) > 1) {
            int wildcardIndex = queueBoundRoutingKey.indexOf(TOPIC_AND_CHILDREN_WILDCARD);
            int partitionIndex = 0 == wildcardIndex ? 0 : wildcardIndex - 1;
            String wildcardPrefix = queueBoundRoutingKey.substring(0, partitionIndex);
            Pattern pattern = Pattern.compile(wildcardPrefix + ".*");
            Matcher matcher = pattern.matcher(messageRoutingKey);
            isMatching = matcher.matches();
        } else if (queueBoundRoutingKey.indexOf(IMMEDIATE_CHILDREN_WILDCARD) > 1) {
            int wildcardIndex = queueBoundRoutingKey.indexOf(IMMEDIATE_CHILDREN_WILDCARD);
            int partitionIndex = 0 == wildcardIndex ? 0 : wildcardIndex - 1;
            String wildcardPrefix = queueBoundRoutingKey.substring(0, partitionIndex);
            Pattern pattern = Pattern.compile("^" + wildcardPrefix + "[.][^.]+$");
            Matcher matcher = pattern.matcher(messageRoutingKey);
            isMatching = matcher.matches();
        }
        return isMatching;
    }

    public static boolean isWildCardDestination(String destination) {
        boolean isWildCard = false;
        if (destination.contains(TOPIC_AND_CHILDREN_WILDCARD) || destination.contains(IMMEDIATE_CHILDREN_WILDCARD)) {
            isWildCard = true;
        }
        return isWildCard;
    }

    static {
        log = LogFactory.getLog(AMQPUtils.class);
        messagePartCache = new HashMap<Long, AndesMessagePart>();
    }
}

