/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.amqp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQSubscriptionClosedException;
import org.wso2.andes.amqp.AMQPDeliveryRule;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.amqp.AmqpNoLocalRule;
import org.wso2.andes.amqp.MaximumNumOfDeliveryRule;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.kernel.AndesAckData;
import org.wso2.andes.kernel.AndesContent;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.ProtocolDeliveryFailureException;
import org.wso2.andes.kernel.ProtocolDeliveryRulesFailureException;
import org.wso2.andes.kernel.ProtocolMessage;
import org.wso2.andes.kernel.SubscriptionAlreadyClosedException;
import org.wso2.andes.kernel.subscription.OutboundSubscription;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.binding.Binding;
import org.wso2.andes.server.message.AMQMessage;
import org.wso2.andes.server.message.MessageMetaData;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.store.StoredMessage;
import org.wso2.andes.server.subscription.Subscription;
import org.wso2.andes.server.subscription.SubscriptionImpl;
import org.wso2.andes.tools.utils.MessageTracer;

public class AMQPLocalSubscription
implements OutboundSubscription {
    private static Log log = LogFactory.getLog(AMQPLocalSubscription.class);
    private AMQChannel channel = null;
    private AMQQueue amqQueue;
    private Subscription amqpSubscription;
    private boolean isDurable;
    private long subscribeTime;
    private Map<Long, StoredMessage<MessageMetaData>> storedMessageCache;
    private List<AMQPDeliveryRule> amqpDeliveryRuleList = new ArrayList<AMQPDeliveryRule>();

    public AMQPLocalSubscription(Subscription amqpSubscription) {
        this.subscribeTime = System.currentTimeMillis();
        this.amqQueue = amqpSubscription.getQueue();
        this.isDurable = amqpSubscription.getQueue().isDurable();
        this.amqpSubscription = amqpSubscription;
        if (amqpSubscription != null && amqpSubscription instanceof SubscriptionImpl) {
            this.channel = ((SubscriptionImpl)amqpSubscription).getChannel();
            this.initializeDeliveryRules();
        }
        this.storedMessageCache = new ConcurrentHashMap<Long, StoredMessage<MessageMetaData>>(16, 0.75f, 2);
    }

    private void initializeDeliveryRules() {
        List<Binding> bindings = this.amqpSubscription.getQueue().getBindings();
        boolean isBoundToTopic = false;
        for (Binding binding : bindings) {
            if (!binding.getExchange().getName().equals(AMQPUtils.TOPIC_EXCHANGE_NAME)) continue;
            isBoundToTopic = true;
            break;
        }
        if (!isBoundToTopic || this.amqpSubscription.getQueue().isDurable()) {
            this.amqpDeliveryRuleList.add(new MaximumNumOfDeliveryRule());
        }
        this.amqpDeliveryRuleList.add(new AmqpNoLocalRule(this.amqpSubscription, this.channel));
    }

    @Override
    public boolean isOutboundConnectionLive() {
        return this.amqpSubscription.isActive();
    }

    @Override
    public UUID getChannelID() {
        return this.channel.getId();
    }

    @Override
    public long getSubscribeTime() {
        return this.subscribeTime;
    }

    @Override
    public String getProtocolQueueName() {
        return this.amqpSubscription.getQueue().getName();
    }

    @Override
    public void forcefullyDisconnect() throws AndesException {
        try {
            this.channel.mgmtClose();
        }
        catch (Exception e) {
            throw new AndesException(e);
        }
    }

    @Override
    public boolean isMessageAcceptedBySelector(AndesMessageMetadata messageMetadata) throws AndesException {
        AMQMessage amqMessage = AMQPUtils.getAMQMessageFromAndesMetaData(messageMetadata);
        QueueEntry message = AMQPUtils.convertAMQMessageToQueueEntry(amqMessage, this.amqQueue);
        if (this.amqpSubscription.hasInterest(message)) {
            this.storedMessageCache.put(message.getMessage().getMessageNumber(), amqMessage.getStoredMessage());
            return true;
        }
        return false;
    }

    @Override
    public boolean sendMessageToSubscriber(ProtocolMessage messageMetadata, AndesContent content) throws AndesException {
        AMQMessage message;
        StoredMessage<MessageMetaData> cachedStoredMessage = this.storedMessageCache.get(messageMetadata.getMessageID());
        if (null != cachedStoredMessage) {
            message = AMQPUtils.getQueueEntryFromStoredMessage(cachedStoredMessage, content);
            this.storedMessageCache.remove(messageMetadata.getMessageID());
            message.setAndesMetadataReference(messageMetadata);
        } else {
            message = AMQPUtils.getAMQMessageForDelivery(messageMetadata, content);
        }
        QueueEntry messageToSend = AMQPUtils.convertAMQMessageToQueueEntry(message, this.amqQueue);
        if (this.evaluateDeliveryRules(messageToSend)) {
            if (messageMetadata.isRedelivered()) {
                messageToSend.setRedelivered();
            }
        } else {
            throw new ProtocolDeliveryRulesFailureException("AMQP delivery rule evaluation failed");
        }
        this.sendMessage(messageToSend);
        return true;
    }

    private boolean evaluateDeliveryRules(QueueEntry message) throws AndesException {
        boolean isOKToDelivery = true;
        for (AMQPDeliveryRule element : this.amqpDeliveryRuleList) {
            if (element.evaluate(message)) continue;
            isOKToDelivery = false;
            break;
        }
        return isOKToDelivery;
    }

    private void sendMessage(QueueEntry queueEntry) throws AndesException {
        block5: {
            String msgHeaderStringID = (String)queueEntry.getMessageHeader().getHeader("msgID");
            long messageID = queueEntry.getMessage().getMessageNumber();
            try {
                if (this.amqpSubscription instanceof SubscriptionImpl.AckSubscription) {
                    MessageTracer.trace(messageID, queueEntry.getMessage().getRoutingKey(), this.getChannelID(), "sending message to subscriber");
                    this.amqpSubscription.send(queueEntry);
                    break block5;
                }
                if (this.amqpSubscription instanceof SubscriptionImpl.NoAckSubscription) {
                    MessageTracer.trace(messageID, queueEntry.getMessage().getRoutingKey(), this.getChannelID(), "sending message to subscriber");
                    this.amqpSubscription.send(queueEntry);
                    UUID channelID = ((SubscriptionImpl.NoAckSubscription)this.amqpSubscription).getChannel().getId();
                    AndesAckData andesAckData = new AndesAckData(channelID, messageID);
                    Andes.getInstance().ackReceived(andesAckData);
                    break block5;
                }
                throw new AndesException("Error occurred while delivering message. Unexpected Subscription type for message with ID : " + messageID);
            }
            catch (AMQSubscriptionClosedException e) {
                ProtocolMessage protocolMessage = ((AMQMessage)queueEntry.getMessage()).getAndesMetadataReference();
                log.error((Object)("AMQP Protocol Error while delivering message to the subscriber subID= " + this.amqpSubscription.getSubscriptionID() + " message id= " + messageID + " slot= " + protocolMessage.getMessage().getSlot().getId()), (Throwable)e);
                throw new SubscriptionAlreadyClosedException("Error occurred while delivering message with ID : " + msgHeaderStringID, e);
            }
            catch (AMQException e) {
                ProtocolMessage protocolMessage = ((AMQMessage)queueEntry.getMessage()).getAndesMetadataReference();
                log.error((Object)("AMQP Protocol Error while delivering message to the subscriber subID= " + this.amqpSubscription.getSubscriptionID() + " message id= " + messageID + " slot= " + protocolMessage.getMessage().getSlot().getId()), (Throwable)e);
                throw new ProtocolDeliveryFailureException("Error occurred while delivering message with ID : " + msgHeaderStringID, e);
            }
        }
    }
}

