/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.fusesource.hawtbuf.AbstractVarIntSupport;
import org.fusesource.hawtdb.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Ranges
implements Externalizable,
Iterable<Range> {
    private static final long serialVersionUID = 8340484139329633582L;
    private final TreeMap<Integer, Range> ranges = new TreeMap();

    public Ranges copy() {
        Ranges rc = new Ranges();
        for (Range r : this) {
            rc.ranges.put(r.start, Ranges.range(r.start, r.end));
        }
        return rc;
    }

    public void add(int start) {
        this.add(start, 1);
    }

    public void add(int start, int length) {
        int end = start + length;
        TreeMap.TreeEntry<Integer, Range> entry = this.ranges.floorEntry(end);
        if (entry != null) {
            while (entry != null) {
                Range range = entry.getValue();
                TreeMap.TreeEntry<Integer, Range> curr = entry;
                entry = entry.previous();
                if (range.end < start) break;
                if (end < range.end) {
                    end = range.end;
                }
                if (start < range.start) {
                    this.ranges.removeEntry(curr);
                    continue;
                }
                range.end = end;
                return;
            }
        }
        this.ranges.put(start, Ranges.range(start, end));
    }

    public void remove(int start) {
        this.remove(start, 1);
    }

    public void remove(int start, int length) {
        int end = start + length;
        TreeMap.TreeEntry<Integer, Range> entry = this.ranges.lowerEntry(end);
        while (entry != null) {
            Range range = entry.getValue();
            TreeMap.TreeEntry<Integer, Range> curr = entry;
            entry = entry.previous();
            if (range.end <= start) break;
            if (end < range.end) {
                this.ranges.put(end, Ranges.range(end, range.end));
            }
            if (start <= range.start) {
                this.ranges.removeEntry(curr);
                continue;
            }
            range.end = start;
            break;
        }
    }

    public boolean contains(int value) {
        TreeMap.TreeEntry<Integer, Range> entry = this.ranges.floorEntry(value);
        if (entry == null) {
            return false;
        }
        return entry.getValue().contains(value);
    }

    public void clear() {
        this.ranges.clear();
    }

    public void copy(Ranges source) {
        this.ranges.clear();
        for (Map.Entry<Integer, Range> entry : source.ranges.entrySet()) {
            Range value = entry.getValue();
            this.ranges.put(entry.getKey(), Ranges.range(value.start, value.end));
        }
    }

    public int size() {
        int rc = 0;
        for (TreeMap.TreeEntry<Integer, Range> entry = this.ranges.firstEntry(); entry != null; entry = entry.next()) {
            rc += entry.getValue().size();
        }
        return rc;
    }

    public static Range range(int start, int end) {
        return new Range(start, end);
    }

    public ArrayList<Range> toArrayList() {
        return new ArrayList<Range>(this.ranges.values());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(20 + 10 * this.ranges.size());
        sb.append("[ ");
        boolean first = true;
        for (Range r : this) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(r);
        }
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public Iterator<Range> iterator() {
        return this.ranges.values().iterator();
    }

    public Iterator<Range> iteratorNotInRange(final Range mask) {
        return new Iterator<Range>(){
            Iterator<Range> iter;
            Range last;
            Range next;
            {
                this.iter = Ranges.this.ranges.values().iterator();
                this.last = new Range(mask.start, mask.start);
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    while (this.last.end < mask.end && this.iter.hasNext()) {
                        Range r = this.iter.next();
                        if (r.end < this.last.end) continue;
                        if (r.start < this.last.end) {
                            this.last = new Range(this.last.start, r.end);
                            continue;
                        }
                        this.next = r.start < mask.end ? new Range(this.last.end, r.start) : new Range(this.last.end, mask.end);
                        break;
                    }
                }
                return this.next != null;
            }

            @Override
            public Range next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.next;
                this.next = null;
                return this.last;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List<Integer> values() {
        ArrayList<Integer> rc = new ArrayList<Integer>();
        for (Integer i : new ValueIterator(this.iterator())) {
            rc.add(i);
        }
        return rc;
    }

    public Iterator<Integer> valueIterator() {
        return new ValueIterator(this.iterator());
    }

    public Iterator<Integer> valuesIteratorNotInRange(Range r) {
        return new ValueIterator(this.iteratorNotInRange(r));
    }

    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal((DataOutput)out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.readExternal((DataInput)in);
    }

    public void writeExternal(final DataOutput out) throws IOException {
        ArrayList<Range> values = new ArrayList<Range>(this.ranges.values());
        out.writeInt(values.size());
        AbstractVarIntSupport helper = new AbstractVarIntSupport(){

            protected byte readByte() throws IOException {
                throw new UnsupportedOperationException();
            }

            protected void writeByte(int value) throws IOException {
                out.writeByte(value);
            }
        };
        int base = 0;
        for (Range range : values) {
            helper.writeVarInt(range.start - base);
            base = range.start;
            helper.writeVarInt(range.end - base);
            base = range.end;
        }
    }

    public void readExternal(final DataInput in) throws IOException {
        this.ranges.clear();
        int size = in.readInt();
        AbstractVarIntSupport helper = new AbstractVarIntSupport(){

            protected byte readByte() throws IOException {
                return in.readByte();
            }

            protected void writeByte(int value) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
        int base = 0;
        for (int i = 0; i < size; ++i) {
            int start = base += helper.readVarInt();
            int end = base += helper.readVarInt();
            this.ranges.put(start, Ranges.range(start, end));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValueIterator
    implements Iterator<Integer>,
    Iterable<Integer> {
        Iterator<Range> ranges;
        Range range;
        Integer next;
        int last;

        private ValueIterator(Iterator<Range> t) {
            this.ranges = t;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasNext() {
            if (this.next == null) {
                if (this.range == null) {
                    if (!this.ranges.hasNext()) return false;
                    this.range = this.ranges.next();
                    this.next = this.range.start;
                } else {
                    this.next = this.last + 1;
                }
                if (this.next == this.range.end - 1) {
                    this.range = null;
                }
            }
            if (this.next == null) return false;
            return true;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.next;
            this.next = null;
            return this.last;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Integer> iterator() {
            return this;
        }
    }

    public static final class Range
    implements Serializable {
        private static final long serialVersionUID = -4904483630105365841L;
        public volatile int start;
        public volatile int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int size() {
            return this.end - this.start;
        }

        public String toString() {
            if (this.start == this.end - 1) {
                return Integer.toString(this.start);
            }
            return this.start + "-" + (this.end - 1);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != Range.class) {
                return false;
            }
            Range r = (Range)obj;
            return this.start == r.start && this.end == r.end;
        }

        public int hashCode() {
            return this.start * 77 + this.end;
        }

        public boolean contains(int value) {
            return this.start <= value && value < this.end;
        }
    }
}

