/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.page;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.fusesource.hawtdb.internal.page.DeferredUpdate;

class Update
implements Externalizable {
    public static final byte PAGE_ALLOCATED = 1;
    public static final byte PAGE_FREED = 2;
    public static final byte PAGE_PUT = 4;
    public static final byte PAGE_REMOVE = 8;
    private static final long serialVersionUID = -1128410792448869134L;
    byte flags;
    int shadow = -1;
    ArrayList<String> history = new ArrayList();

    public Update note(String value) {
        this.history.add(value);
        return this;
    }

    public Update() {
    }

    public Update(Update update) {
        this.shadow = update.shadow;
        this.flags = (byte)(update.flags & 3);
        this.history = update.history;
    }

    public static Update update() {
        return new Update();
    }

    public static Update update(Update update) {
        return new Update(update);
    }

    public Update shadow(int value) {
        this.shadow = value;
        return this;
    }

    public int shadow() {
        assert (!this.freed() && this.shadowed()) : "The page does not have a shadow set.";
        return this.shadow;
    }

    boolean shadowed() {
        return this.shadow != -1;
    }

    public DeferredUpdate deferredUpdate() {
        return null;
    }

    public Update allocated(boolean value) {
        this.flags = value ? (byte)(this.flags & 0xFFFFFFFD | 1) : (byte)(this.flags & 0xFFFFFFFE);
        return this;
    }

    public Update freed(boolean value) {
        this.flags = value ? (byte)(this.flags & 0xFFFFFFFE | 2) : (byte)(this.flags & 0xFFFFFFFD);
        return this;
    }

    public boolean freed() {
        return (this.flags & 2) != 0;
    }

    public boolean allocated() {
        return (this.flags & 1) != 0;
    }

    public boolean put() {
        return (this.flags & 4) != 0;
    }

    public boolean removed() {
        return (this.flags & 8) != 0;
    }

    public String toString() {
        return "{ shadow: " + this.shadow + ", flags: " + this.flags + ", history: " + this.history + ", deferred: " + (this.deferredUpdate() != null) + " }";
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.shadow = in.readInt();
        this.flags = in.readByte();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.shadow);
        out.writeByte(this.flags);
    }

    public int translate(int page) {
        return this.shadowed() ? this.shadow : page;
    }
}

