/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.page;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.zip.CRC32;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtdb.api.Allocator;
import org.fusesource.hawtdb.api.IOPagingException;
import org.fusesource.hawtdb.api.Paged;
import org.fusesource.hawtdb.api.PagingException;
import org.fusesource.hawtdb.api.Transaction;
import org.fusesource.hawtdb.api.TxPageFile;
import org.fusesource.hawtdb.api.TxPageFileFactory;
import org.fusesource.hawtdb.internal.io.MemoryMappedFile;
import org.fusesource.hawtdb.internal.page.Batch;
import org.fusesource.hawtdb.internal.page.Commit;
import org.fusesource.hawtdb.internal.page.DeferredUpdate;
import org.fusesource.hawtdb.internal.page.Extent;
import org.fusesource.hawtdb.internal.page.ExtentInputStream;
import org.fusesource.hawtdb.internal.page.ExtentOutputStream;
import org.fusesource.hawtdb.internal.page.HawtPageFile;
import org.fusesource.hawtdb.internal.page.HawtTransaction;
import org.fusesource.hawtdb.internal.page.Logging;
import org.fusesource.hawtdb.internal.page.ReadCache;
import org.fusesource.hawtdb.internal.page.Snapshot;
import org.fusesource.hawtdb.internal.page.SnapshotTracker;
import org.fusesource.hawtdb.internal.page.Update;
import org.fusesource.hawtdb.internal.util.Ranges;
import org.fusesource.hawtdb.util.list.LinkedNodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HawtTxPageFile
implements TxPageFile {
    public static final int FILE_HEADER_SIZE = 4096;
    public static final byte[] MAGIC = HawtTxPageFile.magic();
    private final Header header = new Header();
    private final LinkedNodeList<Batch> batches = new LinkedNodeList();
    private final MemoryMappedFile file;
    final Allocator allocator;
    final HawtPageFile pageFile;
    private static final int updateBatchSize = 1024;
    private final boolean synch;
    private volatile int lastBatchPage = -1;
    volatile Batch openBatch;
    volatile Batch storingBatches;
    volatile Batch storedBatches;
    volatile Batch performedBatches;
    volatile ReadCache readCache;
    private final HOUSE_KEEPING_MUTEX HOUSE_KEEPING_MUTEX = new HOUSE_KEEPING_MUTEX();
    final TRANSACTION_MUTEX TRANSACTION_MUTEX = new TRANSACTION_MUTEX();
    private Ranges storedFreeList = new Ranges();
    private final ExecutorService worker;

    private static byte[] magic() {
        try {
            byte[] rc = new byte[32];
            byte[] tmp = "HawtDB:1.0\n".getBytes("UTF-8");
            System.arraycopy(tmp, 0, rc, 0, tmp.length);
            return rc;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public HawtTxPageFile(TxPageFileFactory factory, HawtPageFile pageFile) {
        this.pageFile = pageFile;
        this.synch = factory.isSync();
        this.file = pageFile.getFile();
        this.allocator = pageFile.allocator();
        this.readCache = new ReadCache(pageFile, factory.getPageCache());
        this.worker = factory.isUseWorkerThread() ? Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread rc = new Thread(r);
                rc.setName("HawtDB Worker");
                rc.setDaemon(true);
                return rc;
            }
        }) : null;
    }

    public ReadCache readCache() {
        return this.readCache;
    }

    public void close() {
        if (this.worker != null) {
            final CountDownLatch done = new CountDownLatch(1);
            this.worker.execute(new Runnable(){

                public void run() {
                    done.countDown();
                    HawtTxPageFile.this.worker.shutdownNow();
                }
            });
            try {
                done.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.flush();
        this.performBatches();
    }

    public String toString() {
        return "{\n  allocator: " + this.allocator + ",\n" + "  synch: " + this.synch + ",\n" + "  read cache size: " + this.readCache.cache().size() + ",\n" + "  base revision free pages: " + this.storedFreeList + ",\n" + "  batches: {\n" + "    performed: " + this.toString(this.performedBatches, this.storedBatches) + ",\n" + "    stored: " + this.toString(this.storedBatches, this.storingBatches) + ",\n" + "    storing: " + this.toString(this.storingBatches, this.openBatch) + ",\n" + "    open: " + this.toString(this.openBatch, null) + ",\n" + "  }" + "\n" + "}";
    }

    private String toString(Batch from, Batch to) {
        StringBuilder rc = new StringBuilder();
        rc.append("[ ");
        for (Batch t = from; t != null && t != to; t = (Batch)t.getNext()) {
            if (t != from) {
                rc.append(", ");
            }
            rc.append(t);
        }
        rc.append(" ]");
        return rc.toString();
    }

    @Override
    public Transaction tx() {
        return new HawtTransaction(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(Snapshot snapshot, ConcurrentHashMap<Integer, Update> pageUpdates, ArrayList<Runnable> flushCallbacks) {
        boolean fullBatch = false;
        Commit commit = null;
        Object object = this.TRANSACTION_MUTEX;
        synchronized (object) {
            long rev;
            if (snapshot != null) {
                rev = snapshot.getTracker().commitCheck(pageUpdates);
                snapshot.close();
            } else {
                rev = this.openBatch.head;
            }
            ++rev;
            if (flushCallbacks != null) {
                this.openBatch.flushCallbacks.addAll(flushCallbacks);
            }
            if ((commit = this.openBatch.commits.getTail()) != null && commit.snapshotTracker == null) {
                commit.merge((Allocator)this.pageFile.allocator(), rev, pageUpdates);
            } else {
                commit = new Commit(rev, pageUpdates);
                this.openBatch.commits.addLast(commit);
            }
            if (this.openBatch.base == -1L) {
                this.openBatch.base = rev;
            }
            this.openBatch.head = rev;
            if (this.openBatch.pageCount() > 1024) {
                fullBatch = true;
            }
        }
        if (fullBatch) {
            Logging.trace("batch full.", new Object[0]);
            object = this.HOUSE_KEEPING_MUTEX;
            synchronized (object) {
                this.storeBatches(false);
            }
            if (this.worker != null) {
                this.worker.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        HOUSE_KEEPING_MUTEX hOUSE_KEEPING_MUTEX = HawtTxPageFile.this.HOUSE_KEEPING_MUTEX;
                        synchronized (hOUSE_KEEPING_MUTEX) {
                            HawtTxPageFile.this.syncBatches();
                        }
                    }
                });
            } else {
                object = this.HOUSE_KEEPING_MUTEX;
                synchronized (object) {
                    this.syncBatches();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        HOUSE_KEEPING_MUTEX hOUSE_KEEPING_MUTEX = this.HOUSE_KEEPING_MUTEX;
        synchronized (hOUSE_KEEPING_MUTEX) {
            this.batches.clear();
            this.storingBatches = this.openBatch = new Batch(-1L);
            this.storedBatches = this.openBatch;
            this.performedBatches = this.openBatch;
            this.batches.addFirst(this.openBatch);
            this.lastBatchPage = -1;
            this.readCache.cache().clear();
            this.allocator.clear();
            this.storedFreeList.clear();
            this.storedFreeList.add(0, this.allocator.getLimit());
            System.arraycopy(MAGIC, 0, this.header.magic, 0, MAGIC.length);
            this.header.base_revision = -1L;
            this.header.free_list_page = -1;
            this.header.page_size = this.pageFile.getPageSize();
            this.header.pessimistic_recovery_page = -1;
            this.header.optimistic_recovery_page = -1;
            this.storeHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() {
        HOUSE_KEEPING_MUTEX hOUSE_KEEPING_MUTEX = this.HOUSE_KEEPING_MUTEX;
        synchronized (hOUSE_KEEPING_MUTEX) {
            this.batches.clear();
            this.storingBatches = this.openBatch = new Batch(-1L);
            this.storedBatches = this.openBatch;
            this.performedBatches = this.openBatch;
            this.batches.addFirst(this.openBatch);
            this.lastBatchPage = -1;
            this.readCache.cache().clear();
            Buffer buffer = new Buffer(4096);
            this.file.read(0L, buffer);
            this.header.decode(buffer);
            if (!Arrays.equals(MAGIC, this.header.magic)) {
                throw new PagingException("The file header is not of the expected type.");
            }
            Logging.trace("recovery started.  header: %s", this.header);
            if (this.header.free_list_page >= 0) {
                this.storedFreeList = (Ranges)this.loadObject(this.header.free_list_page);
                Logging.trace("loaded free page list: %s ", this.storedFreeList);
                this.allocator.setFreeRanges(this.storedFreeList);
                Extent.unfree(this.pageFile, this.header.free_list_page);
            } else {
                this.allocator.clear();
                this.storedFreeList.add(0, this.allocator.getLimit());
            }
            int pageId = this.header.pessimistic_recovery_page;
            if (this.header.optimistic_recovery_page >= 0) {
                pageId = this.header.optimistic_recovery_page;
            }
            LinkedList<Batch> loaded = new LinkedList<Batch>();
            boolean consistencyCheckNeeded = true;
            while (pageId >= 0) {
                Batch batch;
                block16: {
                    Logging.trace("loading batch at: %d", pageId);
                    batch = null;
                    if (pageId == this.header.pessimistic_recovery_page) {
                        consistencyCheckNeeded = false;
                    }
                    if (consistencyCheckNeeded) {
                        try {
                            batch = (Batch)this.loadObject(pageId);
                            break block16;
                        }
                        catch (Exception e) {
                            Logging.trace("incomplete batch at: %d", pageId);
                            loaded.clear();
                            pageId = this.header.pessimistic_recovery_page;
                            continue;
                        }
                    }
                    batch = (Batch)this.loadObject(pageId);
                }
                batch.page = pageId;
                batch.recovered = true;
                loaded.add(batch);
                Logging.trace("loaded batch: %s", batch);
                if (this.header.base_revision + 1L == batch.base) break;
                pageId = batch.previous;
            }
            if (loaded.isEmpty()) {
                Logging.trace("no batches need to be recovered.", new Object[0]);
            } else {
                for (Batch batch : loaded) {
                    Extent.unfree(this.pageFile, batch.page);
                    if (this.openBatch.head == -1L) {
                        this.openBatch.head = batch.head;
                    }
                    this.batches.addFirst(batch);
                    this.performedBatches = this.storedBatches = batch;
                }
                this.performBatches();
                this.syncBatches();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        HOUSE_KEEPING_MUTEX hOUSE_KEEPING_MUTEX = this.HOUSE_KEEPING_MUTEX;
        synchronized (hOUSE_KEEPING_MUTEX) {
            this.storeBatches(true);
            this.syncBatches();
        }
    }

    @Override
    public void flush(final Runnable onComplete) {
        if (this.worker != null) {
            this.worker.execute(new Runnable(){

                public void run() {
                    HawtTxPageFile.this.flush();
                    onComplete.run();
                }
            });
        } else {
            this.flush();
            onComplete.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeBatches(boolean force) {
        Batch batch;
        TRANSACTION_MUTEX tRANSACTION_MUTEX = this.TRANSACTION_MUTEX;
        synchronized (tRANSACTION_MUTEX) {
            if (!(force && this.openBatch.base != -1L || this.openBatch.pageCount() > 1024)) {
                return;
            }
            batch = this.openBatch;
            this.openBatch = new Batch(batch.head);
            this.batches.addLast(this.openBatch);
        }
        batch.performDeferredUpdates(this.pageFile);
        batch.previous = this.lastBatchPage;
        this.lastBatchPage = batch.page = this.storeObject(batch);
        Logging.trace("stored batch: %s", batch);
        this.header.optimistic_recovery_page = batch.page;
        this.storeHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncBatches() {
        if (this.synch) {
            this.file.sync();
        }
        if (this.performedBatches != this.storedBatches) {
            Batch lastPerformedBatch = (Batch)this.storedBatches.getPrevious();
            this.header.base_revision = lastPerformedBatch.head;
        }
        if (this.storingBatches != this.openBatch) {
            for (Batch cur = this.storingBatches; cur != this.openBatch; cur = (Batch)cur.getNext()) {
                for (Runnable runnable : this.storingBatches.flushCallbacks) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            Batch lastStoredBatch = (Batch)this.openBatch.getPrevious();
            this.header.pessimistic_recovery_page = lastStoredBatch.page;
            if (this.header.optimistic_recovery_page == this.header.pessimistic_recovery_page) {
                this.header.optimistic_recovery_page = -1;
            }
            TRANSACTION_MUTEX tRANSACTION_MUTEX = this.TRANSACTION_MUTEX;
            synchronized (tRANSACTION_MUTEX) {
                this.storingBatches = this.openBatch;
            }
        }
        this.performBatches();
        while (this.performedBatches != this.storedBatches && this.performedBatches.snapshots == 0) {
            if (this.performedBatches.page == this.header.pessimistic_recovery_page) {
                this.header.pessimistic_recovery_page = -1;
            }
            this.performedBatches.release(this.allocator);
            Extent.free(this.pageFile, this.performedBatches.page);
            this.performedBatches = (Batch)this.performedBatches.getNext();
            ((Batch)this.performedBatches.getPrevious()).unlink();
        }
        int previousFreeListPage = this.header.free_list_page;
        this.header.free_list_page = this.storeObject(this.storedFreeList);
        this.storeHeader();
        if (previousFreeListPage >= 0) {
            Extent.free(this.pageFile, previousFreeListPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performBatches() {
        if (this.storedBatches == this.storingBatches) {
            return;
        }
        Batch lastPerformed = (Batch)this.storedBatches.getPrevious();
        if (lastPerformed != null && lastPerformed.snapshots != 0) {
            return;
        }
        while (this.storedBatches != this.storingBatches) {
            Logging.trace("Performing batch: %s", this.storedBatches);
            for (Commit commit : this.storedBatches) {
                for (Map.Entry<Integer, Update> entry : commit.updates.entrySet()) {
                    DeferredUpdate du;
                    int page = entry.getKey();
                    Update update = entry.getValue();
                    if (Logging.traced(page) || update.shadowed() && Logging.traced(update.shadow())) {
                        Logging.trace("performing update at %d %s", page, update);
                    }
                    if (update.shadowed()) {
                        if (this.storedBatches.recovered) {
                            this.allocator.unfree(update.shadow(), 1);
                        }
                        if (Logging.traced(page) || Logging.traced(update.shadow())) {
                            Logging.trace("performing shadow update on %d from %d", page, update.shadow());
                        }
                        ByteBuffer slice = this.pageFile.slice(Paged.SliceType.READ, update.shadow(), 1);
                        try {
                            this.pageFile.write(page, slice);
                        }
                        finally {
                            this.pageFile.unslice(slice);
                        }
                    }
                    if (update.allocated()) {
                        if (this.storedBatches.recovered) {
                            this.allocator.unfree(page, 1);
                        }
                        this.storedFreeList.remove(page, 1);
                    } else if (update.freed()) {
                        this.storedFreeList.add(page, 1);
                    }
                    if ((du = update.deferredUpdate()) == null) continue;
                    if (du.removed()) {
                        this.readCache.cache().remove(page);
                        continue;
                    }
                    if (!du.put()) continue;
                    this.readCache.cache().put(page, du.value);
                }
            }
            this.storedBatches.performed = true;
            TRANSACTION_MUTEX tRANSACTION_MUTEX = this.TRANSACTION_MUTEX;
            synchronized (tRANSACTION_MUTEX) {
                this.storedBatches = (Batch)this.storedBatches.getNext();
            }
            lastPerformed = (Batch)this.storedBatches.getPrevious();
            if (lastPerformed.snapshots == 0) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Snapshot openSnapshot() {
        TRANSACTION_MUTEX tRANSACTION_MUTEX = this.TRANSACTION_MUTEX;
        synchronized (tRANSACTION_MUTEX) {
            Commit commit = this.openBatch.getHeadCommit();
            SnapshotTracker tracker = null;
            if (commit != null) {
                if (commit.snapshotTracker == null) {
                    commit.snapshotTracker = new SnapshotTracker(this.openBatch, commit);
                }
                tracker = commit.snapshotTracker;
            } else {
                tracker = new SnapshotTracker(this.openBatch, null);
            }
            return new Snapshot(this, tracker, this.storedBatches, this.openBatch).open();
        }
    }

    private int storeObject(Object value) {
        try {
            ExtentOutputStream eos = new ExtentOutputStream(this.pageFile);
            ObjectOutputStream oos = new ObjectOutputStream(eos);
            oos.writeObject(value);
            oos.close();
            return eos.getPage();
        }
        catch (IOException e) {
            throw new IOPagingException(e);
        }
    }

    private <T> T loadObject(int pageId) {
        try {
            ExtentInputStream eis = new ExtentInputStream(this.pageFile, pageId);
            ObjectInputStream ois = new ObjectInputStream(eis);
            return (T)ois.readObject();
        }
        catch (IOException e) {
            throw new IOPagingException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IOPagingException(e);
        }
    }

    private void storeHeader() {
        Logging.trace("storing file header: %s", this.header);
        this.file.write(0L, this.header.encode());
    }

    private static class TRANSACTION_MUTEX {
        private TRANSACTION_MUTEX() {
        }

        public String toString() {
            return "TRANSACTION_MUTEX";
        }
    }

    private static class HOUSE_KEEPING_MUTEX {
        private HOUSE_KEEPING_MUTEX() {
        }

        public String toString() {
            return "HOUSE_KEEPING_MUTEX";
        }
    }

    private static class Header {
        public volatile byte[] magic = new byte[32];
        public volatile long base_revision;
        public volatile int page_size;
        public volatile int free_list_page;
        public volatile int pessimistic_recovery_page;
        public volatile int optimistic_recovery_page;
        private final DataByteArrayOutputStream os = new DataByteArrayOutputStream(4096);

        private Header() {
        }

        public String toString() {
            return "{ base_revision: " + this.base_revision + ", page_size: " + this.page_size + ", free_list_page: " + this.free_list_page + ", pessimistic_recovery_page: " + this.pessimistic_recovery_page + ", optimistic_recovery_page: " + this.optimistic_recovery_page + " }";
        }

        Buffer encode() {
            try {
                this.os.reset();
                this.os.write(this.magic);
                this.os.writeLong(this.base_revision);
                this.os.writeInt(this.page_size);
                this.os.writeInt(this.free_list_page);
                this.os.writeInt(this.pessimistic_recovery_page);
                this.os.writeInt(this.optimistic_recovery_page);
                int length = this.os.position();
                byte[] data = this.os.getData();
                CRC32 checksum = new CRC32();
                checksum.update(data, 0, length);
                this.os.position(2040);
                this.os.writeLong(checksum.getValue());
                System.arraycopy(data, 0, data, 2048, length);
                this.os.position(2040);
                this.os.writeLong(checksum.getValue());
                return this.os.toBuffer();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        void decode(Buffer buffer) throws PagingException {
            DataByteArrayInputStream is = new DataByteArrayInputStream(buffer);
            int length = this.readFields(is);
            is.setPos(2040);
            long expectedChecksum = is.readLong();
            CRC32 checksum = new CRC32();
            checksum.update(buffer.data, 0, length);
            if (checksum.getValue() != expectedChecksum) {
                is.setPos(2048);
                length = this.readFields(is);
                is.setPos(4088);
                expectedChecksum = is.readLong();
                checksum = new CRC32();
                checksum.update(buffer.data, 0, length);
                if (checksum.getValue() != expectedChecksum) {
                    throw new PagingException("file header corruption detected.");
                }
            }
        }

        private int readFields(DataByteArrayInputStream is) {
            is.readFully(this.magic);
            this.base_revision = is.readLong();
            this.page_size = is.readInt();
            this.free_list_page = is.readInt();
            this.pessimistic_recovery_page = is.readInt();
            this.optimistic_recovery_page = is.readInt();
            int length = is.getPos();
            return length;
        }
    }
}

