/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.page;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdb.api.Allocator;
import org.fusesource.hawtdb.api.IOPagingException;
import org.fusesource.hawtdb.api.OutOfSpaceException;
import org.fusesource.hawtdb.api.Paged;
import org.fusesource.hawtdb.api.PagedAccessor;
import org.fusesource.hawtdb.api.PagingException;
import org.fusesource.hawtdb.api.Transaction;
import org.fusesource.hawtdb.internal.page.DeferredUpdate;
import org.fusesource.hawtdb.internal.page.HawtTxPageFile;
import org.fusesource.hawtdb.internal.page.Snapshot;
import org.fusesource.hawtdb.internal.page.Update;
import org.fusesource.hawtdb.internal.util.Ranges;
import org.fusesource.hawtdb.util.StringSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HawtTransaction
implements Transaction {
    private final HawtTxPageFile parent;
    private ConcurrentHashMap<Integer, Update> updates;
    private ArrayList<Runnable> flushCallbacks;
    private Snapshot snapshot;
    private boolean closed;
    private final Allocator txallocator = new Allocator(){

        public void free(int pageId, int count) {
            HawtTransaction.this.assertOpen();
            int end = pageId + count;
            for (int key = pageId; key < end; ++key) {
                Update previous = HawtTransaction.this.getUpdates().put(key, Update.update().freed(true).note("free " + key));
                if (previous == null || !previous.allocated()) continue;
                HawtTransaction.this.getUpdates().remove(key);
                ((HawtTransaction)HawtTransaction.this).parent.allocator.free(key, 1);
            }
        }

        public int alloc(int count) throws OutOfSpaceException {
            HawtTransaction.this.assertOpen();
            int pageId = HawtTransaction.this.palloc(count);
            int end = pageId + count;
            for (int key = pageId; key < end; ++key) {
                HawtTransaction.this.getUpdates().put(key, Update.update().allocated(true).note("alloc " + key));
            }
            return pageId;
        }

        public void unfree(int pageId, int count) {
            HawtTransaction.this.assertOpen();
            throw new UnsupportedOperationException();
        }

        public void clear() throws UnsupportedOperationException {
            HawtTransaction.this.assertOpen();
            throw new UnsupportedOperationException();
        }

        public int getLimit() {
            HawtTransaction.this.assertOpen();
            return ((HawtTransaction)HawtTransaction.this).parent.allocator.getLimit();
        }

        public boolean isAllocated(int page) {
            HawtTransaction.this.assertOpen();
            return ((HawtTransaction)HawtTransaction.this).parent.allocator.isAllocated(page);
        }

        public void setFreeRanges(Ranges freeList) {
            throw new UnsupportedOperationException();
        }

        public Ranges getFreeRanges() {
            throw new UnsupportedOperationException();
        }
    };

    HawtTransaction(HawtTxPageFile concurrentPageFile) {
        this.parent = concurrentPageFile;
    }

    private void assertOpen() {
        assert (!this.closed) : "The transaction had been closed.";
    }

    @Override
    public void close() {
        this.assertOpen();
        assert (this.snapshot == null) : "The transaction must be committed or rolled back before it is closed.";
        this.closed = true;
    }

    @Override
    public void onFlush(Runnable runnable) {
        if (this.flushCallbacks == null) {
            this.flushCallbacks = new ArrayList(1);
        }
        this.flushCallbacks.add(runnable);
    }

    @Override
    public <T> T get(PagedAccessor<T> marshaller, int page) {
        Update update;
        this.assertOpen();
        Update update2 = update = this.updates == null ? null : this.updates.get(page);
        if (update != null) {
            if (update.freed()) {
                throw new PagingException("That page was freed.");
            }
            DeferredUpdate deferred = update.deferredUpdate();
            if (deferred != null) {
                return deferred.value();
            }
            throw new PagingException("That page was updated with the 'put' method.");
        }
        T rc = this.snapshot().getTracker().get(marshaller, page);
        if (rc == null) {
            rc = this.parent.readCache().cacheLoad(marshaller, page);
        }
        return rc;
    }

    @Override
    public <T> void put(PagedAccessor<T> marshaller, int page, T value) {
        this.assertOpen();
        ConcurrentHashMap<Integer, Update> updates = this.getUpdates();
        Update update = updates.get(page);
        DeferredUpdate deferred = null;
        if (update == null) {
            this.snapshot();
            deferred = DeferredUpdate.deferred();
            updates.put(page, deferred);
        } else {
            if (update.freed()) {
                throw new PagingException("You should never try to update a page that has been freed.");
            }
            deferred = update.deferredUpdate();
            if (deferred == null) {
                deferred = DeferredUpdate.deferred(update);
                updates.put(page, deferred);
            }
        }
        deferred.note("put " + page);
        deferred.put(value, marshaller);
    }

    @Override
    public <T> void clear(PagedAccessor<T> marshaller, int page) {
        this.assertOpen();
        ConcurrentHashMap<Integer, Update> updates = this.getUpdates();
        Update update = updates.get(page);
        if (update == null) {
            updates.put(page, DeferredUpdate.deferred().remove(marshaller).note("clear " + page + " deferred"));
        } else {
            if (!update.put()) {
                throw new PagingException("You should never try to clear a page that was not put.");
            }
            if (update.allocated()) {
                updates.put(page, Update.update(update).note("clear " + page + " back to un-deferred"));
            } else {
                updates.put(page, ((DeferredUpdate)update).remove(marshaller).note("clear " + page));
            }
        }
    }

    @Override
    public Allocator allocator() {
        this.assertOpen();
        return this.txallocator;
    }

    @Override
    public int alloc() {
        this.assertOpen();
        return this.allocator().alloc(1);
    }

    @Override
    public void free(int page) {
        this.assertOpen();
        this.allocator().free(page, 1);
    }

    @Override
    public void read(int page, Buffer buffer) throws IOPagingException {
        this.assertOpen();
        Update update = this.updates == null ? null : this.updates.get(page);
        page = update != null && update.shadowed() ? update.shadow() : this.snapshot().getTracker().translatePage(page);
        this.parent.pageFile.read(page, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer slice(Paged.SliceType type, int page, int count) throws IOPagingException {
        this.assertOpen();
        if (type == Paged.SliceType.READ) {
            Update update;
            Update update2 = update = this.updates == null ? null : this.updates.get(page);
            page = update != null && update.shadowed() ? update.shadow() : this.snapshot().getTracker().translatePage(page);
        } else {
            Update update = this.getUpdates().get(page);
            if (update == null) {
                update = Update.update().shadow(this.palloc(count));
                int end = page + count;
                for (int i = page; i < end; ++i) {
                    this.getUpdates().put(i, Update.update().shadow(i));
                }
                if (type == Paged.SliceType.READ_WRITE) {
                    int originalPage = this.snapshot().getTracker().translatePage(page);
                    ByteBuffer slice = this.parent.pageFile.slice(Paged.SliceType.READ, originalPage, count);
                    try {
                        this.parent.pageFile.write(update.translate(page), slice);
                    }
                    finally {
                        this.parent.pageFile.unslice(slice);
                    }
                }
                this.getUpdates().put(page, update);
            }
            page = update.translate(page);
        }
        return this.parent.pageFile.slice(type, page, count);
    }

    private int palloc(int count) {
        return this.parent.allocator.alloc(count);
    }

    @Override
    public void unslice(ByteBuffer buffer) {
        this.assertOpen();
        this.parent.pageFile.unslice(buffer);
    }

    @Override
    public void write(int page, Buffer buffer) throws IOPagingException {
        this.assertOpen();
        Update update = this.getUpdates().get(page);
        if (update == null) {
            this.snapshot();
            update = Update.update().shadow(this.palloc(1));
            this.getUpdates().put(page, update);
        }
        if (update.shadowed()) {
            page = update.shadow();
        }
        this.parent.pageFile.write(page, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws IOPagingException {
        this.assertOpen();
        boolean failed = true;
        try {
            if (this.updates != null) {
                this.parent.commit(this.snapshot, this.updates, this.flushCallbacks);
                this.snapshot = null;
            }
            failed = false;
        }
        finally {
            if (failed) {
                this.rollback();
            }
            this.updates = null;
            this.flushCallbacks = null;
            if (this.snapshot != null) {
                this.snapshot.close();
                this.snapshot = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws IOPagingException {
        this.assertOpen();
        try {
            if (this.updates != null) {
                for (Map.Entry<Integer, Update> entry : this.updates.entrySet()) {
                    Integer page = entry.getKey();
                    Update update = entry.getValue();
                    if (update.freed()) continue;
                    this.allocator().free(update.translate(page), 1);
                }
            }
        }
        finally {
            if (this.snapshot != null) {
                this.snapshot.close();
                this.snapshot = null;
            }
            this.updates = null;
            this.flushCallbacks = null;
        }
    }

    public Snapshot snapshot() {
        if (this.snapshot == null) {
            this.snapshot = this.parent.openSnapshot();
        }
        return this.snapshot;
    }

    @Override
    public boolean isReadOnly() {
        this.assertOpen();
        return this.updates == null;
    }

    private ConcurrentHashMap<Integer, Update> getUpdates() {
        if (this.updates == null) {
            this.updates = new ConcurrentHashMap();
        }
        return this.updates;
    }

    @Override
    public int getPageSize() {
        this.assertOpen();
        return this.parent.pageFile.getPageSize();
    }

    public String toString() {
        int updatesSize = this.updates == null ? 0 : this.updates.size();
        return "{ \n  snapshot: " + this.snapshot + ", \n" + "  updates: " + updatesSize + ", \n" + "  parent: " + StringSupport.indent(this.parent.toString(), 2) + "\n" + "}";
    }

    @Override
    public int pages(int length) {
        this.assertOpen();
        return this.parent.pageFile.pages(length);
    }

    @Override
    public void flush() {
        this.assertOpen();
        this.parent.flush();
    }
}

