/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.page;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdb.api.IOPagingException;
import org.fusesource.hawtdb.api.Paged;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extent {
    public static final Buffer DEFAULT_MAGIC = new Buffer(new byte[]{120});
    private final Paged paged;
    private final int page;
    private final Buffer magic;
    private ByteBuffer buffer;
    private int length;
    private int next;

    public Extent(Paged paged, int page) {
        this(paged, page, DEFAULT_MAGIC);
    }

    public Extent(Paged paged, int page, Buffer magic) {
        this.paged = paged;
        this.page = page;
        this.magic = magic;
    }

    public String toString() {
        Integer position = null;
        Integer limit = null;
        if (this.buffer != null) {
            position = this.buffer.position();
            limit = this.buffer.limit();
        }
        return "{ page: " + this.page + ", position: " + position + ", limit: " + limit + ", length: " + this.length + ", next: " + this.next + " }";
    }

    public void readHeader() {
        this.buffer = this.paged.slice(Paged.SliceType.READ, this.page, 1);
        Buffer m = new Buffer(this.magic.length);
        this.buffer.get(m.data);
        if (!this.magic.equals(m)) {
            throw new IOPagingException("Invalid extent read request.  The requested page was not an extent: " + this.page);
        }
        IntBuffer ib = this.buffer.asIntBuffer();
        this.length = ib.get();
        this.next = ib.get();
    }

    public void readOpen() {
        this.readHeader();
        int pages = this.paged.pages(this.length);
        if (pages > 1) {
            this.paged.unslice(this.buffer);
            this.buffer = this.paged.slice(Paged.SliceType.READ, this.page, pages);
        }
        this.buffer.position(this.magic.length + 8);
        this.buffer.limit(this.length);
    }

    public void writeOpen(short size) {
        this.buffer = this.paged.slice(Paged.SliceType.WRITE, this.page, size);
        this.buffer.position(this.magic.length + 8);
    }

    public int writeCloseLinked(int next) {
        this.next = next;
        this.length = this.buffer.position();
        this.buffer.position(0);
        this.buffer.put(this.magic.data, this.magic.offset, this.magic.length);
        IntBuffer ib = this.buffer.asIntBuffer();
        ib.put(this.length);
        ib.put(next);
        this.paged.unslice(this.buffer);
        return this.length;
    }

    public void writeCloseEOF() {
        int usedPages;
        int length = this.writeCloseLinked(-1);
        int originalPages = this.paged.pages(this.buffer.limit());
        int remainingPages = originalPages - (usedPages = this.paged.pages(length));
        if (remainingPages > 0) {
            this.paged.allocator().free(this.page + usedPages, remainingPages);
        }
        this.paged.unslice(this.buffer);
    }

    public void readClose() {
        this.paged.unslice(this.buffer);
    }

    boolean atEnd() {
        return this.buffer.remaining() == 0;
    }

    public boolean write(byte b) {
        if (this.atEnd()) {
            return false;
        }
        this.buffer.put(b);
        return true;
    }

    public boolean write(Buffer source) {
        while (source.length > 0) {
            if (this.atEnd()) {
                return false;
            }
            int count = Math.min(this.buffer.remaining(), source.length);
            this.buffer.put(source.data, source.offset, count);
            source.offset += count;
            source.length -= count;
        }
        return true;
    }

    public int read() {
        return this.buffer.get() & 0xFF;
    }

    public void read(Buffer target) {
        while (target.length > 0 && !this.atEnd()) {
            int count = Math.min(this.buffer.remaining(), target.length);
            this.buffer.get(target.data, target.offset, count);
            target.offset += count;
            target.length -= count;
        }
    }

    public int getNext() {
        return this.next;
    }

    public static List<Integer> pagesLinked(Paged paged, int page) {
        return Extent.freeLinked(paged, page, DEFAULT_MAGIC);
    }

    public static List<Integer> pagesLinked(Paged paged, int page, Buffer magic) {
        Extent extent = new Extent(paged, page, magic);
        extent.readHeader();
        return Extent.pages(paged, extent.getNext());
    }

    public static List<Integer> pages(Paged paged, int page) {
        return Extent.pages(paged, page, DEFAULT_MAGIC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> pages(Paged paged, int page, Buffer magic) {
        ArrayList<Integer> rc = new ArrayList<Integer>();
        while (page >= 0) {
            Extent extent = new Extent(paged, page, magic);
            extent.readHeader();
            try {
                int pagesInExtent = paged.pages(extent.getLength());
                for (int i = 0; i < pagesInExtent; ++i) {
                    rc.add(page + i);
                }
                page = extent.getNext();
            }
            finally {
                extent.readClose();
            }
        }
        return rc;
    }

    public static List<Integer> freeLinked(Paged paged, int page) {
        return Extent.freeLinked(paged, page, DEFAULT_MAGIC);
    }

    public static List<Integer> freeLinked(Paged paged, int page, Buffer magic) {
        Extent extent = new Extent(paged, page, magic);
        extent.readHeader();
        return Extent.free(paged, extent.getNext());
    }

    public static List<Integer> free(Paged paged, int page) {
        return Extent.free(paged, page, DEFAULT_MAGIC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> free(Paged paged, int page, Buffer magic) {
        ArrayList<Integer> rc = new ArrayList<Integer>();
        while (page >= 0) {
            Extent extent = new Extent(paged, page, magic);
            extent.readHeader();
            try {
                int pagesInExtent = paged.pages(extent.getLength());
                paged.allocator().free(page, pagesInExtent);
                for (int i = 0; i < pagesInExtent; ++i) {
                    rc.add(page + i);
                }
                page = extent.getNext();
            }
            finally {
                extent.readClose();
            }
        }
        return rc;
    }

    public static void unfree(Paged paged, int page) {
        Extent.unfree(paged, page, DEFAULT_MAGIC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unfree(Paged paged, int page, Buffer magic) {
        while (page >= 0) {
            Extent extent = new Extent(paged, page, magic);
            extent.readHeader();
            try {
                paged.allocator().unfree(page, paged.pages(extent.length));
                page = extent.next;
            }
            finally {
                extent.readClose();
            }
        }
    }

    public int getPage() {
        return this.page;
    }

    public int getLength() {
        return this.length;
    }
}

