/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.index;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.fusesource.hawtdb.api.Predicate;
import org.fusesource.hawtdb.internal.index.BTreeIndex;
import org.fusesource.hawtdb.internal.index.BTreeNode;
import org.fusesource.hawtdb.internal.index.MapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BTreePredicateIterator<Key, Value>
implements Iterator<Map.Entry<Key, Value>> {
    private final BTreeIndex<Key, Value> index;
    private Predicate<Key> predicate;
    private final Stack<Data<Key, Value>> stack = new Stack();
    private Map.Entry<Key, Value> nextEntry;

    BTreePredicateIterator(BTreeIndex<Key, Value> index, BTreeNode<Key, Value> root, Predicate<Key> predicate) {
        this.index = index;
        this.predicate = predicate;
        this.stack.push(new Data<Key, Value>(root));
    }

    private void findNextEntry() {
        while (this.nextEntry == null && !this.stack.isEmpty()) {
            Data<Key, Value> current = this.stack.peek();
            BTreeNode node = ((Data)current).node;
            BTreeNode.Data data = node.data;
            if (node.isBranch()) {
                if (((Data)current).pos < data.children.length) {
                    Object key1 = null;
                    if (((Data)current).pos != 0) {
                        key1 = data.keys[((Data)current).pos - 1];
                    }
                    Object key2 = null;
                    if (((Data)current).pos != data.children.length - 1) {
                        key2 = data.keys[((Data)current).pos];
                    }
                    if (this.predicate.isInterestedInKeysBetween(key1, key2, this.index.getComparator())) {
                        this.stack.push(new Data<Key, Value>(node.getChild(this.index, ((Data)current).pos)));
                    }
                    ((Data)current).pos++;
                    continue;
                }
                this.stack.pop();
                continue;
            }
            if (((Data)current).pos < data.keys.length) {
                if (this.predicate.isInterestedInKey(data.keys[((Data)current).pos], this.index.getComparator())) {
                    this.nextEntry = new MapEntry(data.keys[((Data)current).pos], data.values[((Data)current).pos]);
                }
                ((Data)current).pos++;
                continue;
            }
            this.stack.pop();
        }
    }

    @Override
    public boolean hasNext() {
        this.findNextEntry();
        return this.nextEntry != null;
    }

    @Override
    public Map.Entry<Key, Value> next() {
        this.findNextEntry();
        if (this.nextEntry != null) {
            Map.Entry<Key, Value> lastEntry = this.nextEntry;
            this.nextEntry = null;
            return lastEntry;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Data<Key, Value> {
        private BTreeNode<Key, Value> node;
        private int pos;

        public Data(BTreeNode<Key, Value> node) {
            this.node = node;
        }
    }
}

