/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.index;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtbuf.codec.Codec;
import org.fusesource.hawtdb.api.BTreeIndexFactory;
import org.fusesource.hawtdb.api.IndexException;
import org.fusesource.hawtdb.api.IndexVisitor;
import org.fusesource.hawtdb.api.Paged;
import org.fusesource.hawtdb.api.Predicate;
import org.fusesource.hawtdb.api.Prefixer;
import org.fusesource.hawtdb.api.SortedIndex;
import org.fusesource.hawtdb.internal.index.BTreeNode;
import org.fusesource.hawtdb.internal.page.Extent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeIndex<Key, Value>
implements SortedIndex<Key, Value> {
    private final BTreeNode.DataPagedAccessor<Key, Value> DATA_ENCODER_DECODER = new BTreeNode.DataPagedAccessor(this);
    private final Paged paged;
    private final int page;
    private final Codec<Key> keyCodec;
    private final Codec<Value> valueCodec;
    private final Prefixer<Key> prefixer;
    private final boolean deferredEncoding;
    private final Comparator comparator;

    public BTreeIndex(Paged paged, int page, BTreeIndexFactory<Key, Value> factory) {
        this.paged = paged;
        this.page = page;
        this.keyCodec = factory.getKeyCodec();
        this.valueCodec = factory.getValueCodec();
        this.deferredEncoding = !(!factory.isDeferredEncoding() || !this.keyCodec.isEstimatedSizeSupported() && this.keyCodec.getFixedSize() < 0 || !this.valueCodec.isEstimatedSizeSupported() && this.valueCodec.getFixedSize() < 0);
        this.prefixer = factory.getPrefixer();
        this.comparator = factory.getComparator();
    }

    public String toString() {
        return "{ page: " + this.page + ", deferredEncoding: " + this.deferredEncoding + " }";
    }

    public void create() {
        BTreeNode root = new BTreeNode(null, this.page);
        this.storeNode(root);
    }

    @Override
    public boolean containsKey(Key key) {
        return this.root().contains(this, key);
    }

    @Override
    public Value get(Key key) {
        return this.root().get(this, key);
    }

    @Override
    public Value put(Key key, Value value) {
        return this.root().put(this, key, value);
    }

    @Override
    public Value putIfAbsent(Key key, Value value) {
        return this.root().putIfAbsent(this, key, value);
    }

    @Override
    public Value remove(Key key) {
        return this.root().remove(this, key);
    }

    @Override
    public int size() {
        return this.root().size(this);
    }

    @Override
    public boolean isEmpty() {
        return this.root().isEmpty(this);
    }

    @Override
    public void clear() {
        this.root().clear(this);
    }

    public int getMinLeafDepth() {
        return this.root().getMinLeafDepth(this, 0);
    }

    public int getMaxLeafDepth() {
        return this.root().getMaxLeafDepth(this, 0);
    }

    public void printStructure(PrintWriter out) {
        this.root().printStructure(this, out, "", "");
    }

    public void printStructure(OutputStream out) {
        PrintWriter pw = new PrintWriter(out, false);
        this.root().printStructure(this, pw, "", "");
        pw.flush();
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator() {
        return this.root().iterator(this);
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator(Predicate<Key> predicate) {
        return this.root().iterator((BTreeIndex<Predicate<Key>, Value>)this, predicate);
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator(Key initialKey) {
        return this.root().iterator(this, initialKey);
    }

    @Override
    public void visit(IndexVisitor<Key, Value> visitor) {
        this.root().visit(this, visitor);
    }

    @Override
    public Map.Entry<Key, Value> getFirst() {
        return this.root().getFirst(this);
    }

    @Override
    public Map.Entry<Key, Value> getLast() {
        return this.root().getLast(this);
    }

    private BTreeNode<Key, Value> root() {
        return this.loadNode(null, this.page);
    }

    BTreeNode<Key, Value> createNode(BTreeNode<Key, Value> parent, BTreeNode.Data<Key, Value> data) {
        return new BTreeNode<Key, Value>(parent, this.paged.allocator().alloc(1), data);
    }

    BTreeNode<Key, Value> createNode(BTreeNode<Key, Value> parent) {
        return new BTreeNode<Key, Value>(parent, this.paged.allocator().alloc(1));
    }

    boolean storeNode(BTreeNode<Key, Value> node) {
        if (this.deferredEncoding) {
            int size = BTreeNode.estimatedSize(this, node.data);
            if (!node.allowPageOverflow() && (size += 9) > this.paged.getPageSize()) {
                return false;
            }
            this.paged.put(this.DATA_ENCODER_DECODER, node.getPage(), node.data);
            node.storedInExtent = true;
        } else {
            if (node.storedInExtent) {
                this.DATA_ENCODER_DECODER.pagesLinked(this.paged, node.page);
            }
            if (node.isLeaf()) {
                List<Integer> pages = this.DATA_ENCODER_DECODER.store(this.paged, node.page, node.data);
                if (!node.allowPageOverflow() && pages.size() > 1) {
                    this.DATA_ENCODER_DECODER.pagesLinked(this.paged, node.page);
                    node.storedInExtent = false;
                    return false;
                }
                node.storedInExtent = true;
            } else {
                DataByteArrayOutputStream os = new DataByteArrayOutputStream(this.paged.getPageSize()){

                    protected void resize(int newcount) {
                        throw new PageOverflowIOException();
                    }
                };
                try {
                    BTreeNode.write(os, this, node.data);
                    this.paged.write(node.page, os.toBuffer());
                    node.storedInExtent = false;
                }
                catch (IOException e) {
                    throw new IndexException("Could not write btree node");
                }
                catch (PageOverflowIOException e) {
                    return false;
                }
            }
        }
        return true;
    }

    BTreeNode<Key, Value> loadNode(BTreeNode<Key, Value> parent, int page) {
        BTreeNode<Key, Value> node = new BTreeNode<Key, Value>(parent, page);
        if (this.deferredEncoding) {
            node.data = (BTreeNode.Data)this.paged.get(this.DATA_ENCODER_DECODER, page);
            node.storedInExtent = true;
        } else {
            Buffer buffer = new Buffer(this.paged.getPageSize());
            this.paged.read(page, buffer);
            if (buffer.startsWith(Extent.DEFAULT_MAGIC)) {
                node.data = (BTreeNode.Data)this.DATA_ENCODER_DECODER.load(this.paged, page);
                node.storedInExtent = true;
            } else {
                DataByteArrayInputStream is = new DataByteArrayInputStream(buffer);
                try {
                    node.data = BTreeNode.read(is, this);
                    node.storedInExtent = false;
                }
                catch (IOException e) {
                    throw new IndexException("Could not read btree node");
                }
            }
        }
        return node;
    }

    void free(BTreeNode<Key, Value> node) {
        if (this.deferredEncoding) {
            this.paged.clear(this.DATA_ENCODER_DECODER, node.page);
        } else if (node.storedInExtent) {
            this.DATA_ENCODER_DECODER.pagesLinked(this.paged, node.page);
        }
        this.paged.free(node.page);
    }

    public Paged getPaged() {
        return this.paged;
    }

    @Override
    public int getIndexLocation() {
        return this.page;
    }

    public Codec<Key> getKeyMarshaller() {
        return this.keyCodec;
    }

    public Codec<Value> getValueMarshaller() {
        return this.valueCodec;
    }

    public Prefixer<Key> getPrefixer() {
        return this.prefixer;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public void destroy() {
        this.clear();
        this.paged.free(this.page);
    }

    static class PageOverflowIOException
    extends IndexException {
        PageOverflowIOException() {
        }
    }
}

