/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.api;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtdb.api.IOPagingException;
import org.fusesource.hawtdb.api.PageFile;
import org.fusesource.hawtdb.internal.io.MemoryMappedFileFactory;
import org.fusesource.hawtdb.internal.page.ExtentInputStream;
import org.fusesource.hawtdb.internal.page.ExtentOutputStream;
import org.fusesource.hawtdb.internal.page.HawtPageFile;
import org.fusesource.hawtdb.internal.util.Ranges;

public class PageFileFactory {
    static final AsciiBuffer HAWT_DB_PAGE_FILE_MAGIC;
    private final MemoryMappedFileFactory mappedFileFactory = new MemoryMappedFileFactory();
    private HawtPageFile pageFile;
    protected int headerSize = 0;
    protected short pageSize = (short)512;
    protected int maxPages = Integer.MAX_VALUE;
    protected boolean storeFreePages = true;

    public PageFile getPageFile() {
        return this.pageFile;
    }

    public void open() {
        if (this.pageFile == null) {
            if (this.pageSize <= 0) {
                throw new IllegalArgumentException("pageSize property must be greater than 0");
            }
            if (this.maxPages <= 0) {
                throw new IllegalArgumentException("maxPages property must be greater than 0");
            }
            if (this.headerSize < 0) {
                throw new IllegalArgumentException("headerSize property cannot be negative.");
            }
            if (this.storeFreePages && this.headerSize == 0) {
                this.headerSize = 512;
            }
            try {
                boolean recover = this.storeFreePages && this.getFile().exists() && this.getFile().length() > 512L;
                try {
                    this.mappedFileFactory.open();
                }
                catch (IOException e) {
                    throw new IOPagingException(e);
                }
                int freePageExtent = -1;
                if (this.storeFreePages && recover) {
                    Buffer header = new Buffer(512);
                    this.mappedFileFactory.getMemoryMappedFile().read(0L, header);
                    DataByteArrayInputStream his = new DataByteArrayInputStream(header);
                    Buffer magic = new Buffer(HAWT_DB_PAGE_FILE_MAGIC.length());
                    his.readFully(magic.data, magic.offset, magic.length());
                    if (!magic.ascii().equals(HAWT_DB_PAGE_FILE_MAGIC)) {
                        throw new IOPagingException("File's magic does not match expected value");
                    }
                    freePageExtent = his.readInt();
                    this.headerSize = his.readInt();
                    this.pageSize = his.readShort();
                }
                this.pageFile = new HawtPageFile(this.mappedFileFactory.getMemoryMappedFile(), this.pageSize, this.headerSize, this.maxPages, this.storeFreePages);
                if (freePageExtent >= 0) {
                    DataInputStream is = new DataInputStream(new ExtentInputStream(this.pageFile, freePageExtent));
                    this.pageFile.allocator().getFreeRanges().readExternal(is);
                    is.close();
                }
                if (this.pageFile.storeFreePages && !this.isReadOnly()) {
                    this.writePageFileHeader(-1);
                }
            }
            catch (IOException e) {
                throw new IOPagingException(e);
            }
        }
    }

    private void writePageFileHeader(int freePageExtent) throws IOException {
        DataByteArrayOutputStream os = new DataByteArrayOutputStream();
        os.write(HAWT_DB_PAGE_FILE_MAGIC);
        os.writeInt(freePageExtent);
        os.writeInt(this.headerSize);
        os.writeShort(this.pageSize);
        os.close();
        this.mappedFileFactory.getMemoryMappedFile().write(0L, os.toBuffer());
    }

    public void close() throws IOException {
        if (this.pageFile != null) {
            this.pageFile.flush();
            if (!this.isReadOnly() && this.pageFile.storeFreePages) {
                Ranges ranges = this.pageFile.allocator().getFreeRanges().copy();
                int freePageExtent = this.pageFile.alloc();
                DataOutputStream os = new DataOutputStream(new ExtentOutputStream(this.pageFile, freePageExtent, 1, 200));
                ranges.writeExternal(os);
                os.close();
                this.writePageFileHeader(freePageExtent);
            }
            this.pageFile.flush();
            this.pageFile = null;
        }
        this.mappedFileFactory.close();
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public void setHeaderSize(int headerSize) {
        this.headerSize = headerSize;
    }

    public short getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(short pageSize) {
        this.pageSize = pageSize;
    }

    public int getMaxPages() {
        return this.maxPages;
    }

    public void setMaxPages(int maxPages) {
        this.maxPages = maxPages;
    }

    public void setMaxFileSize(long size) {
        this.setMaxPages((int)((size - (long)this.getHeaderSize()) / (long)this.getPageSize()));
    }

    public File getFile() {
        return this.mappedFileFactory.getFile();
    }

    public int getMappingSegementSize() {
        return this.mappedFileFactory.getMappingSegementSize();
    }

    public void setFile(File file) {
        this.mappedFileFactory.setFile(file);
    }

    public void setMappingSegementSize(int mappingSegementSize) {
        this.mappedFileFactory.setMappingSegementSize(mappingSegementSize);
    }

    public boolean isStoreFreePages() {
        return this.storeFreePages;
    }

    public void setStoreFreePages(boolean storeFreePages) {
        this.storeFreePages = storeFreePages;
    }

    public boolean isReadOnly() {
        return this.mappedFileFactory.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.mappedFileFactory.setReadOnly(readOnly);
    }

    static {
        try {
            HAWT_DB_PAGE_FILE_MAGIC = new AsciiBuffer("HawtDB/PageFile/1.0".getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

