/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.api;

import java.util.Comparator;
import org.fusesource.hawtbuf.codec.Codec;
import org.fusesource.hawtbuf.codec.ObjectCodec;
import org.fusesource.hawtdb.api.IndexFactory;
import org.fusesource.hawtdb.api.Paged;
import org.fusesource.hawtdb.api.Prefixer;
import org.fusesource.hawtdb.api.SortedIndex;
import org.fusesource.hawtdb.internal.index.BTreeIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeIndexFactory<Key, Value>
implements IndexFactory<Key, Value> {
    private Codec<Key> keyCodec = new ObjectCodec<Key>();
    private Codec<Value> valueCodec = new ObjectCodec<Value>();
    private boolean deferredEncoding = true;
    private Prefixer<Key> prefixer;
    private Comparator comparator = null;

    @Override
    public SortedIndex<Key, Value> create(Paged paged) {
        BTreeIndex<Key, Value> index = this.createInstance(paged, paged.alloc());
        index.create();
        return index;
    }

    public String toString() {
        return "{ deferredEncoding: " + this.deferredEncoding + " }";
    }

    @Override
    public SortedIndex<Key, Value> open(Paged paged, int indexNumber) {
        return this.createInstance(paged, indexNumber);
    }

    @Override
    public SortedIndex<Key, Value> open(Paged paged) {
        return this.createInstance(paged, 0);
    }

    @Override
    public SortedIndex<Key, Value> openOrCreate(Paged paged) {
        if (paged.allocator().isAllocated(0)) {
            return this.createInstance(paged, 0);
        }
        BTreeIndex<Key, Value> index = this.createInstance(paged, paged.alloc());
        index.create();
        return index;
    }

    private BTreeIndex<Key, Value> createInstance(Paged paged, int page) {
        return new BTreeIndex(paged, page, this);
    }

    public Codec<Key> getKeyCodec() {
        return this.keyCodec;
    }

    public void setKeyCodec(Codec<Key> codec) {
        this.keyCodec = codec;
    }

    public Codec<Value> getValueCodec() {
        return this.valueCodec;
    }

    public void setValueCodec(Codec<Value> codec) {
        this.valueCodec = codec;
    }

    public boolean isDeferredEncoding() {
        return this.deferredEncoding;
    }

    public void setDeferredEncoding(boolean enable) {
        this.deferredEncoding = enable;
    }

    public Prefixer<Key> getPrefixer() {
        return this.prefixer;
    }

    public void setPrefixer(Prefixer<Key> prefixer) {
        this.prefixer = prefixer;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }
}

