/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.wso2;

import java.util.HashMap;
import java.util.Map;
import org.dna.mqtt.moquette.messaging.spi.impl.subscriptions.Subscription;
import org.dna.mqtt.moquette.messaging.spi.impl.subscriptions.SubscriptionsStore;
import org.dna.mqtt.wso2.Subscribers;

public class MQTTSubscriptionStore
extends SubscriptionsStore {
    private Map<String, Subscribers> localSubscriptions = new HashMap<String, Subscribers>();

    private void addLocalSubscription(Subscription newSubscription) {
        String topic = newSubscription.getTopic();
        String clientID = newSubscription.getClientId();
        Subscribers subscribers = this.localSubscriptions.get(topic);
        if (null == subscribers) {
            Subscribers subscriber = new Subscribers();
            subscriber.addNewSubscriber(clientID, newSubscription);
            this.localSubscriptions.put(topic, subscriber);
        } else {
            subscribers.addNewSubscriber(clientID, newSubscription);
        }
    }

    @Override
    protected void addDirect(Subscription newSubscription) {
        this.addLocalSubscription(newSubscription);
    }

    @Override
    public void add(Subscription newSubscription) {
        this.addLocalSubscription(newSubscription);
    }

    @Override
    public void removeSubscription(String topic, String clientID) {
        Subscribers subscribers = this.localSubscriptions.get(topic);
        subscribers.removeSubscription(clientID);
    }

    @Override
    public Subscription getSubscriptions(String subscribedTopic, String clientID) {
        Subscribers subscribers = this.localSubscriptions.get(subscribedTopic);
        return subscribers.getSubscriptionFromClientID(clientID);
    }

    @Override
    public void clearAllSubscriptions() {
        this.localSubscriptions.clear();
    }
}

