/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.wso2;

import io.netty.channel.Channel;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dna.mqtt.moquette.messaging.spi.impl.ProtocolProcessor;
import org.dna.mqtt.moquette.proto.messages.AbstractMessage;
import org.dna.mqtt.wso2.QOSLevel;
import org.wso2.andes.kernel.disruptor.inbound.PubAckHandler;
import org.wso2.andes.mqtt.MQTTException;
import org.wso2.andes.mqtt.MQTTMessageContext;
import org.wso2.andes.mqtt.MQTTopicManager;
import org.wso2.andes.mqtt.utils.MQTTUtils;

public final class AndesMQTTBridge {
    private static Log log = LogFactory.getLog(AndesMQTTBridge.class);
    private static ProtocolProcessor mqttProtocolHandlingEngine = null;
    private static AndesMQTTBridge instance = new AndesMQTTBridge();

    private AndesMQTTBridge() {
    }

    public static void initMQTTProtocolProcessor(ProtocolProcessor mqttProtocolProcessor) throws MQTTException {
        mqttProtocolHandlingEngine = mqttProtocolProcessor;
        MQTTopicManager.getInstance().initProtocolEngine(instance);
    }

    public static AndesMQTTBridge getBridgeInstance() throws MQTTException {
        if (null != mqttProtocolHandlingEngine) {
            return instance;
        }
        String message = "MQTT protocol reference has not being initialized, cannot establish connectivity";
        log.error((Object)"MQTT protocol reference has not being initialized, cannot establish connectivity");
        throw new MQTTException("MQTT protocol reference has not being initialized, cannot establish connectivity");
    }

    public void onClientDisconnection(String mqttClientChannelID, String topic, String username, SubscriptionEvent event) {
        try {
            MQTTopicManager.getInstance().removeOrDisconnectClient(mqttClientChannelID, topic, username, event);
        }
        catch (MQTTException e) {
            String message = "Error while disconnecting the client with the id " + mqttClientChannelID;
            log.error((Object)message, (Throwable)e);
        }
    }

    public static void onMessagePublished(String topic, int qosLevel, ByteBuffer message, boolean retain, int mqttLocalMessageID, String publisherID, PubAckHandler pubAckHandler, Channel channel) {
        try {
            QOSLevel qos = QOSLevel.getQoSFromValue(qosLevel);
            MQTTMessageContext messageContext = MQTTUtils.createMessageContext(topic, qos, message, retain, mqttLocalMessageID, publisherID, pubAckHandler, channel);
            MQTTopicManager.getInstance().addTopicMessage(messageContext);
        }
        catch (MQTTException e) {
            String error = "Error occurred while adding the message content for message id : " + mqttLocalMessageID;
            log.error((Object)error, (Throwable)e);
        }
    }

    public void onTopicSubscription(String topic, String mqttClientChannelID, String username, AbstractMessage.QOSType qos, boolean isCleanSession) {
        try {
            MQTTopicManager.getInstance().addTopicSubscription(topic, mqttClientChannelID, username, QOSLevel.getQoSFromValue(qos.getValue()), isCleanSession);
        }
        catch (MQTTException e) {
            String message = "Error occurred while subscription is initiated for topic : " + topic + " and session id :" + mqttClientChannelID;
            log.error((Object)message, (Throwable)e);
        }
    }

    public void onAckReceived(String mqttClientChannelID, int messageID) throws MQTTException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message ack received for message with id " + messageID + " and subscription " + mqttClientChannelID));
        }
        try {
            MQTTopicManager.getInstance().onMessageAck(mqttClientChannelID, messageID);
        }
        catch (MQTTException e) {
            String message = "Error occurred while the subscription ack was received for channel " + mqttClientChannelID + " and for message " + messageID;
            log.error((Object)message, (Throwable)e);
            throw e;
        }
    }

    public void distributeMessageToSubscriptions(String subscribeDestination, String messageDestination, int qos, ByteBuffer message, boolean retain, int messageID, String channelID) throws MQTTException {
        if (null != mqttProtocolHandlingEngine) {
            boolean bytesPosition = false;
            message.position(0);
            AbstractMessage.QOSType qosType = MQTTUtils.getQOSType(qos);
            mqttProtocolHandlingEngine.publishToSubscriber(subscribeDestination, messageDestination, qosType, message, retain, messageID, channelID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("The message with id " + messageID + " for destination " + messageDestination + " was notified to its subscribers"));
            }
        } else {
            String error = "The reference to the MQTT protocol has not being initialized, an attempt was made to deliver message ";
            log.error((Object)("The reference to the MQTT protocol has not being initialized, an attempt was made to deliver message " + messageID));
        }
    }

    public void onProcessPingRequest(String clientID) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ping request received for client id " + clientID));
        }
        MQTTopicManager.getInstance().processPingRequest(clientID);
    }

    public static enum SubscriptionEvent {
        DISCONNECT,
        UNSUBSCRIBE;

    }
}

