/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.moquette.server.netty.metrics;

import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.configuration.modules.JKSStore;
import org.wso2.andes.transport.ConnectionSettings;
import org.wso2.andes.transport.network.security.ssl.SSLUtil;

public class SSLHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(SSLHandlerFactory.class);
    private SSLContext sslContext;

    public SSLHandlerFactory(Properties props) {
        this.sslContext = this.initSSLContext(props);
    }

    public boolean canCreate() {
        return this.sslContext != null;
    }

    private SSLContext initSSLContext(Properties props) {
        try {
            ConnectionSettings sslConnectionSettings = this.constructConnectionSettings(props);
            SSLContext serverContext = SSLUtil.createSSLContext(sslConnectionSettings);
            return serverContext;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            log.error("Can't start SSL layer!", (Throwable)ex);
            return null;
        }
        catch (Exception e) {
            log.error("Error while establishing ssl server context ", (Throwable)e);
            return null;
        }
    }

    private ConnectionSettings constructConnectionSettings(Properties props) {
        ConnectionSettings connectionSettings = new ConnectionSettings();
        String sslTrustStoreLocation = ((JKSStore)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_SSL_CONNECTION_TRUSTSTORE)).getStoreLocation();
        String sslTrustStorePassword = ((JKSStore)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_SSL_CONNECTION_TRUSTSTORE)).getPassword();
        String trustStoreCertificateType = ((JKSStore)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_SSL_CONNECTION_TRUSTSTORE)).getStoreAlgorithm();
        String sslKeyStoreLocation = ((JKSStore)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_SSL_CONNECTION_KEYSTORE)).getStoreLocation();
        String sslKeyStorePassword = ((JKSStore)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_SSL_CONNECTION_KEYSTORE)).getPassword();
        String keyStoreCertificateType = ((JKSStore)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_SSL_CONNECTION_KEYSTORE)).getStoreAlgorithm();
        connectionSettings.setTrustStorePath(sslTrustStoreLocation);
        connectionSettings.setTrustStorePassword(sslTrustStorePassword);
        connectionSettings.setTrustStoreCertType(trustStoreCertificateType);
        connectionSettings.setKeyStorePath(sslKeyStoreLocation);
        connectionSettings.setKeyStorePassword(sslKeyStorePassword);
        connectionSettings.setKeyStoreCertType(keyStoreCertificateType);
        return connectionSettings;
    }

    public ChannelHandler create() {
        String ciphers;
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        sslEngine.setUseClientMode(false);
        String protocols = (String)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_SSL_CONNECTION_PROTOCOLS);
        if (!protocols.isEmpty()) {
            sslEngine.setEnabledProtocols(protocols.split(","));
        }
        if (!(ciphers = (String)AndesConfigurationManager.readValue(AndesConfiguration.TRANSPORTS_MQTT_SSL_CONNECTION_CIPHERS)).isEmpty()) {
            sslEngine.setEnabledCipherSuites(ciphers.split(","));
        }
        return new SslHandler(sslEngine);
    }
}

