/*
 * Decompiled with CFR 0.152.
 */
package org.dna.mqtt.moquette.server.netty.metrics;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dna.mqtt.moquette.server.netty.metrics.MessageMetrics;
import org.dna.mqtt.moquette.server.netty.metrics.MessageMetricsCollector;

public class MessageMetricsHandler
extends ChannelDuplexHandler {
    private static final AttributeKey<MessageMetrics> ATTR_KEY_METRICS = new AttributeKey("MessageMetrics");
    private MessageMetricsCollector m_collector;
    private static Log log = LogFactory.getLog(MessageMetricsHandler.class);

    public MessageMetricsHandler(MessageMetricsCollector collector) {
        this.m_collector = collector;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Attribute attr = ctx.attr(ATTR_KEY_METRICS);
        attr.set((Object)new MessageMetrics());
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        MessageMetrics metrics = (MessageMetrics)ctx.attr(ATTR_KEY_METRICS).get();
        metrics.incrementRead(1L);
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        MessageMetrics metrics = (MessageMetrics)ctx.attr(ATTR_KEY_METRICS).get();
        metrics.incrementWrote(1L);
        ctx.write(msg, promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        MessageMetrics metrics = (MessageMetrics)ctx.attr(ATTR_KEY_METRICS).get();
        this.m_collector.addMetrics(metrics);
        super.close(ctx, promise);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error((Object)cause.getMessage(), cause);
        ctx.close();
    }
}

